/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.core.CreativeTabForestry;
import forestry.core.config.ForestryItem;
import forestry.core.render.TextureManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class BlockResourceOre
extends Block {
    @SideOnly(value=Side.CLIENT)
    private IIcon iconApatite;
    @SideOnly(value=Side.CLIENT)
    private IIcon iconCopper;
    @SideOnly(value=Side.CLIENT)
    private IIcon iconTin;

    public BlockResourceOre() {
        super(Material.rock);
        this.setHardness(3.0f);
        this.setResistance(5.0f);
        this.setCreativeTab(CreativeTabForestry.tabForestry);
    }

    public void dropBlockAsItemWithChance(World world, int x, int y, int z, int metadata, float par6, int par7) {
        super.dropBlockAsItemWithChance(world, x, y, z, metadata, par6, par7);
        if (metadata == 0) {
            this.dropXpOnBlockBreak(world, x, y, z, MathHelper.getRandomIntegerInRange((Random)world.rand, (int)1, (int)4));
        }
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        if (metadata == 0) {
            int amount;
            int fortuneModifier = world.rand.nextInt(fortune + 2) - 1;
            if (fortuneModifier < 0) {
                fortuneModifier = 0;
            }
            if ((amount = (2 + world.rand.nextInt(5)) * (fortuneModifier + 1)) > 0) {
                drops.add(ForestryItem.apatite.getItemStack(amount));
            }
        } else {
            drops.add(new ItemStack((Block)this, 1, metadata));
        }
        return drops;
    }

    public int getDamageValue(World world, int x, int y, int z) {
        return world.getBlockMetadata(x, y, z);
    }

    public int damageDropped(int meta) {
        return meta;
    }

    public void getSubBlocks(Item item, CreativeTabs par2CreativeTabs, List itemList) {
        itemList.add(new ItemStack((Block)this, 1, 0));
        itemList.add(new ItemStack((Block)this, 1, 1));
        itemList.add(new ItemStack((Block)this, 1, 2));
    }

    @SideOnly(value=Side.CLIENT)
    public void registerBlockIcons(IIconRegister register) {
        this.iconApatite = TextureManager.getInstance().registerTex(register, "ores/apatite");
        this.iconCopper = TextureManager.getInstance().registerTex(register, "ores/copper");
        this.iconTin = TextureManager.getInstance().registerTex(register, "ores/tin");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(int i, int j) {
        if (j == 0) {
            return this.iconApatite;
        }
        if (j == 1) {
            return this.iconCopper;
        }
        if (j == 2) {
            return this.iconTin;
        }
        return null;
    }
}

