/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.tiles;

import buildcraft.api.statements.ITriggerExternal;
import com.google.common.collect.ImmutableMap;
import cpw.mods.fml.common.Optional;
import forestry.api.circuits.ChipsetManager;
import forestry.api.circuits.ICircuitBoard;
import forestry.api.core.ForestryAPI;
import forestry.api.core.IErrorLogic;
import forestry.api.recipes.ICentrifugeManager;
import forestry.api.recipes.ICentrifugeRecipe;
import forestry.core.circuits.ISocketable;
import forestry.core.config.Config;
import forestry.core.errors.EnumErrorCode;
import forestry.core.inventory.IInventoryAdapter;
import forestry.core.inventory.InventoryAdapter;
import forestry.core.inventory.TileInventoryAdapter;
import forestry.core.network.DataInputStreamForestry;
import forestry.core.network.DataOutputStreamForestry;
import forestry.core.network.GuiId;
import forestry.core.tiles.TilePowered;
import forestry.core.utils.InventoryUtil;
import forestry.core.utils.ItemStackUtil;
import forestry.core.utils.SlotUtil;
import forestry.factory.triggers.FactoryTriggers;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.Stack;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class TileCentrifuge
extends TilePowered
implements ISocketable,
ISidedInventory {
    private static final int TICKS_PER_RECIPE_TIME = 4;
    private static final int ENERGY_PER_RECIPE_TIME = 210;
    private final InventoryAdapter sockets = new InventoryAdapter(1, "sockets");
    public static final int SLOT_RESOURCE = 0;
    public static final int SLOT_PRODUCT_1 = 1;
    public static final int SLOT_PRODUCT_COUNT = 9;
    private ICentrifugeRecipe currentRecipe;
    private final Stack<ItemStack> pendingProducts = new Stack();

    public TileCentrifuge() {
        super(800, 5000, 4200);
        this.setInternalInventory(new CentrifugeInventoryAdapter(this));
        this.setHints(Config.hints.get("centrifuge"));
    }

    @Override
    public void openGui(EntityPlayer player) {
        player.openGui(ForestryAPI.instance, GuiId.CentrifugeGUI.ordinal(), player.worldObj, this.xCoord, this.yCoord, this.zCoord);
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        this.sockets.writeToNBT(nbttagcompound);
        NBTTagList nbttaglist = new NBTTagList();
        ItemStack[] offspring = this.pendingProducts.toArray(new ItemStack[this.pendingProducts.size()]);
        for (int i = 0; i < offspring.length; ++i) {
            if (offspring[i] == null) continue;
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.setByte("Slot", (byte)i);
            offspring[i].writeToNBT(nbttagcompound1);
            nbttaglist.appendTag((NBTBase)nbttagcompound1);
        }
        nbttagcompound.setTag("PendingProducts", (NBTBase)nbttaglist);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        ICircuitBoard chipset;
        super.readFromNBT(nbttagcompound);
        NBTTagList nbttaglist = nbttagcompound.getTagList("PendingProducts", 10);
        for (int i = 0; i < nbttaglist.tagCount(); ++i) {
            NBTTagCompound nbttagcompound1 = nbttaglist.getCompoundTagAt(i);
            this.pendingProducts.add(ItemStack.loadItemStackFromNBT((NBTTagCompound)nbttagcompound1));
        }
        this.sockets.readFromNBT(nbttagcompound);
        ItemStack chip = this.sockets.getStackInSlot(0);
        if (chip != null && (chipset = ChipsetManager.circuitRegistry.getCircuitboard(chip)) != null) {
            chipset.onLoad(this);
        }
    }

    @Override
    public void writeGuiData(DataOutputStreamForestry data) throws IOException {
        super.writeGuiData(data);
        this.sockets.writeData(data);
    }

    @Override
    public void readGuiData(DataInputStreamForestry data) throws IOException {
        super.readGuiData(data);
        this.sockets.readData(data);
    }

    @Override
    public boolean workCycle() {
        if (this.tryAddPending()) {
            return false;
        }
        if (!this.pendingProducts.isEmpty()) {
            return false;
        }
        if (this.currentRecipe == null) {
            return false;
        }
        Collection<ItemStack> products = this.currentRecipe.getProducts(this.worldObj.rand);
        this.pendingProducts.addAll(products);
        this.getInternalInventory().decrStackSize(0, 1);
        this.tryAddPending();
        return true;
    }

    private void checkRecipe() {
        ItemStack resource = this.getStackInSlot(0);
        ICentrifugeRecipe matchingRecipe = RecipeManager.findMatchingRecipe(resource);
        if (this.currentRecipe != matchingRecipe) {
            this.currentRecipe = matchingRecipe;
            if (this.currentRecipe != null) {
                int recipeTime = this.currentRecipe.getProcessingTime();
                this.setTicksPerWorkCycle(recipeTime * 4);
                this.setEnergyPerWorkCycle(recipeTime * 210);
            }
        }
    }

    private boolean tryAddPending() {
        if (this.pendingProducts.isEmpty()) {
            return false;
        }
        ItemStack next = this.pendingProducts.peek();
        boolean added = InventoryUtil.tryAddStack((IInventory)this, next, 1, 9, true);
        if (added) {
            this.pendingProducts.pop();
        }
        this.getErrorLogic().setCondition(!added, EnumErrorCode.NOSPACE);
        return added;
    }

    @Override
    public boolean hasResourcesMin(float percentage) {
        IInventoryAdapter inventory = this.getInternalInventory();
        if (inventory.getStackInSlot(0) == null) {
            return false;
        }
        return (float)inventory.getStackInSlot((int)0).stackSize / (float)inventory.getStackInSlot(0).getMaxStackSize() > percentage;
    }

    @Override
    public boolean hasWork() {
        this.checkRecipe();
        boolean hasResource = this.getStackInSlot(0) != null;
        IErrorLogic errorLogic = this.getErrorLogic();
        errorLogic.setCondition(!hasResource, EnumErrorCode.NORESOURCE);
        return hasResource;
    }

    @Override
    @Optional.Method(modid="BuildCraftAPI|statements")
    public Collection<ITriggerExternal> getExternalTriggers(ForgeDirection side, TileEntity tile) {
        LinkedList<ITriggerExternal> res = new LinkedList<ITriggerExternal>();
        res.add(FactoryTriggers.lowResource25);
        res.add(FactoryTriggers.lowResource10);
        return res;
    }

    @Override
    public int getSocketCount() {
        return this.sockets.getSizeInventory();
    }

    @Override
    public ItemStack getSocket(int slot) {
        return this.sockets.getStackInSlot(slot);
    }

    @Override
    public void setSocket(int slot, ItemStack stack) {
        ICircuitBoard chipset;
        if (stack != null && !ChipsetManager.circuitRegistry.isChipset(stack)) {
            return;
        }
        if (this.sockets.getStackInSlot(slot) != null && ChipsetManager.circuitRegistry.isChipset(this.sockets.getStackInSlot(slot)) && (chipset = ChipsetManager.circuitRegistry.getCircuitboard(this.sockets.getStackInSlot(slot))) != null) {
            chipset.onRemoval(this);
        }
        this.sockets.setInventorySlotContents(slot, stack);
        if (stack == null) {
            return;
        }
        chipset = ChipsetManager.circuitRegistry.getCircuitboard(stack);
        if (chipset != null) {
            chipset.onInsertion(this);
        }
    }

    public static class RecipeManager
    implements ICentrifugeManager {
        public static final List<ICentrifugeRecipe> recipes = new ArrayList<ICentrifugeRecipe>();

        @Override
        public void addRecipe(ICentrifugeRecipe recipe) {
            recipes.add(recipe);
        }

        @Override
        public void addRecipe(int timePerItem, ItemStack resource, Map<ItemStack, Float> products) {
            CentrifugeRecipe recipe = new CentrifugeRecipe(timePerItem, resource, products);
            this.addRecipe(recipe);
        }

        public static ICentrifugeRecipe findMatchingRecipe(ItemStack itemStack) {
            if (itemStack == null) {
                return null;
            }
            for (ICentrifugeRecipe recipe : recipes) {
                ItemStack recipeInput = recipe.getInput();
                if (!ItemStackUtil.isCraftingEquivalent(recipeInput, itemStack)) continue;
                return recipe;
            }
            return null;
        }

        @Override
        public Map<Object[], Object[]> getRecipes() {
            HashMap<Object[], Object[]> recipeList = new HashMap<Object[], Object[]>();
            for (ICentrifugeRecipe recipe : recipes) {
                Set<ItemStack> productsKeys = recipe.getAllProducts().keySet();
                recipeList.put(new Object[]{recipe.getInput()}, productsKeys.toArray(new ItemStack[productsKeys.size()]));
            }
            return recipeList;
        }
    }

    public static class CentrifugeRecipe
    implements ICentrifugeRecipe {
        private final int processingTime;
        private final ItemStack input;
        private final Map<ItemStack, Float> outputs;

        public CentrifugeRecipe(int processingTime, ItemStack input, Map<ItemStack, Float> outputs) {
            this.processingTime = processingTime;
            this.input = input;
            this.outputs = outputs;
            for (ItemStack item : outputs.keySet()) {
                if (item != null) continue;
                throw new IllegalArgumentException("Tried to register a null product of " + input);
            }
        }

        @Override
        public ItemStack getInput() {
            return this.input;
        }

        @Override
        public int getProcessingTime() {
            return this.processingTime;
        }

        @Override
        public Collection<ItemStack> getProducts(Random random) {
            ArrayList<ItemStack> products = new ArrayList<ItemStack>();
            for (Map.Entry<ItemStack, Float> entry : this.outputs.entrySet()) {
                float probability = entry.getValue().floatValue();
                if ((double)probability >= 1.0) {
                    products.add(entry.getKey().copy());
                    continue;
                }
                if (!(random.nextFloat() < probability)) continue;
                products.add(entry.getKey().copy());
            }
            return products;
        }

        @Override
        public Map<ItemStack, Float> getAllProducts() {
            return ImmutableMap.copyOf(this.outputs);
        }
    }

    private static class CentrifugeInventoryAdapter
    extends TileInventoryAdapter<TileCentrifuge> {
        public CentrifugeInventoryAdapter(TileCentrifuge centrifuge) {
            super(centrifuge, 10, "Items");
        }

        @Override
        public boolean canSlotAccept(int slotIndex, ItemStack itemStack) {
            return slotIndex == 0 && RecipeManager.findMatchingRecipe(itemStack) != null;
        }

        @Override
        public boolean canExtractItem(int slotIndex, ItemStack itemstack, int side) {
            return SlotUtil.isSlotInRange(slotIndex, 1, 9);
        }
    }
}

