/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.inventory;

import forestry.core.config.Constants;
import forestry.core.inventory.IInventoryAdapter;
import forestry.core.inventory.InventoryPlain;
import forestry.core.network.DataInputStreamForestry;
import forestry.core.network.DataOutputStreamForestry;
import forestry.core.network.IStreamable;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class InventoryAdapter
implements IInventoryAdapter,
IStreamable {
    private final IInventory inventory;
    private boolean allowAutomation = true;
    private int[][] slotMap;

    public InventoryAdapter(int size, String name) {
        this(size, name, 64);
    }

    public InventoryAdapter(int size, String name, int stackLimit) {
        this(new InventoryPlain(size, name, stackLimit));
    }

    public InventoryAdapter(IInventory inventory) {
        this.inventory = inventory;
        this.configureSided();
    }

    public InventoryAdapter disableAutomation() {
        this.allowAutomation = false;
        return this;
    }

    public InventoryAdapter copy() {
        InventoryAdapter copy = new InventoryAdapter(this.inventory.getSizeInventory(), this.inventory.getInventoryName(), this.inventory.getInventoryStackLimit());
        for (int i = 0; i < this.inventory.getSizeInventory(); ++i) {
            if (this.inventory.getStackInSlot(i) == null) continue;
            copy.setInventorySlotContents(i, this.inventory.getStackInSlot(i).copy());
        }
        return copy;
    }

    public int getSizeInventory() {
        return this.inventory.getSizeInventory();
    }

    public ItemStack getStackInSlot(int slotId) {
        return this.inventory.getStackInSlot(slotId);
    }

    public ItemStack decrStackSize(int slotId, int count) {
        return this.inventory.decrStackSize(slotId, count);
    }

    public void setInventorySlotContents(int slotId, ItemStack itemstack) {
        this.inventory.setInventorySlotContents(slotId, itemstack);
    }

    public String getInventoryName() {
        return this.inventory.getInventoryName();
    }

    public int getInventoryStackLimit() {
        return this.inventory.getInventoryStackLimit();
    }

    public void markDirty() {
        this.inventory.markDirty();
    }

    public ItemStack getStackInSlotOnClosing(int slotIndex) {
        return this.inventory.getStackInSlotOnClosing(slotIndex);
    }

    public boolean isUseableByPlayer(EntityPlayer entityplayer) {
        return true;
    }

    public boolean hasCustomInventoryName() {
        return true;
    }

    public boolean isItemValidForSlot(int i, ItemStack itemstack) {
        return true;
    }

    @Override
    public boolean canSlotAccept(int slotIndex, ItemStack itemStack) {
        return true;
    }

    @Override
    public boolean isLocked(int slotIndex) {
        return false;
    }

    public void openInventory() {
    }

    public void closeInventory() {
    }

    public int[] getAccessibleSlotsFromSide(int side) {
        if (this.allowAutomation) {
            return this.slotMap[side];
        }
        return Constants.SLOTS_NONE;
    }

    private void configureSided() {
        this.slotMap = new int[6][0];
        int count = this.getSizeInventory();
        int[] slots = new int[count];
        for (int i = 0; i < count; ++i) {
            slots[i] = i;
        }
        for (int side : Constants.FACINGS) {
            this.slotMap[side] = slots;
        }
    }

    public boolean canInsertItem(int slot, ItemStack stack, int side) {
        return this.isItemValidForSlot(slot, stack);
    }

    public boolean canExtractItem(int slot, ItemStack stack, int side) {
        return false;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        if (!nbttagcompound.hasKey(this.inventory.getInventoryName())) {
            return;
        }
        NBTTagList nbttaglist = nbttagcompound.getTagList(this.inventory.getInventoryName(), 10);
        for (int j = 0; j < nbttaglist.tagCount(); ++j) {
            NBTTagCompound nbttagcompound2 = nbttaglist.getCompoundTagAt(j);
            byte index = nbttagcompound2.getByte("Slot");
            this.inventory.setInventorySlotContents((int)index, ItemStack.loadItemStackFromNBT((NBTTagCompound)nbttagcompound2));
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.inventory.getSizeInventory(); ++i) {
            if (this.inventory.getStackInSlot(i) == null) continue;
            NBTTagCompound nbttagcompound2 = new NBTTagCompound();
            nbttagcompound2.setByte("Slot", (byte)i);
            this.inventory.getStackInSlot(i).writeToNBT(nbttagcompound2);
            nbttaglist.appendTag((NBTBase)nbttagcompound2);
        }
        nbttagcompound.setTag(this.inventory.getInventoryName(), (NBTBase)nbttaglist);
    }

    @Override
    public void writeData(DataOutputStreamForestry data) throws IOException {
        data.writeInventory(this.inventory);
    }

    @Override
    public void readData(DataInputStreamForestry data) throws IOException {
        data.readInventory(this.inventory);
    }
}

