/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.genetics.alleles;

import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.genetics.IEffectData;
import forestry.apiculture.genetics.alleles.AlleleEffectThrottled;
import forestry.core.utils.DamageSourceForestry;
import java.util.List;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;

public class AlleleEffectAggressive
extends AlleleEffectThrottled {
    private static final DamageSource damageSourceBeeAggressive = new DamageSourceForestry("bee.aggressive");

    public AlleleEffectAggressive() {
        super("aggressive", true, 40, false, false);
    }

    @Override
    public IEffectData doEffectThrottled(IBeeGenome genome, IEffectData storedData, IBeeHousing housing) {
        AxisAlignedBB hurtBox = this.getBounding(genome, housing);
        List list = housing.getWorld().getEntitiesWithinAABB(EntityLivingBase.class, hurtBox);
        for (Object obj : list) {
            EntityLivingBase entity = (EntityLivingBase)obj;
            int damage = 4;
            if (entity instanceof EntityPlayer) {
                int count = BeeManager.armorApiaristHelper.wearsItems((EntityPlayer)entity, this.getUID(), true);
                if (count > 3) continue;
                if (count > 2) {
                    damage = 1;
                } else if (count > 1) {
                    damage = 2;
                } else if (count > 0) {
                    damage = 3;
                }
            }
            entity.attackEntityFrom(damageSourceBeeAggressive, (float)damage);
        }
        return storedData;
    }
}

