/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.items;

import com.google.common.collect.ImmutableSet;
import forestry.api.core.IErrorSource;
import forestry.api.core.IErrorState;
import forestry.core.config.ForestryItem;
import forestry.core.errors.EnumErrorCode;
import forestry.core.inventory.ItemInventory;
import forestry.core.items.ItemInventoried;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;

public abstract class ItemAlyzer
extends ItemInventoried {

    public static abstract class AlyzerInventory
    extends ItemInventory
    implements IErrorSource {
        public static final int SLOT_SPECIMEN = 0;
        public static final int SLOT_ANALYZE_1 = 1;
        public static final int SLOT_ANALYZE_2 = 2;
        public static final int SLOT_ANALYZE_3 = 3;
        public static final int SLOT_ANALYZE_4 = 4;
        public static final int SLOT_ANALYZE_5 = 6;
        public static final int SLOT_ENERGY = 5;

        public AlyzerInventory(EntityPlayer player, int size, ItemStack itemstack) {
            super(player, size, itemstack);
        }

        protected static boolean isEnergy(ItemStack itemstack) {
            if (itemstack == null || itemstack.stackSize <= 0) {
                return false;
            }
            return ForestryItem.honeyDrop.isItemEqual(itemstack) || ForestryItem.honeydew.isItemEqual(itemstack);
        }

        private boolean hasSpecimen() {
            for (int i = 0; i <= 6; ++i) {
                ItemStack itemStack;
                if (i == 5 || (itemStack = this.getStackInSlot(i)) == null) continue;
                return true;
            }
            return false;
        }

        protected abstract boolean isSpecimen(ItemStack var1);

        @Override
        public boolean canSlotAccept(int slotIndex, ItemStack itemStack) {
            if (slotIndex == 5) {
                return AlyzerInventory.isEnergy(itemStack);
            }
            return !this.hasSpecimen() && this.isSpecimen(itemStack);
        }

        @Override
        public final ImmutableSet<IErrorState> getErrorStates() {
            ImmutableSet.Builder errorStates = ImmutableSet.builder();
            if (!this.hasSpecimen()) {
                errorStates.add((Object)EnumErrorCode.NOTHINGANALYZE);
            }
            if (!AlyzerInventory.isEnergy(this.getStackInSlot(5))) {
                errorStates.add((Object)EnumErrorCode.NOHONEY);
            }
            return errorStates.build();
        }
    }
}

