/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.worldgen;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public class WorldGenBigMushroom
extends WorldGenerator {
    private final Block mushroom;

    public WorldGenBigMushroom(Block block) {
        this.mushroom = block;
    }

    public WorldGenBigMushroom() {
        this.mushroom = null;
    }

    public boolean generate(World world, Random random, int x, int y, int z) {
        int i;
        Block type = this.mushroom;
        if (type == null) {
            type = random.nextBoolean() ? Blocks.brown_mushroom_block : Blocks.red_mushroom_block;
        }
        int height = random.nextInt(1) + 2;
        boolean flag = true;
        if (y < 1 || y + height + 1 > 256) {
            return false;
        }
        for (int i2 = y; i2 <= y + 1 + height; ++i2) {
            int offset = 3;
            if (i2 == y) {
                offset = 0;
            }
            for (int j = x - offset; j <= x + offset && flag; ++j) {
                for (int k = z - offset; k <= z + offset && flag; ++k) {
                    if (i2 >= 0 && i2 < 256) {
                        Block block = world.getBlock(j, i2, k);
                        if (block.isAir((IBlockAccess)world, j, i2, k) || block == Blocks.leaves) continue;
                        flag = false;
                        continue;
                    }
                    flag = false;
                }
            }
        }
        if (!flag) {
            return false;
        }
        Block ground = world.getBlock(x, y - 1, z);
        if (ground != Blocks.mycelium) {
            return false;
        }
        if (!Blocks.brown_mushroom.canPlaceBlockAt(world, x, y, z)) {
            return false;
        }
        this.func_150515_a(world, x, y - 1, z, Blocks.dirt);
        int capStartY = y + height;
        if (type == Blocks.red_mushroom_block) {
            capStartY = y + height - 1;
        }
        for (i = capStartY; i <= y + height; ++i) {
            int capRad = 1;
            if (type == Blocks.brown_mushroom_block) {
                capRad = 1;
            }
            for (int j = x - capRad; j <= x + capRad; ++j) {
                for (int k = z - capRad; k <= z + capRad; ++k) {
                    int remain = 5;
                    if (j == x - capRad) {
                        --remain;
                    }
                    if (j == x + capRad) {
                        ++remain;
                    }
                    if (k == z - capRad) {
                        remain -= 3;
                    }
                    if (k == z + capRad) {
                        remain += 3;
                    }
                    if (type == Blocks.brown_mushroom_block || i < y + height) {
                        if (j == x - (capRad - 1) && k == z - capRad) {
                            remain = 1;
                        }
                        if (j == x - capRad && k == z - (capRad - 1)) {
                            remain = 1;
                        }
                        if (j == x + (capRad - 1) && k == z - capRad) {
                            remain = 3;
                        }
                        if (j == x + capRad && k == z - (capRad - 1)) {
                            remain = 3;
                        }
                        if (j == x - (capRad - 1) && k == z + capRad) {
                            remain = 7;
                        }
                        if (j == x - capRad && k == z + (capRad - 1)) {
                            remain = 7;
                        }
                        if (j == x + (capRad - 1) && k == z + capRad) {
                            remain = 9;
                        }
                        if (j == x + capRad && k == z + (capRad - 1)) {
                            remain = 9;
                        }
                    }
                    if (remain == 5 && i < y + height) {
                        remain = 0;
                    }
                    if (remain == 0 && y < y + height - 1 || world.getBlock(j, i, k).isOpaqueCube()) continue;
                    this.setBlockAndNotifyAdequately(world, j, i, k, type, remain);
                }
            }
        }
        for (i = 0; i < height; ++i) {
            Block block = world.getBlock(x, y + i, z);
            if (block.isOpaqueCube()) continue;
            this.setBlockAndNotifyAdequately(world, x, y + i, z, type, 10);
        }
        return true;
    }
}

