/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.config;

import forestry.Forestry;
import forestry.api.core.ForestryAPI;
import forestry.api.core.IGameMode;
import forestry.core.config.Config;
import forestry.core.config.ForestryBlock;
import forestry.core.config.ForestryItem;
import forestry.core.config.LocalizedConfiguration;
import forestry.core.config.deprecated.Property;
import forestry.core.utils.Log;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;

public class GameMode
implements IGameMode {
    private static final String GAMEMODE_KEY = "gamemode";
    private String identifier = "EASY";
    private final String category;
    private final Map<String, Boolean> booleanSettings = new HashMap<String, Boolean>();
    private final Map<String, Integer> integerSettings = new HashMap<String, Integer>();
    private final Map<String, Float> floatSettings = new HashMap<String, Float>();
    private final Map<String, ItemStack> stackSettings = new HashMap<String, ItemStack>();
    private static final float ENERGY_DEMAND_MODIFIER = 1.0f;
    private static final float FUEL_MODIFIER = 1.0f;
    private static final int FARM_FERTILIZER_VALUE = 2000;
    private final ItemStack recipeFertilizerOutputApatite = ForestryItem.fertilizerCompound.getItemStack(8);
    private final ItemStack recipeFertilizerOutputAsh = ForestryItem.fertilizerCompound.getItemStack(16);
    private final ItemStack recipeCompostOutputWheat = ForestryItem.fertilizerBio.getItemStack(4);
    private final ItemStack recipeCompostOutputAsh = ForestryItem.fertilizerBio.getItemStack(1);
    private final ItemStack recipeHumusOutputFertilizer = ForestryBlock.soil.getItemStack(8);
    private final ItemStack recipeHumusOutputCompost = ForestryBlock.soil.getItemStack(8);
    private final ItemStack recipeBogEarthOutputBucket = ForestryBlock.soil.getItemStack(6, 1);
    private final ItemStack recipeBogEarthOutputCans = ForestryBlock.soil.getItemStack(8, 1);
    private final ItemStack recipeCanOutput = ForestryItem.canEmpty.getItemStack(12);
    private final ItemStack recipeCapsuleOutput = ForestryItem.waxCapsule.getItemStack(4);
    private final ItemStack recipeRefractoryOutput = ForestryItem.refractoryEmpty.getItemStack(4);
    private static final int FERMENTATION_DURATION_FERTILIZER = 200;
    private static final int FERMENTATION_DURATION_COMPOST = 250;
    private static final int FERMENTED_CYCLE_FERTILIZER = 56;
    private static final int FERMENTED_CYCLE_COMPOST = 48;
    private static final int FERMENTED_SAPLING = 250;
    private static final int FERMENTED_CACTI = 50;
    private static final int FERMENTED_WHEAT = 50;
    private static final int FERMENTED_CANE = 50;
    private static final int FERMENTED_MUSHROOM = 50;
    private static final int SQUEEZED_LIQUID_SEED = 10;
    private static final int SQUEEZED_LIQUID_APPLE = 200;
    private static final int SQUEEZED_MULCH_APPLE = 20;

    public static IGameMode getGameMode() {
        if (ForestryAPI.activeMode == null) {
            ForestryAPI.activeMode = new GameMode(Config.gameMode);
        }
        return ForestryAPI.activeMode;
    }

    public GameMode(String identifier) {
        this.identifier = identifier;
        this.category = "gamemodes/" + identifier;
        String oldConfig = this.category + ".conf";
        String newConfig = this.category + ".cfg";
        File newConfigFile = new File(Forestry.instance.getConfigFolder(), newConfig);
        File oldConfigFile = new File(Forestry.instance.getConfigFolder(), oldConfig);
        if (oldConfigFile.exists()) {
            this.loadOldConfig();
            String oldConfigRenamed = this.category + ".conf.old";
            File oldConfigFileRenamed = new File(Forestry.instance.getConfigFolder(), oldConfigRenamed);
            if (oldConfigFile.renameTo(oldConfigFileRenamed)) {
                Log.info("Migrated " + this.category + " settings to the new file '" + newConfig + "' and renamed '" + oldConfig + "' to '" + oldConfigRenamed + "'.");
            }
        }
        LocalizedConfiguration config = new LocalizedConfiguration(newConfigFile, "1.0.0");
        this.initSettingFloat(config, "energy", "demand.modifier", 1.0f);
        this.initSettingBoolean(config, "energy", "engine.clockwork", true);
        this.initSettingInt(config, "farms", "fertilizer.value", 2000);
        this.initSettingFloat(config, "fuel.ethanol", "generator", 1.0f);
        this.initSettingFloat(config, "fuel.ethanol", "combustion", 1.0f);
        this.initSettingFloat(config, "fuel.biomass", "generator", 1.0f);
        this.initSettingFloat(config, "fuel.biomass", "biogas", 1.0f);
        this.initSettingStack(config, "recipe.output.fertilizer", "apatite", this.recipeFertilizerOutputApatite);
        this.initSettingStack(config, "recipe.output.fertilizer", "ash", this.recipeFertilizerOutputAsh);
        this.initSettingStack(config, "recipe.output.compost", "wheat", this.recipeCompostOutputWheat);
        this.initSettingStack(config, "recipe.output.compost", "ash", this.recipeCompostOutputAsh);
        this.initSettingStack(config, "recipe.output.humus", "fertilizer", this.recipeHumusOutputFertilizer);
        this.initSettingStack(config, "recipe.output.humus", "compost", this.recipeHumusOutputCompost);
        this.initSettingStack(config, "recipe.output.bogearth", "bucket", this.recipeBogEarthOutputBucket);
        this.initSettingStack(config, "recipe.output.bogearth", "can", this.recipeBogEarthOutputCans);
        this.initSettingStack(config, "recipe.output", "can", this.recipeCanOutput);
        this.initSettingStack(config, "recipe.output", "capsule", this.recipeCapsuleOutput);
        this.initSettingStack(config, "recipe.output", "refractory", this.recipeRefractoryOutput);
        this.initSettingInt(config, "fermenter.cycles", "fertilizer", 200);
        this.initSettingInt(config, "fermenter.cycles", "compost", 250);
        this.initSettingInt(config, "fermenter.value", "fertilizer", 56);
        this.initSettingInt(config, "fermenter.value", "compost", 48);
        this.initSettingInt(config, "fermenter.yield", "sapling", 250);
        this.initSettingInt(config, "fermenter.yield", "cactus", 50);
        this.initSettingInt(config, "fermenter.yield", "wheat", 50);
        this.initSettingInt(config, "fermenter.yield", "cane", 50);
        this.initSettingInt(config, "fermenter.yield", "mushroom", 50);
        this.initSettingInt(config, "squeezer.liquid", "seed", 10);
        this.initSettingInt(config, "squeezer.liquid", "apple", 200);
        this.initSettingInt(config, "squeezer.mulch", "apple", 20);
        config.save();
    }

    private void loadOldConfig() {
        this.initSettingFloat_old("energy.demand.modifier", 1.0f, -1.0f, "modifies the energy required to activate machines, as well as the max amount of energy stored and accepted.");
        this.initSettingInt_old("farms.fertilizer.value", 2000, -1, "modifies the time a piece of fertilizer lasts in a farm.");
        this.initSettingFloat_old("fuel.ethanol.generator", 1.0f, -1.0f, "modifies the energy provided by ethanol in a Bio Generator.");
        this.initSettingFloat_old("fuel.ethanol.combustion", 1.0f, -1.0f, "modifies the energy provided by ethanol in Buildcraft Combustion Engines.");
        this.initSettingFloat_old("fuel.biomass.generator", 1.0f, -1.0f, "modifies the energy provided by Biomass in a Bio Generator.");
        this.initSettingFloat_old("fuel.biomass.biogas", 1.0f, -1.0f, "modifies the energy provided by Biomass in Biogas Engines.");
        this.initSettingStack_old("recipe.output.fertilizer.apatite", this.recipeFertilizerOutputApatite, "amount of fertilizer yielded by the recipe using apatite.");
        this.initSettingStack_old("recipe.output.fertilizer.ash", this.recipeFertilizerOutputAsh, "amount of fertilizer yielded by the recipe using ash.");
        this.initSettingStack_old("recipe.output.compost.wheat", this.recipeCompostOutputWheat, "amount of compost yielded by the recipe using wheat.");
        this.initSettingStack_old("recipe.output.compost.ash", this.recipeCompostOutputAsh, "amount of compost yielded by the recipe using ash.");
        this.initSettingStack_old("recipe.output.humus.fertilizer", this.recipeHumusOutputFertilizer, "amount of humus yielded by the recipe using fertilizer.");
        this.initSettingStack_old("recipe.output.humus.compost", this.recipeHumusOutputCompost, "amount of humus yielded by the recipe using compost.");
        this.initSettingStack_old("recipe.output.bogearth.bucket", this.recipeBogEarthOutputBucket, "amount of bog earth yielded by the recipe using buckets.");
        this.initSettingStack_old("recipe.output.bogearth.can", this.recipeBogEarthOutputCans, "amount of bog earth yielded by the recipes using cans, cells or capsules.");
        this.initSettingStack_old("recipe.output.can", this.recipeCanOutput, "amount yielded by the recipe for tin cans.");
        this.initSettingStack_old("recipe.output.capsule", this.recipeCapsuleOutput, "amount yielded by the recipe for wax capsules.");
        this.initSettingStack_old("recipe.output.refractory", this.recipeRefractoryOutput, "amount yielded by the recipe for refractory capsules.");
        this.initSettingInt_old("fermenter.cycles.fertilizer", 200, -1, "modifies the amount of cycles fertilizer can keep a fermenter going.");
        this.initSettingInt_old("fermenter.cycles.compost", 250, -1, "modifies the amount of cycles compost can keep a fermenter going.");
        this.initSettingInt_old("fermenter.value.fertilizer", 56, -1, "modifies the amount of biomass per cycle a fermenter will produce using fertilizer.");
        this.initSettingInt_old("fermenter.value.compost", 48, -1, "modifies the amount of biomass per cycle a fermenter will produce using compost.");
        this.initSettingInt_old("fermenter.yield.sapling", 250, 2000, "modifies the base amount of biomass a sapling will yield in a fermenter, affected by sappiness trait.");
        this.initSettingInt_old("fermenter.yield.cactus", 50, 400, "modifies the amount of biomass a piece of cactus will yield in a fermenter.");
        this.initSettingInt_old("fermenter.yield.wheat", 50, 400, "modifies the amount of biomass a piece of wheat will yield in a fermenter.");
        this.initSettingInt_old("fermenter.yield.cane", 50, 400, "modifies the amount of biomass a piece of sugar cane will yield in a fermenter.");
        this.initSettingInt_old("fermenter.yield.mushroom", 50, 400, "modifies the amount of biomass a mushroom will yield in a fermenter.");
        this.initSettingInt_old("squeezer.liquid.seed", 10, 80, "modifies the amount of seed oil squeezed from a single seed. other sources are based off this.");
        this.initSettingInt_old("squeezer.liquid.apple", 200, 1600, "modifies the amount of juice squeezed from a single apple. other sources are based off this.");
        this.initSettingInt_old("squeezer.mulch.apple", 20, 160, "modifies the chance of mulch per squeezed apple.");
        this.initSettingBoolean_old("energy.engine.clockwork", true, "set to false to disable the clockwork engine.");
    }

    private void initSettingFloat(LocalizedConfiguration config, String category, String name, float def) {
        String fullName = category + '.' + name;
        Float oldSetting = this.floatSettings.get(fullName);
        if (oldSetting != null) {
            def = oldSetting.floatValue();
        }
        float floatValue = config.getFloatLocalized("gamemode." + category, name, def, 0.0f, 10.0f);
        this.floatSettings.put(fullName, Float.valueOf(floatValue));
    }

    private void initSettingInt(LocalizedConfiguration config, String category, String key, int def) {
        String fullKey = category + '.' + key;
        Integer oldSetting = this.integerSettings.get(fullKey);
        if (oldSetting != null) {
            def = oldSetting;
        }
        int intValue = config.getIntLocalized("gamemode." + category, key, def, 0, 2000);
        this.integerSettings.put(fullKey, intValue);
    }

    private void initSettingStack(LocalizedConfiguration config, String category, String key, ItemStack def) {
        String fullKey = category + '.' + key;
        ItemStack oldSetting = this.stackSettings.get(fullKey);
        if (oldSetting != null) {
            def = oldSetting;
        }
        int stackSize = config.getIntLocalized("gamemode." + category, key, def.stackSize, 0, 64);
        ItemStack changed = def.copy();
        changed.stackSize = stackSize;
        this.stackSettings.put(fullKey, changed);
    }

    private void initSettingBoolean(LocalizedConfiguration config, String category, String key, boolean def) {
        String fullKey = category + '.' + key;
        Boolean oldSetting = this.booleanSettings.get(fullKey);
        if (oldSetting != null) {
            def = oldSetting;
        }
        boolean booleanValue = config.getBooleanLocalized("gamemode." + category, key, def);
        this.booleanSettings.put(fullKey, booleanValue);
    }

    private void initSettingStack_old(String ident, ItemStack def, String comment) {
        Property property = Config.configOld.get(ident, this.category, def.stackSize);
        property.comment = comment;
        ItemStack changed = def.copy();
        changed.stackSize = Integer.parseInt(property.value);
        this.stackSettings.put(ident, changed);
    }

    private void initSettingInt_old(String ident, int def, int max, String comment) {
        Property property = Config.configOld.get(ident, this.category, def);
        if (max < 0) {
            property.comment = comment;
            this.integerSettings.put(ident, Integer.parseInt(property.value));
        } else {
            property.comment = comment + " (max: " + max + ")";
            this.integerSettings.put(ident, Math.min(Integer.parseInt(property.value), max));
        }
        Config.configOld.set(ident, this.category, this.integerSettings.get(ident));
    }

    private void initSettingFloat_old(String ident, float def, float max, String comment) {
        Property property = Config.configOld.get(ident, this.category, def);
        if (max < 0.0f) {
            property.comment = comment;
            this.floatSettings.put(ident, Float.valueOf(Float.parseFloat(property.value)));
        } else {
            property.comment = comment + " (max: " + max + ")";
            this.floatSettings.put(ident, Float.valueOf(Math.min(Float.parseFloat(property.value), max)));
        }
        Config.configOld.set(ident, this.category, this.floatSettings.get(ident).floatValue());
    }

    private void initSettingBoolean_old(String ident, boolean def, String comment) {
        Property property = Config.configOld.get(ident, this.category, def);
        property.comment = comment;
        this.booleanSettings.put(ident, Boolean.parseBoolean(property.value));
        Config.configOld.set(ident, this.category, this.booleanSettings.get(ident));
    }

    @Override
    public int getIntegerSetting(String ident) {
        if (this.integerSettings.containsKey(ident)) {
            return this.integerSettings.get(ident);
        }
        Log.warning("No such setting: " + ident);
        return -1;
    }

    @Override
    public float getFloatSetting(String ident) {
        if (this.floatSettings.containsKey(ident)) {
            return this.floatSettings.get(ident).floatValue();
        }
        Log.warning("No such setting: " + ident);
        return 1.0f;
    }

    @Override
    public boolean getBooleanSetting(String ident) {
        if (this.booleanSettings.containsKey(ident)) {
            return this.booleanSettings.get(ident);
        }
        Log.warning("No such setting: " + ident);
        return false;
    }

    @Override
    public ItemStack getStackSetting(String ident) {
        if (this.stackSettings.containsKey(ident)) {
            return this.stackSettings.get(ident);
        }
        Log.warning("No such setting: " + ident);
        return new ItemStack(Items.apple, 1);
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }
}

