/*
 * Decompiled with CFR 0.152.
 */
package forestry.plugins;

import com.google.common.collect.ImmutableList;
import cpw.mods.fml.common.registry.GameRegistry;
import forestry.api.farming.Farmables;
import forestry.api.recipes.RecipeManagers;
import forestry.core.config.Config;
import forestry.core.config.GameMode;
import forestry.core.fluids.Fluids;
import forestry.core.proxy.Proxies;
import forestry.core.recipes.RecipeUtil;
import forestry.farming.logic.FarmableGenericCrop;
import forestry.plugins.ForestryPlugin;
import forestry.plugins.Plugin;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

@Plugin(pluginID="MagicalCrops", name="MagicalCrops", author="Nirek", url="http://forestry.sengir.net/", unlocalizedDescription="for.plugin.magicalcrops.description")
public class PluginMagicalCrops
extends ForestryPlugin {
    private static final String MagCrop = "magicalcrops";

    @Override
    public boolean isAvailable() {
        return Proxies.common.isModLoaded(MagCrop);
    }

    @Override
    public String getFailMessage() {
        return "Magical Crops not found";
    }

    @Override
    protected void postInit() {
        ImmutableList magicSeeds = ImmutableList.of((Object)"Essence", (Object)"Coal", (Object)"Dye", (Object)"Redstone", (Object)"Glowstone", (Object)"Obsidian", (Object)"Iron", (Object)"Gold", (Object)"Lapis", (Object)"Ender", (Object)"Nether", (Object)"Experience", (Object[])new String[]{"Blaze", "Diamond", "Emerald"});
        ImmutableList elementSeeds = ImmutableList.of((Object)"Air", (Object)"Water", (Object)"Earth", (Object)"Fire");
        ImmutableList modMagicSeeds = ImmutableList.of((Object)"Copper", (Object)"Tin", (Object)"Silver", (Object)"Lead", (Object)"Quartz", (Object)"Sapphire", (Object)"Ruby", (Object)"Peridot", (Object)"Aluminium", (Object)"Force", (Object)"Cobalt", (Object)"Ardite", (Object[])new String[]{"Nickel", "Platinum", "ThaumcraftShard", "Uranium", "Oil", "Rubber", "Vinteum", "BlueTopaz", "Chimerite", "Moonstone", "Sunstone", "Iridium", "Yellorite", "Osmium", "Manganese", "Sulfur", "Darkiron"});
        ImmutableList soulSeeds = ImmutableList.of((Object)"Cow", (Object)"Creeper", (Object)"Magma", (Object)"Skeleton", (Object)"Slime", (Object)"Spider", (Object)"Ghast", (Object)"Wither");
        ImmutableList potionSeeds = ImmutableList.of((Object)"Fire", (Object)"Water", (Object)"Strength", (Object)"Regen", (Object)"Night", (Object)"Speed");
        ImmutableList seeds = ImmutableList.of((Object)"Blackberry", (Object)"Blueberry", (Object)"Chili", (Object)"Cucumber", (Object)"Grape", (Object)"Raspberry", (Object)"Strawberry", (Object)"Sweetcorn", (Object)"Tomato", (Object)"SugarCane");
        ImmutableList betaSeeds = ImmutableList.of((Object)"Air", (Object)"Airshard", (Object)"Aluminium", (Object)"Alumite", (Object)"Amber", (Object)"Ardite", (Object)"Blaze", (Object)"Blizz", (Object)"Bronze", (Object)"CertusQuartz", (Object)"Chicken", (Object)"Coal", (Object[])new String[]{"Cobalt", "ConductiveIron", "Copper", "Cow", "Creeper", "DarkSteel", "Diamond", "Draconium", "Dye", "Earth", "Earthshard", "ElectricalSteel", "Electrum", "Emerald", "Enderium", "Enderman", "EnergeticAlloy", "Experience", "Fire", "Fireshard", "Fluix", "Ghast", "Glowstone", "Gold", "Invar", "Iron", "Lapis", "Lead", "Lumium", "Manasteel", "Manyullyn", "Minicio", "Nature", "Nether", "Nickel", "Obsidian", "Ordershard", "Osmium", "Peridot", "Pig", "Platinum", "PulsatingIron", "Quartz", "Quicksilver", "RedstoneAlloy", "Redstone", "Rubber", "Ruby", "Saltpeter", "Sapphire", "Sheep", "Signalum", "Silver", "Skeleton", "Slime", "Soularium", "Spider", "Steel", "Sulfur", "Terrasteel", "Thaumium", "Tin", "VibrantAlloy", "Water", "Watershard", "Wither", "Yellorite"});
        int seedAmount = GameMode.getGameMode().getIntegerSetting("squeezer.liquid.seed");
        for (String magicSeedName : magicSeeds) {
            PluginMagicalCrops.addRecipes("_MagicSeeds", "_MagicCrop", magicSeedName, seedAmount);
        }
        for (String elementSeedName : elementSeeds) {
            PluginMagicalCrops.addRecipes("_ElementSeeds", "_ElementCrop", elementSeedName, seedAmount);
        }
        for (String modMagicSeedName : modMagicSeeds) {
            PluginMagicalCrops.addRecipes("_ModMagicSeeds", "_ModMagicCrop", modMagicSeedName, seedAmount);
        }
        for (String soulSeedName : soulSeeds) {
            PluginMagicalCrops.addRecipes("_SoulSeeds", "_SoulCrop", soulSeedName, seedAmount);
        }
        for (String potionSeedName : potionSeeds) {
            PluginMagicalCrops.addRecipes("_PotionSeeds", "_PotionCrop", potionSeedName, seedAmount);
        }
        for (String seedName : seeds) {
            PluginMagicalCrops.addRecipes("_Seeds", "_Crop", seedName, seedAmount);
        }
        for (String seedName : betaSeeds) {
            PluginMagicalCrops.addBetaRecipes("Seeds", "Crop", seedName, "");
            PluginMagicalCrops.addBetaRecipes("Seeds", "Crop", seedName, "magicalcrops_");
        }
        Item cropProduce = GameRegistry.findItem((String)MagCrop, (String)"magicalcrops_CropProduce");
        if (cropProduce != null) {
            int juiceAmount = GameMode.getGameMode().getIntegerSetting("squeezer.liquid.apple");
            ItemStack produce = new ItemStack(GameRegistry.findItem((String)MagCrop, (String)"magicalcrops_CropProduce"), 1, Short.MAX_VALUE);
            RecipeUtil.addFermenterRecipes(produce, GameMode.getGameMode().getIntegerSetting("fermenter.yield.wheat"), Fluids.BIOMASS);
            RecipeManagers.squeezerManager.addRecipe(10, new ItemStack[]{produce}, Fluids.JUICE.getFluid(juiceAmount));
        }
    }

    private static void addRecipes(String seedPrefix, String cropPrefix, String name, int fluidAmount) {
        ItemStack seed = GameRegistry.findItemStack((String)MagCrop, (String)(MagCrop + seedPrefix + name), (int)1);
        Block crop = GameRegistry.findBlock((String)MagCrop, (String)(MagCrop + cropPrefix + name));
        if (seed != null) {
            RecipeManagers.squeezerManager.addRecipe(10, new ItemStack[]{seed}, Fluids.SEEDOIL.getFluid(fluidAmount));
        }
        if (seed != null && crop != null && Config.isMagicalCropsSupportEnabled()) {
            Farmables.farmables.get("farmWheat").add(new FarmableGenericCrop(seed, crop, 7, new ItemStack[0]));
        }
    }

    private static void addBetaRecipes(String seedSuffix, String cropSuffix, String name, String middlefix) {
        ItemStack seed = GameRegistry.findItemStack((String)MagCrop, (String)(middlefix + name + seedSuffix), (int)1);
        Block crop = GameRegistry.findBlock((String)MagCrop, (String)(middlefix + name + cropSuffix));
        if (seed != null && crop != null && Config.isMagicalCropsSupportEnabled()) {
            Farmables.farmables.get("farmWheat").add(new FarmableGenericCrop(seed, crop, 7, new ItemStack[0]));
        }
    }
}

