/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.worldgen;

import forestry.api.world.ITreeGenData;
import forestry.arboriculture.worldgen.WorldGenTree;
import forestry.core.worldgen.WorldGenBase;
import net.minecraft.world.World;

public class WorldGenKapok
extends WorldGenTree {
    public WorldGenKapok(ITreeGenData tree) {
        super(tree, 10, 8);
    }

    @Override
    public void generate(World world) {
        this.generateTreeTrunk(world, this.height, this.girth, 0.6f);
        this.generateSupportStems(world, this.height, this.girth, 0.2f, 0.2f);
        int leafSpawn = this.height + 1;
        this.generateAdjustedCylinder(world, leafSpawn--, 0.0f, 1, this.leaf);
        this.generateAdjustedCylinder(world, leafSpawn--, 0.5f, 1, this.leaf);
        this.generateAdjustedCylinder(world, leafSpawn--, 1.9f, 1, this.leaf);
        while (leafSpawn > this.height - 4) {
            this.generateAdjustedCylinder(world, leafSpawn--, 2.5f, 1, this.leaf);
        }
        this.generateAdjustedCylinder(world, leafSpawn--, 1.9f, 1, this.leaf);
        for (int times = 0; times < this.height / 4; ++times) {
            int h = 10 + world.rand.nextInt(Math.max(1, this.height - 10));
            if (world.rand.nextBoolean() && h < this.height / 2) {
                h = this.height / 2 + world.rand.nextInt(this.height / 2);
            }
            int x_off = -1 + world.rand.nextInt(3);
            int y_off = -1 + world.rand.nextInt(3);
            this.generateSphere(world, new WorldGenBase.Vector(x_off, h, y_off), 1 + world.rand.nextInt(1), this.leaf, WorldGenBase.EnumReplaceMode.NONE);
        }
    }
}

