/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.items;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.EnumBeeChromosome;
import forestry.api.apiculture.EnumBeeType;
import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.api.apiculture.IBee;
import forestry.api.core.Tabs;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IAlleleSpecies;
import forestry.api.genetics.IIndividual;
import forestry.apiculture.genetics.BeeGenome;
import forestry.core.config.Config;
import forestry.core.genetics.ItemGE;
import forestry.core.utils.StringUtil;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;

public class ItemBeeGE
extends ItemGE {
    private final EnumBeeType type;

    public ItemBeeGE(EnumBeeType type) {
        this.type = type;
        this.setCreativeTab(Tabs.tabApiculture);
        if (type != EnumBeeType.DRONE) {
            this.setMaxStackSize(1);
        }
    }

    @Override
    public IBee getIndividual(ItemStack itemstack) {
        return BeeManager.beeRoot.getMember(itemstack);
    }

    @Override
    protected IAlleleSpecies getSpecies(ItemStack itemStack) {
        return BeeGenome.getSpecies(itemStack);
    }

    @Override
    protected int getDefaultPrimaryColour() {
        return 0xFFFFFF;
    }

    @Override
    protected int getDefaultSecondaryColour() {
        return 16768022;
    }

    public String getItemStackDisplayName(ItemStack itemstack) {
        if (itemstack.getTagCompound() == null) {
            return super.getItemStackDisplayName(itemstack);
        }
        IBee individual = BeeManager.beeRoot.getMember(itemstack);
        String customBeeKey = "bees.custom." + this.type.getName() + "." + individual.getGenome().getPrimary().getUnlocalizedName().replace("bees.species.", "");
        if (StringUtil.canTranslate(customBeeKey)) {
            return StringUtil.localize(customBeeKey);
        }
        String beeGrammar = StringUtil.localize("bees.grammar." + this.type.getName());
        String beeSpecies = individual.getDisplayName();
        String beeType = StringUtil.localize("bees.grammar." + this.type.getName() + ".type");
        return beeGrammar.replaceAll("%SPECIES", beeSpecies).replaceAll("%TYPE", beeType);
    }

    @Override
    public void addInformation(ItemStack itemstack, EntityPlayer player, List list, boolean flag) {
        if (!itemstack.hasTagCompound()) {
            return;
        }
        if (this.type != EnumBeeType.DRONE) {
            IBee individual = BeeManager.beeRoot.getMember(itemstack);
            if (individual.isNatural()) {
                list.add(EnumChatFormatting.YELLOW + EnumChatFormatting.ITALIC.toString() + StringUtil.localize("bees.stock.pristine"));
            } else {
                list.add(EnumChatFormatting.YELLOW + StringUtil.localize("bees.stock.ignoble"));
            }
        }
        super.addInformation(itemstack, player, list, flag);
    }

    public void getSubItems(Item item, CreativeTabs par2CreativeTabs, List itemList) {
        if (this.type == EnumBeeType.QUEEN) {
            return;
        }
        this.addCreativeItems(itemList, true);
    }

    public void addCreativeItems(List itemList, boolean hideSecrets) {
        for (IIndividual iIndividual : BeeManager.beeRoot.getIndividualTemplates()) {
            if (hideSecrets && iIndividual.isSecret() && !Config.isDebug) continue;
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            ItemStack someStack = new ItemStack((Item)this);
            iIndividual.writeToNBT(nbttagcompound);
            someStack.setTagCompound(nbttagcompound);
            itemList.add(someStack);
        }
    }

    @Override
    public int getColorFromItemStack(ItemStack itemstack, int renderPass) {
        if (!itemstack.hasTagCompound()) {
            return super.getColorFromItemStack(itemstack, renderPass);
        }
        return this.getColourFromSpecies(BeeGenome.getSpecies(itemstack), renderPass);
    }

    @Override
    public int getColourFromSpecies(IAlleleSpecies species, int renderPass) {
        if (species instanceof IAlleleBeeSpecies) {
            return species.getIconColour(renderPass);
        }
        return 0xFFFFFF;
    }

    public boolean requiresMultipleRenderPasses() {
        return true;
    }

    public int getRenderPasses(int metadata) {
        return 3;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister register) {
        for (IAllele allele : AlleleManager.alleleRegistry.getRegisteredAlleles().values()) {
            if (!(allele instanceof IAlleleBeeSpecies)) continue;
            ((IAlleleBeeSpecies)allele).getIconProvider().registerIcons(register);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(ItemStack itemstack, int renderPass) {
        return this.getIconFromSpecies(BeeGenome.getSpecies(itemstack), renderPass);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIconFromSpecies(IAlleleBeeSpecies species, int renderPass) {
        if (species == null) {
            species = (IAlleleBeeSpecies)BeeManager.beeRoot.getDefaultTemplate()[EnumBeeChromosome.SPECIES.ordinal()];
        }
        return species.getIcon(this.type, renderPass);
    }
}

