/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.tiles;

import cpw.mods.fml.common.eventhandler.Event;
import forestry.api.core.ForestryAPI;
import forestry.core.inventory.TileInventoryAdapter;
import forestry.core.inventory.wrappers.InventoryMapper;
import forestry.core.network.DataInputStreamForestry;
import forestry.core.network.DataOutputStreamForestry;
import forestry.core.network.GuiId;
import forestry.core.recipes.RecipeUtil;
import forestry.core.tiles.TileBase;
import forestry.core.utils.InventoryUtil;
import forestry.core.utils.SlotUtil;
import forestry.factory.recipes.RecipeMemory;
import forestry.factory.tiles.ICrafterWorktable;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerDestroyItemEvent;

public class TileWorktable
extends TileBase
implements ICrafterWorktable {
    public static final int SLOT_CRAFTING_1 = 0;
    public static final int SLOT_CRAFTING_COUNT = 9;
    public static final int SLOT_CRAFTING_RESULT = 9;
    public static final short SLOT_INVENTORY_1 = 0;
    public static final short SLOT_INVENTORY_COUNT = 18;
    private RecipeMemory.Recipe currentRecipe;
    private InventoryCrafting currentCrafting;
    private final RecipeMemory memorized;
    private final TileInventoryAdapter craftingInventory = new TileInventoryAdapter<TileWorktable>(this, 10, "CraftItems");

    public TileWorktable() {
        this.setInternalInventory(new WorktableInventoryAdapter(this));
        this.memorized = new RecipeMemory();
    }

    @Override
    public void openGui(EntityPlayer player) {
        player.openGui(ForestryAPI.instance, GuiId.WorktableGUI.ordinal(), player.worldObj, this.xCoord, this.yCoord, this.zCoord);
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        this.craftingInventory.writeToNBT(nbttagcompound);
        this.memorized.writeToNBT(nbttagcompound);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.craftingInventory.readFromNBT(nbttagcompound);
        this.memorized.readFromNBT(nbttagcompound);
    }

    @Override
    public void writeData(DataOutputStreamForestry data) throws IOException {
        super.writeData(data);
        this.craftingInventory.writeData(data);
        this.memorized.writeData(data);
    }

    @Override
    public void readData(DataInputStreamForestry data) throws IOException {
        super.readData(data);
        this.craftingInventory.readData(data);
        this.memorized.readData(data);
    }

    @Override
    public void validate() {
        super.validate();
        this.memorized.validate(this.worldObj);
    }

    public RecipeMemory getMemory() {
        return this.memorized;
    }

    public void chooseRecipe(int recipeIndex) {
        if (recipeIndex >= 9) {
            for (int slot = 0; slot < this.craftingInventory.getSizeInventory(); ++slot) {
                this.craftingInventory.setInventorySlotContents(slot, null);
            }
            return;
        }
        IInventory matrix = this.memorized.getRecipeMatrix(recipeIndex);
        if (matrix == null) {
            return;
        }
        for (int slot = 0; slot < matrix.getSizeInventory(); ++slot) {
            this.craftingInventory.setInventorySlotContents(slot, matrix.getStackInSlot(slot));
        }
    }

    public void setRecipe(InventoryCrafting crafting) {
        ItemStack recipeOutput = CraftingManager.getInstance().findMatchingRecipe(crafting, this.worldObj);
        if (recipeOutput == null) {
            this.currentRecipe = null;
            this.currentCrafting = null;
        } else {
            this.currentRecipe = new RecipeMemory.Recipe(crafting);
            this.currentCrafting = crafting;
        }
        this.updateCraftResult();
    }

    private void updateCraftResult() {
        ItemStack result;
        if (this.currentRecipe != null && (result = this.currentRecipe.getRecipeOutput(this.worldObj)) != null) {
            this.craftingInventory.setInventorySlotContents(9, result.copy());
            return;
        }
        this.craftingInventory.setInventorySlotContents(9, null);
    }

    private boolean canCraftCurrentRecipe() {
        if (this.currentRecipe == null) {
            return false;
        }
        ItemStack[] recipeItems = InventoryUtil.getStacks((IInventory)this.craftingInventory, 0, 9);
        ItemStack[] inventory = InventoryUtil.getStacks((IInventory)this.getInternalInventory(), 0, 18);
        ItemStack recipeOutput = this.currentRecipe.getRecipeOutput(this.worldObj);
        return RecipeUtil.canCraftRecipe(this.worldObj, recipeItems, recipeOutput, inventory);
    }

    @Override
    public boolean canTakeStack(int slotIndex) {
        if (slotIndex == 9) {
            return this.canCraftCurrentRecipe();
        }
        return true;
    }

    @Override
    public boolean onCraftingStart(EntityPlayer player) {
        ItemStack[] set = InventoryUtil.getStacks((IInventory)this.currentRecipe.getMatrix(), 0, 9);
        ItemStack[] removed = InventoryUtil.removeSets((IInventory)this, 1, set, 0, 18, player, false, true, true);
        for (int i = 0; i < removed.length; ++i) {
            this.craftingInventory.setInventorySlotContents(i, removed[i]);
        }
        return removed != null;
    }

    @Override
    public void onCraftingComplete(EntityPlayer player) {
        IInventory craftingInventory = this.getCraftingInventory();
        for (int i = 0; i < craftingInventory.getSizeInventory(); ++i) {
            ItemStack itemStack = craftingInventory.getStackInSlot(i);
            if (itemStack == null || !itemStack.getItem().hasContainerItem(itemStack)) continue;
            ItemStack container = itemStack.getItem().getContainerItem(itemStack);
            if (container != null && container.isItemStackDamageable() && container.getItemDamage() > container.getMaxDamage()) {
                MinecraftForge.EVENT_BUS.post((Event)new PlayerDestroyItemEvent(player, container));
                continue;
            }
            if (InventoryUtil.tryAddStack((IInventory)this, container, true)) continue;
            player.dropPlayerItemWithRandomChoice(container, false);
        }
        if (!this.worldObj.isRemote) {
            this.memorized.memorizeRecipe(this.worldObj, this.currentRecipe, this.currentCrafting);
        }
        this.updateCraftResult();
    }

    @Override
    public ItemStack getResult() {
        if (this.currentRecipe == null) {
            return null;
        }
        if (this.currentRecipe.getRecipeOutput(this.worldObj) != null) {
            return this.currentRecipe.getRecipeOutput(this.worldObj).copy();
        }
        return null;
    }

    public IInventory getCraftingInventory() {
        return new InventoryMapper((IInventory)this.craftingInventory, 0, 9);
    }

    private static class WorktableInventoryAdapter
    extends TileInventoryAdapter<TileWorktable> {
        public WorktableInventoryAdapter(TileWorktable worktable) {
            super(worktable, 18, "Items");
        }

        @Override
        public boolean canSlotAccept(int slotIndex, ItemStack itemStack) {
            return SlotUtil.isSlotInRange(slotIndex, 0, 18);
        }
    }
}

