/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.items;

import forestry.api.arboriculture.ITree;
import forestry.api.arboriculture.TreeManager;
import forestry.api.core.ForestryAPI;
import forestry.api.core.Tabs;
import forestry.core.config.Config;
import forestry.core.gui.IHintSource;
import forestry.core.items.ItemAlyzer;
import forestry.core.network.GuiId;
import forestry.core.utils.GeneticsUtil;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class ItemTreealyzer
extends ItemAlyzer {
    public ItemTreealyzer() {
        this.setMaxStackSize(1);
        this.setCreativeTab(Tabs.tabArboriculture);
    }

    public ItemStack onItemRightClick(ItemStack itemstack, World world, EntityPlayer entityplayer) {
        if (!world.isRemote) {
            entityplayer.openGui(ForestryAPI.instance, GuiId.TreealyzerGUI.ordinal(), world, (int)entityplayer.posX, (int)entityplayer.posY, (int)entityplayer.posZ);
        }
        return itemstack;
    }

    public static class TreealyzerInventory
    extends ItemAlyzer.AlyzerInventory
    implements IHintSource {
        public TreealyzerInventory(EntityPlayer player, ItemStack itemStack) {
            super(player, 7, itemStack);
        }

        @Override
        protected boolean isSpecimen(ItemStack itemStack) {
            return GeneticsUtil.getGeneticEquivalent(itemStack) instanceof ITree;
        }

        @Override
        public void onSlotClick(EntityPlayer player) {
            ITree tree;
            ItemStack ersatz;
            if (this.getStackInSlot(0) == null) {
                return;
            }
            if (!TreeManager.treeRoot.isMember(this.getStackInSlot(0)) && (ersatz = GeneticsUtil.convertSaplingToGeneticEquivalent(this.getStackInSlot(0))) != null) {
                this.setInventorySlotContents(0, ersatz);
            }
            if ((tree = TreeManager.treeRoot.getMember(this.getStackInSlot(0))) == null) {
                return;
            }
            if (!tree.isAnalyzed()) {
                if (!TreealyzerInventory.isEnergy(this.getStackInSlot(5))) {
                    return;
                }
                tree.analyze();
                if (player != null) {
                    TreeManager.treeRoot.getBreedingTracker(player.worldObj, player.getGameProfile()).registerSpecies(tree.getGenome().getPrimary());
                    TreeManager.treeRoot.getBreedingTracker(player.worldObj, player.getGameProfile()).registerSpecies(tree.getGenome().getSecondary());
                }
                NBTTagCompound nbttagcompound = new NBTTagCompound();
                tree.writeToNBT(nbttagcompound);
                this.getStackInSlot(0).setTagCompound(nbttagcompound);
                this.decrStackSize(5, 1);
            }
            this.setInventorySlotContents(1, this.getStackInSlot(0));
            this.setInventorySlotContents(0, null);
        }

        @Override
        public boolean hasHints() {
            return Config.hints.get("treealyzer") != null && Config.hints.get("treealyzer").length > 0;
        }

        @Override
        public String[] getHints() {
            return Config.hints.get("treealyzer");
        }
    }
}

