/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.items;

import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.IBee;
import forestry.api.core.ForestryAPI;
import forestry.api.core.Tabs;
import forestry.core.config.Config;
import forestry.core.gui.IHintSource;
import forestry.core.items.ItemAlyzer;
import forestry.core.network.GuiId;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class ItemBeealyzer
extends ItemAlyzer {
    public ItemBeealyzer() {
        this.setMaxStackSize(1);
        this.setCreativeTab(Tabs.tabApiculture);
    }

    public ItemStack onItemRightClick(ItemStack itemstack, World world, EntityPlayer entityplayer) {
        if (!world.isRemote) {
            entityplayer.openGui(ForestryAPI.instance, GuiId.BeealyzerGUI.ordinal(), world, (int)entityplayer.posX, (int)entityplayer.posY, (int)entityplayer.posZ);
        }
        return itemstack;
    }

    public static class BeealyzerInventory
    extends ItemAlyzer.AlyzerInventory
    implements IHintSource {
        public BeealyzerInventory(EntityPlayer player, ItemStack itemStack) {
            super(player, 7, itemStack);
        }

        @Override
        protected boolean isSpecimen(ItemStack itemStack) {
            return BeeManager.beeRoot.isMember(itemStack);
        }

        @Override
        public void onSlotClick(EntityPlayer player) {
            if (this.getStackInSlot(0) == null) {
                return;
            }
            IBee bee = BeeManager.beeRoot.getMember(this.getStackInSlot(0));
            if (bee == null) {
                return;
            }
            if (!bee.isAnalyzed()) {
                if (!BeealyzerInventory.isEnergy(this.getStackInSlot(5))) {
                    return;
                }
                bee.analyze();
                if (player != null) {
                    BeeManager.beeRoot.getBreedingTracker(player.worldObj, player.getGameProfile()).registerSpecies(bee.getGenome().getPrimary());
                    BeeManager.beeRoot.getBreedingTracker(player.worldObj, player.getGameProfile()).registerSpecies(bee.getGenome().getSecondary());
                }
                NBTTagCompound nbttagcompound = new NBTTagCompound();
                bee.writeToNBT(nbttagcompound);
                this.getStackInSlot(0).setTagCompound(nbttagcompound);
                this.decrStackSize(5, 1);
            }
            this.setInventorySlotContents(1, this.getStackInSlot(0));
            this.setInventorySlotContents(0, null);
        }

        @Override
        public boolean hasHints() {
            return Config.hints.get("beealyzer") != null && Config.hints.get("beealyzer").length > 0;
        }

        @Override
        public String[] getHints() {
            return Config.hints.get("beealyzer");
        }
    }
}

