/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.multiblock;

import buildcraft.api.statements.IStatementContainer;
import buildcraft.api.statements.ITriggerExternal;
import buildcraft.api.statements.ITriggerInternal;
import buildcraft.api.statements.ITriggerProvider;
import cpw.mods.fml.common.Optional;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.IBeeHousingInventory;
import forestry.api.apiculture.IBeeListener;
import forestry.api.apiculture.IBeeModifier;
import forestry.api.apiculture.IBeekeepingLogic;
import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.api.core.ForestryAPI;
import forestry.api.core.IErrorLogic;
import forestry.apiculture.multiblock.TileAlveary;
import forestry.apiculture.trigger.ApicultureTriggers;
import forestry.core.config.Config;
import forestry.core.gui.IHintSource;
import forestry.core.inventory.IInventoryAdapter;
import forestry.core.multiblock.MultiblockControllerBase;
import forestry.core.multiblock.rectangular.PartPosition;
import forestry.core.network.DataInputStreamForestry;
import forestry.core.network.DataOutputStreamForestry;
import forestry.core.network.GuiId;
import forestry.core.network.IStreamableGui;
import forestry.core.tiles.IClimatised;
import forestry.core.tiles.ITitled;
import forestry.core.utils.BlockUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.util.ForgeDirection;

@Optional.Interface(iface="buildcraft.api.statements.ITriggerProvider", modid="BuildCraftAPI|statements")
public class TileAlvearyPlain
extends TileAlveary
implements IBeeHousing,
IClimatised,
IHintSource,
IStreamableGui,
ITitled,
ITriggerProvider {
    @Override
    public void onMachineAssembled(MultiblockControllerBase controller) {
        super.onMachineAssembled(controller);
        if (!this.worldObj.isRemote && this.getPartPosition() == PartPosition.Frame && BlockUtil.isWoodSlabBlock(this.worldObj.getBlock(this.xCoord, this.yCoord + 1, this.zCoord))) {
            this.worldObj.setBlockMetadataWithNotify(this.xCoord, this.yCoord, this.zCoord, 1, 2);
        }
    }

    @Override
    public void onMachineBroken() {
        super.onMachineBroken();
        if (!this.worldObj.isRemote) {
            this.worldObj.setBlockMetadataWithNotify(this.xCoord, this.yCoord, this.zCoord, 0, 2);
        }
    }

    @Override
    public IInventoryAdapter getInternalInventory() {
        return this.getAlvearyController().getInternalInventory();
    }

    @Override
    public boolean allowsAutomation() {
        return true;
    }

    @Override
    public void openGui(EntityPlayer player) {
        if (this.isConnected()) {
            player.openGui(ForestryAPI.instance, GuiId.AlvearyGUI.ordinal(), this.worldObj, this.xCoord, this.yCoord, this.zCoord);
        }
    }

    @Override
    public void writeGuiData(DataOutputStreamForestry data) throws IOException {
        this.getAlvearyController().writeGuiData(data);
    }

    @Override
    public void readGuiData(DataInputStreamForestry data) throws IOException {
        this.getAlvearyController().readGuiData(data);
    }

    @Override
    public String getUnlocalizedTitle() {
        return "alveary.0.name";
    }

    @Override
    public boolean hasHints() {
        return Config.hints.get("apiary").length > 0;
    }

    @Override
    public String[] getHints() {
        return Config.hints.get("apiary");
    }

    @Optional.Method(modid="BuildCraftAPI|statements")
    public Collection<ITriggerInternal> getInternalTriggers(IStatementContainer container) {
        return null;
    }

    @Optional.Method(modid="BuildCraftAPI|statements")
    public Collection<ITriggerExternal> getExternalTriggers(ForgeDirection side, TileEntity tile) {
        ArrayList<ITriggerExternal> res = new ArrayList<ITriggerExternal>();
        res.add(ApicultureTriggers.missingQueen);
        res.add(ApicultureTriggers.missingDrone);
        return res;
    }

    @Override
    public World getWorld() {
        return this.getAlvearyController().getWorld();
    }

    @Override
    public ChunkCoordinates getCoordinates() {
        return this.getAlvearyController().getCoordinates();
    }

    @Override
    public BiomeGenBase getBiome() {
        return this.getAlvearyController().getBiome();
    }

    @Override
    public Iterable<IBeeModifier> getBeeModifiers() {
        return this.getAlvearyController().getBeeModifiers();
    }

    @Override
    public Iterable<IBeeListener> getBeeListeners() {
        return this.getAlvearyController().getBeeListeners();
    }

    @Override
    public IBeeHousingInventory getBeeInventory() {
        return this.getAlvearyController().getBeeInventory();
    }

    @Override
    public IBeekeepingLogic getBeekeepingLogic() {
        return this.getAlvearyController().getBeekeepingLogic();
    }

    @Override
    public EnumTemperature getTemperature() {
        return this.getAlvearyController().getTemperature();
    }

    @Override
    public EnumHumidity getHumidity() {
        return this.getAlvearyController().getHumidity();
    }

    @Override
    public int getBlockLightValue() {
        return this.getAlvearyController().getBlockLightValue();
    }

    @Override
    public boolean canBlockSeeTheSky() {
        return this.getAlvearyController().canBlockSeeTheSky();
    }

    @Override
    public float getExactTemperature() {
        return this.getAlvearyController().getExactTemperature();
    }

    @Override
    public float getExactHumidity() {
        return this.getAlvearyController().getExactHumidity();
    }

    @Override
    public IErrorLogic getErrorLogic() {
        return this.getAlvearyController().getErrorLogic();
    }
}

