/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.render;

import forestry.core.proxy.Proxies;
import forestry.core.render.ForestryResource;
import forestry.core.render.IBlockRenderer;
import forestry.core.render.ModelEscritoire;
import forestry.core.tiles.TileEscritoire;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class RenderEscritoire
extends TileEntitySpecialRenderer
implements IBlockRenderer {
    private static final ResourceLocation texture = new ForestryResource("textures/blocks/escritoire.png");
    private final ModelEscritoire modelEscritoire = new ModelEscritoire();

    public RenderEscritoire() {
        RenderItem customRenderItem = new RenderItem(){

            public boolean shouldBob() {
                return false;
            }

            public boolean shouldSpreadItems() {
                return false;
            }
        };
        customRenderItem.setRenderManager(RenderManager.instance);
    }

    @Override
    public void inventoryRender(double x, double y, double z) {
        this.render(null, ForgeDirection.EAST, x, y, z);
    }

    public void renderTileEntityAt(TileEntity tileentity, double x, double y, double z, float f) {
        TileEscritoire tile = (TileEscritoire)tileentity;
        this.render(tile.getStackInSlot(0), tile.getOrientation(), x, y, z);
    }

    private void render(ItemStack itemstack, ForgeDirection orientation, double x, double y, double z) {
        float factor = 0.0625f;
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y + 0.875f), (float)((float)z + 0.5f));
        float[] angle = new float[]{(float)Math.PI, 0.0f, 0.0f};
        if (orientation == null) {
            orientation = ForgeDirection.WEST;
        }
        switch (orientation) {
            case EAST: {
                angle[1] = 1.5707964f;
                break;
            }
            case SOUTH: {
                break;
            }
            case NORTH: {
                angle[1] = (float)Math.PI;
                break;
            }
            default: {
                angle[1] = -1.5707964f;
            }
        }
        Proxies.common.bindTexture(texture);
        this.modelEscritoire.render(null, angle[0], angle[1], angle[2], 0.0f, 0.0f, factor);
        GL11.glPopMatrix();
    }
}

