/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.access;

import com.mojang.authlib.GameProfile;
import forestry.api.core.INBTTagable;
import forestry.core.access.EnumAccess;
import forestry.core.access.IAccessHandler;
import forestry.core.config.Config;
import forestry.core.network.DataInputStreamForestry;
import forestry.core.network.DataOutputStreamForestry;
import forestry.core.network.IStreamable;
import forestry.core.network.PacketCoordinates;
import forestry.core.network.PacketId;
import forestry.core.proxy.Proxies;
import forestry.core.tiles.IRestrictedAccessTile;
import forestry.core.utils.PlayerUtil;
import java.io.IOException;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;

public final class AccessHandler
implements IAccessHandler,
IStreamable,
INBTTagable {
    private final IRestrictedAccessTile tile;
    private GameProfile owner = null;
    private EnumAccess access = EnumAccess.SHARED;

    public AccessHandler(IRestrictedAccessTile tile) {
        this.tile = tile;
    }

    @Override
    public final boolean allowsRemoval(EntityPlayer player) {
        return !Config.enablePermissions || this.getAccessType() == EnumAccess.SHARED || !this.isOwned() || this.isOwner(player) || Proxies.common.isOp(player);
    }

    @Override
    public final boolean allowsAlteration(EntityPlayer player) {
        return this.allowsRemoval(player);
    }

    @Override
    public final boolean allowsViewing(EntityPlayer player) {
        return this.allowsAlteration(player) || this.getAccessType() == EnumAccess.VIEWABLE;
    }

    @Override
    public final boolean allowsPipeConnections() {
        return this.access == EnumAccess.SHARED;
    }

    @Override
    public EnumAccess getAccessType() {
        return this.access;
    }

    @Override
    public boolean isOwned() {
        return this.owner != null;
    }

    @Override
    public GameProfile getOwner() {
        return this.owner;
    }

    @Override
    public void setOwner(GameProfile owner) {
        this.owner = owner;
    }

    @Override
    public boolean isOwner(EntityPlayer player) {
        return PlayerUtil.isSameGameProfile(this.owner, player.getGameProfile());
    }

    @Override
    public boolean switchAccessRule(EntityPlayer player) {
        if (!this.isOwner(player)) {
            return false;
        }
        EnumAccess oldAccess = this.access;
        int ordinal = (this.access.ordinal() + 1) % EnumAccess.values().length;
        this.access = EnumAccess.values()[ordinal];
        if (player.worldObj.isRemote) {
            Proxies.net.sendToServer(new PacketCoordinates(PacketId.ACCESS_SWITCH, this.tile.getCoordinates()));
        } else {
            this.tile.onSwitchAccess(oldAccess, this.access);
        }
        return true;
    }

    @Override
    public void writeData(DataOutputStreamForestry data) throws IOException {
        if (this.owner == null) {
            data.writeByte(-1);
        } else {
            data.writeByte(this.access.ordinal());
            data.writeLong(this.owner.getId().getMostSignificantBits());
            data.writeLong(this.owner.getId().getLeastSignificantBits());
            data.writeUTF(this.owner.getName());
        }
    }

    @Override
    public void readData(DataInputStreamForestry data) throws IOException {
        byte accessOrdinal = data.readByte();
        if (accessOrdinal >= 0) {
            this.access = EnumAccess.values()[accessOrdinal];
            this.owner = new GameProfile(new UUID(data.readLong(), data.readLong()), data.readUTF());
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        this.access = EnumAccess.values()[data.getInteger("Access")];
        if (data.hasKey("owner")) {
            this.owner = NBTUtil.func_152459_a((NBTTagCompound)data.getCompoundTag("owner"));
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        data.setInteger("Access", this.access.ordinal());
        if (this.owner != null) {
            NBTTagCompound nbt = new NBTTagCompound();
            NBTUtil.func_152460_a((NBTTagCompound)nbt, (GameProfile)this.owner);
            data.setTag("owner", (NBTBase)nbt);
        }
    }
}

