/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.recipes;

import forestry.core.fluids.FluidHelper;
import forestry.factory.recipes.ISqueezerContainerRecipe;
import forestry.factory.recipes.ISqueezerRecipe;
import forestry.factory.recipes.SqueezerRecipe;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class SqueezerContainerRecipe
implements ISqueezerContainerRecipe {
    private final ItemStack emptyContainer;
    private final int processingTime;
    private final ItemStack remnants;
    private final float remnantsChance;

    public SqueezerContainerRecipe(ItemStack emptyContainer, int processingTime, ItemStack remnants, float remnantsChance) {
        this.emptyContainer = emptyContainer;
        this.processingTime = processingTime;
        this.remnants = remnants;
        this.remnantsChance = remnantsChance;
    }

    @Override
    public ItemStack getEmptyContainer() {
        return this.emptyContainer;
    }

    @Override
    public int getProcessingTime() {
        return this.processingTime;
    }

    @Override
    public ItemStack getRemnants() {
        return this.remnants;
    }

    @Override
    public float getRemnantsChance() {
        return this.remnantsChance;
    }

    @Override
    public ISqueezerRecipe getSqueezerRecipe(ItemStack filledContainer) {
        FluidStack fluidOutput = FluidHelper.getFluidStackInContainer(filledContainer);
        ItemStack filledContainerCopy = filledContainer.copy();
        filledContainerCopy.stackSize = 1;
        return new SqueezerRecipe(this.processingTime, new ItemStack[]{filledContainerCopy}, fluidOutput, this.remnants, this.remnantsChance);
    }
}

