/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.render;

import forestry.arboriculture.WoodType;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class RenderFenceItem
implements IItemRenderer {
    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        switch (type) {
            case ENTITY: 
            case EQUIPPED_FIRST_PERSON: 
            case EQUIPPED: 
            case INVENTORY: {
                return true;
            }
        }
        return false;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return true;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        switch (type) {
            case ENTITY: {
                RenderFenceItem.renderItem((RenderBlocks)data[0], item, 0.0f, 0.0f, 0.0f);
                break;
            }
            case EQUIPPED_FIRST_PERSON: 
            case EQUIPPED: {
                RenderFenceItem.renderItem((RenderBlocks)data[0], item, 0.5f, 0.5f, 0.5f);
                break;
            }
            case INVENTORY: {
                RenderFenceItem.renderItem((RenderBlocks)data[0], item, 0.0f, 0.0f, 0.0f);
                break;
            }
        }
    }

    private static void renderItem(RenderBlocks renderer, ItemStack itemStack, float x, float y, float z) {
        Tessellator tess = Tessellator.instance;
        WoodType woodType = WoodType.getFromCompound(itemStack.getTagCompound());
        IIcon plankIcon = woodType.getPlankIcon();
        Block block = Block.getBlockFromItem((Item)itemStack.getItem());
        for (int i = 0; i < 4; ++i) {
            float thickness = 0.125f;
            if (i == 0) {
                block.setBlockBounds(0.5f - thickness, 0.0f, 0.0f, 0.5f + thickness, 1.0f, thickness * 2.0f);
            }
            if (i == 1) {
                block.setBlockBounds(0.5f - thickness, 0.0f, 1.0f - thickness * 2.0f, 0.5f + thickness, 1.0f, 1.0f);
            }
            thickness = 0.0625f;
            if (i == 2) {
                block.setBlockBounds(0.5f - thickness, 1.0f - thickness * 3.0f, -thickness * 2.0f, 0.5f + thickness, 1.0f - thickness, 1.0f + thickness * 2.0f);
            }
            if (i == 3) {
                block.setBlockBounds(0.5f - thickness, 0.5f - thickness * 3.0f, -thickness * 2.0f, 0.5f + thickness, 0.5f - thickness, 1.0f + thickness * 2.0f);
            }
            renderer.setRenderBoundsFromBlock(block);
            GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
            tess.startDrawingQuads();
            tess.setNormal(0.0f, -1.0f, 0.0f);
            renderer.renderFaceYNeg(block, (double)x, (double)y, (double)z, plankIcon);
            tess.draw();
            tess.startDrawingQuads();
            tess.setNormal(0.0f, 1.0f, 0.0f);
            renderer.renderFaceYPos(block, (double)x, (double)y, (double)z, plankIcon);
            tess.draw();
            tess.startDrawingQuads();
            tess.setNormal(0.0f, 0.0f, -1.0f);
            renderer.renderFaceZNeg(block, (double)x, (double)y, (double)z, plankIcon);
            tess.draw();
            tess.startDrawingQuads();
            tess.setNormal(0.0f, 0.0f, 1.0f);
            renderer.renderFaceZPos(block, (double)x, (double)y, (double)z, plankIcon);
            tess.draw();
            tess.startDrawingQuads();
            tess.setNormal(-1.0f, 0.0f, 0.0f);
            renderer.renderFaceXNeg(block, (double)x, (double)y, (double)z, plankIcon);
            tess.draw();
            tess.startDrawingQuads();
            tess.setNormal(1.0f, 0.0f, 0.0f);
            renderer.renderFaceXPos(block, (double)x, (double)y, (double)z, plankIcon);
            tess.draw();
            GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
        }
        block.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        renderer.setRenderBoundsFromBlock(block);
    }
}

