/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.render;

import forestry.arboriculture.WoodType;
import forestry.core.utils.ItemStackUtil;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class RenderStairItem
implements IItemRenderer {
    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        switch (type) {
            case ENTITY: 
            case EQUIPPED_FIRST_PERSON: 
            case EQUIPPED: 
            case INVENTORY: {
                return true;
            }
        }
        return false;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return true;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        switch (type) {
            case ENTITY: {
                RenderStairItem.renderStairBlock((RenderBlocks)data[0], item, 0.0f, 0.0f, 0.0f);
                break;
            }
            case EQUIPPED_FIRST_PERSON: 
            case EQUIPPED: {
                RenderStairItem.renderStairBlock((RenderBlocks)data[0], item, 0.5f, 0.5f, 0.5f);
                break;
            }
            case INVENTORY: {
                RenderStairItem.renderStairBlock((RenderBlocks)data[0], item, 0.0f, 0.0f, 0.0f);
                break;
            }
        }
    }

    private static void renderStairBlock(RenderBlocks renderBlocks, ItemStack item, float x, float y, float z) {
        Tessellator tessellator = Tessellator.instance;
        Block block = ItemStackUtil.getBlock(item);
        IIcon texture = WoodType.getFromCompound(item.getTagCompound()).getPlankIcon();
        for (int i = 0; i < 2; ++i) {
            if (i == 0) {
                renderBlocks.setRenderBounds(0.0, 0.0, 0.0, 1.0, 1.0, 0.5);
            }
            if (i == 1) {
                renderBlocks.setRenderBounds(0.0, 0.0, 0.5, 1.0, 0.5, 1.0);
            }
            GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
            tessellator.startDrawingQuads();
            tessellator.setNormal(0.0f, -1.0f, 0.0f);
            renderBlocks.renderFaceYNeg(block, (double)x, (double)y, (double)z, texture);
            tessellator.draw();
            tessellator.startDrawingQuads();
            tessellator.setNormal(0.0f, 1.0f, 0.0f);
            renderBlocks.renderFaceYPos(block, (double)x, (double)y, (double)z, texture);
            tessellator.draw();
            tessellator.startDrawingQuads();
            tessellator.setNormal(0.0f, 0.0f, -1.0f);
            renderBlocks.renderFaceZNeg(block, (double)x, (double)y, (double)z, texture);
            tessellator.draw();
            tessellator.startDrawingQuads();
            tessellator.setNormal(0.0f, 0.0f, 1.0f);
            renderBlocks.renderFaceZPos(block, (double)x, (double)y, (double)z, texture);
            tessellator.draw();
            tessellator.startDrawingQuads();
            tessellator.setNormal(-1.0f, 0.0f, 0.0f);
            renderBlocks.renderFaceXNeg(block, (double)x, (double)y, (double)z, texture);
            tessellator.draw();
            tessellator.startDrawingQuads();
            tessellator.setNormal(1.0f, 0.0f, 0.0f);
            renderBlocks.renderFaceXPos(block, (double)x, (double)y, (double)z, texture);
            tessellator.draw();
            GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
        }
    }
}

