/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.render;

import forestry.arboriculture.genetics.TreeHelper;
import forestry.arboriculture.items.ItemBlockLeaves;
import forestry.arboriculture.tiles.TileLeaves;
import forestry.core.proxy.Proxies;
import forestry.core.utils.ItemStackUtil;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class RenderLeavesItem
implements IItemRenderer {
    protected static final double OVERLAY_SHIFT = 0.001;

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        switch (type) {
            case ENTITY: 
            case EQUIPPED_FIRST_PERSON: 
            case EQUIPPED: 
            case INVENTORY: {
                return true;
            }
        }
        return false;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return true;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        switch (type) {
            case ENTITY: {
                RenderLeavesItem.renderItem((RenderBlocks)data[0], item, 0.0f, 0.0f, 0.0f);
                break;
            }
            case EQUIPPED_FIRST_PERSON: 
            case EQUIPPED: {
                RenderLeavesItem.renderItem((RenderBlocks)data[0], item, 0.5f, 0.5f, 0.5f);
                break;
            }
            case INVENTORY: {
                RenderLeavesItem.renderItem((RenderBlocks)data[0], item, 0.0f, 0.0f, 0.0f);
                break;
            }
        }
    }

    private static void renderItem(RenderBlocks renderer, ItemStack itemStack, float x, float y, float z) {
        Tessellator tessellator = Tessellator.instance;
        Block block = ItemStackUtil.getBlock(itemStack);
        if (!(itemStack.getItem() instanceof ItemBlockLeaves) || block == null) {
            return;
        }
        TileLeaves leaves = new TileLeaves();
        if (itemStack.hasTagCompound()) {
            leaves.readFromNBT(itemStack.getTagCompound());
        } else {
            leaves.setTree(TreeHelper.treeTemplates.get(0));
        }
        GL11.glEnable((int)3042);
        IIcon leavesIcon = leaves.getIcon(Proxies.render.fancyGraphicsEnabled());
        if (leavesIcon == null) {
            return;
        }
        int color = leaves.getFoliageColour(Proxies.common.getPlayer());
        float r1 = (float)(color >> 16 & 0xFF) / 255.0f;
        float g1 = (float)(color >> 8 & 0xFF) / 255.0f;
        float b1 = (float)(color & 0xFF) / 255.0f;
        GL11.glColor4f((float)r1, (float)g1, (float)b1, (float)1.0f);
        GL11.glTranslatef((float)x, (float)y, (float)z);
        block.setBlockBoundsForItemRender();
        renderer.setRenderBoundsFromBlock(block);
        GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        tessellator.startDrawingQuads();
        tessellator.setNormal(0.0f, -1.0f, 0.0f);
        renderer.renderFaceYNeg(block, 0.0, 0.0, 0.0, leavesIcon);
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setNormal(0.0f, 1.0f, 0.0f);
        renderer.renderFaceYPos(block, 0.0, 0.0, 0.0, leavesIcon);
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setNormal(0.0f, 0.0f, -1.0f);
        renderer.renderFaceZNeg(block, 0.0, 0.0, 0.0, leavesIcon);
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setNormal(0.0f, 0.0f, 1.0f);
        renderer.renderFaceZPos(block, 0.0, 0.0, 0.0, leavesIcon);
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setNormal(-1.0f, 0.0f, 0.0f);
        renderer.renderFaceXNeg(block, 0.0, 0.0, 0.0, leavesIcon);
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setNormal(1.0f, 0.0f, 0.0f);
        renderer.renderFaceXPos(block, 0.0, 0.0, 0.0, leavesIcon);
        tessellator.draw();
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
        if (!leaves.hasFruit()) {
            return;
        }
        IIcon fruitTexture = leaves.getFruitTexture();
        if (fruitTexture == null) {
            return;
        }
        int fruitColor = leaves.getFruitColour();
        float r2 = (float)(fruitColor >> 16 & 0xFF) / 255.0f;
        float g2 = (float)(fruitColor >> 8 & 0xFF) / 255.0f;
        float b2 = (float)(fruitColor & 0xFF) / 255.0f;
        GL11.glColor4f((float)r2, (float)g2, (float)b2, (float)1.0f);
        block.setBlockBoundsForItemRender();
        renderer.setRenderBoundsFromBlock(block);
        GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        tessellator.startDrawingQuads();
        tessellator.setNormal(0.0f, -1.0f, 0.0f);
        renderer.renderFaceYNeg(block, 0.0, -0.001, 0.0, fruitTexture);
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setNormal(0.0f, 1.0f, 0.0f);
        renderer.renderFaceYPos(block, 0.0, 0.001, 0.0, fruitTexture);
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setNormal(0.0f, 0.0f, -1.0f);
        renderer.renderFaceZNeg(block, 0.0, 0.0, -0.001, fruitTexture);
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setNormal(0.0f, 0.0f, 1.0f);
        renderer.renderFaceZPos(block, 0.0, 0.0, 0.001, fruitTexture);
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setNormal(-1.0f, 0.0f, 0.0f);
        renderer.renderFaceXNeg(block, -0.001, 0.0, 0.0, fruitTexture);
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setNormal(1.0f, 0.0f, 0.0f);
        renderer.renderFaceXPos(block, 0.001, 0.0, 0.0, fruitTexture);
        tessellator.draw();
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
    }
}

