/*
 * Decompiled with CFR 0.152.
 */
package forestry.lepidopterology.items;

import forestry.api.core.ForestryAPI;
import forestry.api.core.Tabs;
import forestry.api.lepidopterology.IButterfly;
import forestry.core.config.Config;
import forestry.core.gui.IHintSource;
import forestry.core.items.ItemAlyzer;
import forestry.core.network.GuiId;
import forestry.plugins.PluginLepidopterology;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class ItemFlutterlyzer
extends ItemAlyzer {
    public ItemFlutterlyzer() {
        this.setMaxStackSize(1);
        this.setCreativeTab(Tabs.tabLepidopterology);
    }

    public ItemStack onItemRightClick(ItemStack itemstack, World world, EntityPlayer entityplayer) {
        if (!world.isRemote) {
            entityplayer.openGui(ForestryAPI.instance, GuiId.FlutterlyzerGUI.ordinal(), world, (int)entityplayer.posX, (int)entityplayer.posY, (int)entityplayer.posZ);
        }
        return itemstack;
    }

    public static class FlutterlyzerInventory
    extends ItemAlyzer.AlyzerInventory
    implements IHintSource {
        public FlutterlyzerInventory(EntityPlayer player, ItemStack itemStack) {
            super(player, 7, itemStack);
        }

        @Override
        protected boolean isSpecimen(ItemStack itemStack) {
            return PluginLepidopterology.butterflyInterface.isMember(itemStack);
        }

        @Override
        public void onSlotClick(EntityPlayer player) {
            if (this.getStackInSlot(0) == null) {
                return;
            }
            IButterfly butterfly = PluginLepidopterology.butterflyInterface.getMember(this.getStackInSlot(0));
            if (butterfly == null) {
                return;
            }
            if (!butterfly.isAnalyzed()) {
                if (!FlutterlyzerInventory.isEnergy(this.getStackInSlot(5))) {
                    return;
                }
                butterfly.analyze();
                if (player != null) {
                    PluginLepidopterology.butterflyInterface.getBreedingTracker(player.worldObj, player.getGameProfile()).registerSpecies(butterfly.getGenome().getPrimary());
                    PluginLepidopterology.butterflyInterface.getBreedingTracker(player.worldObj, player.getGameProfile()).registerSpecies(butterfly.getGenome().getSecondary());
                }
                NBTTagCompound nbttagcompound = new NBTTagCompound();
                butterfly.writeToNBT(nbttagcompound);
                this.getStackInSlot(0).setTagCompound(nbttagcompound);
                this.decrStackSize(5, 1);
            }
            this.setInventorySlotContents(1, this.getStackInSlot(0));
            this.setInventorySlotContents(0, null);
        }

        @Override
        public boolean hasHints() {
            return Config.hints.get("flutterlyzer") != null && Config.hints.get("flutterlyzer").length > 0;
        }

        @Override
        public String[] getHints() {
            return Config.hints.get("flutterlyzer");
        }
    }
}

