/*
 * Decompiled with CFR 0.152.
 */
package forestry.energy.gui;

import forestry.core.gui.widgets.TankWidget;
import forestry.core.gui.widgets.Widget;
import forestry.core.gui.widgets.WidgetManager;
import forestry.core.proxy.Proxies;
import forestry.core.render.SpriteSheet;
import forestry.core.utils.StringUtil;
import forestry.energy.gui.ContainerEngineBronze;
import forestry.energy.gui.GuiEngine;
import forestry.energy.tiles.TileEngineBiogas;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.util.IIcon;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

public class GuiEngineBronze
extends GuiEngine<ContainerEngineBronze, TileEngineBiogas> {
    public GuiEngineBronze(InventoryPlayer inventory, TileEngineBiogas tile) {
        super("textures/gui/bioengine.png", new ContainerEngineBronze(inventory, tile), tile);
        this.widgetManager.add(new TankWidget(this.widgetManager, 89, 19, 0));
        this.widgetManager.add(new TankWidget(this.widgetManager, 107, 19, 1));
        this.widgetManager.add(new BiogasSlot(this.widgetManager, 30, 47));
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(float var1, int mouseX, int mouseY) {
        super.drawGuiContainerBackgroundLayer(var1, mouseX, mouseY);
        int temp = ((TileEngineBiogas)this.inventory).getOperatingTemperatureScaled(16);
        if (temp > 16) {
            temp = 16;
        }
        if (temp > 0) {
            this.drawTexturedModalRect(this.guiLeft + 53, this.guiTop + 47 + 16 - temp, 176, 76 - temp, 4, temp);
        }
    }

    protected class BiogasSlot
    extends Widget {
        public BiogasSlot(WidgetManager manager, int xPos, int yPos) {
            super(manager, xPos, yPos);
            this.height = 16;
        }

        @Override
        public void draw(int startX, int startY) {
            int x;
            if (GuiEngineBronze.this.inventory == null || ((TileEngineBiogas)((GuiEngineBronze)GuiEngineBronze.this).inventory).totalTime <= 0) {
                return;
            }
            Fluid fluid = FluidRegistry.getFluid((int)((TileEngineBiogas)((GuiEngineBronze)GuiEngineBronze.this).inventory).currentFluidId);
            if (fluid == null) {
                return;
            }
            IIcon liquidIcon = fluid.getIcon();
            if (liquidIcon == null) {
                return;
            }
            int squaled = ((TileEngineBiogas)((GuiEngineBronze)GuiEngineBronze.this).inventory).burnTime * this.height / ((TileEngineBiogas)((GuiEngineBronze)GuiEngineBronze.this).inventory).totalTime;
            if (squaled > this.height) {
                squaled = this.height;
            }
            Proxies.common.bindTexture(SpriteSheet.BLOCKS);
            int start = 0;
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            do {
                if (squaled > 16) {
                    x = 16;
                    squaled -= 16;
                } else {
                    x = squaled;
                    squaled = 0;
                }
                this.manager.gui.drawTexturedModelRectFromIcon(startX + this.xPos, startY + this.yPos + this.height - x - start, liquidIcon, 16, 16 - (16 - x));
                start += 16;
            } while (x != 0 && squaled != 0);
            Proxies.common.bindTexture(GuiEngineBronze.this.textureFile);
        }

        @Override
        public String getLegacyTooltip(EntityPlayer player) {
            Fluid fluid = FluidRegistry.getFluid((int)((TileEngineBiogas)((GuiEngineBronze)GuiEngineBronze.this).inventory).currentFluidId);
            if (fluid == null) {
                return StringUtil.localize("gui.empty");
            }
            return fluid.getLocalizedName(new FluidStack(fluid, 1));
        }
    }
}

