/*
 * Decompiled with CFR 0.152.
 */
package forestry.plugins;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.fuels.FuelManager;
import forestry.api.fuels.GeneratorFuel;
import forestry.core.config.Config;
import forestry.core.config.ForestryItem;
import forestry.core.config.GameMode;
import forestry.core.fluids.BlockForestryFluid;
import forestry.core.fluids.Fluids;
import forestry.core.fluids.LiquidRegistryHelper;
import forestry.core.items.ItemLiquidContainer;
import forestry.core.proxy.Proxies;
import forestry.core.utils.Log;
import forestry.plugins.ForestryPlugin;
import forestry.plugins.Plugin;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MovingObjectPosition;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.FillBucketEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

@Plugin(pluginID="Fluids", name="Fluids", author="mezz", url="http://forestry.sengir.net/", unlocalizedDescription="for.plugin.fluids.description")
public class PluginFluids
extends ForestryPlugin {
    private static final List<Fluids> forestryFluidsWithBlocks = new ArrayList<Fluids>();

    private static void createFluid(Fluids forestryFluid) {
        String fluidName;
        if (forestryFluid.getFluid() == null && Config.isFluidEnabled(forestryFluid) && !FluidRegistry.isFluidRegistered((String)(fluidName = forestryFluid.getTag()))) {
            Fluid fluid = new Fluid(fluidName).setDensity(forestryFluid.getDensity()).setViscosity(forestryFluid.getViscosity()).setTemperature(forestryFluid.getTemperature());
            FluidRegistry.registerFluid((Fluid)fluid);
            PluginFluids.createBlock(forestryFluid);
        }
    }

    private static void createBlock(Fluids forestryFluid) {
        Fluid fluid = forestryFluid.getFluid();
        Block fluidBlock = fluid.getBlock();
        if (Config.isBlockEnabled(forestryFluid.getTag())) {
            if (fluidBlock == null) {
                fluidBlock = forestryFluid.makeBlock();
                if (fluidBlock != null) {
                    fluidBlock.setBlockName("forestry.fluid." + forestryFluid.getTag());
                    Proxies.common.registerBlock(fluidBlock, ItemBlock.class);
                    forestryFluidsWithBlocks.add(forestryFluid);
                }
            } else {
                GameRegistry.UniqueIdentifier blockID = GameRegistry.findUniqueIdentifierFor((Block)fluidBlock);
                Log.severe("Pre-existing {0} fluid block detected, deferring to {1}:{2}, this may cause issues if the server/client have different mod load orders, recommended that you disable all but one instance of {0} fluid blocks via your configs.", fluid.getName(), blockID.modId, blockID.name);
            }
        }
    }

    @Override
    public void preInit() {
        for (Fluids fluidType : Fluids.forestryFluids) {
            PluginFluids.createFluid(fluidType);
        }
        MinecraftForge.EVENT_BUS.register(PluginFluids.getTextureHook());
        MinecraftForge.EVENT_BUS.register(PluginFluids.getFillBucketHook());
    }

    @Override
    public void registerItems() {
        for (ItemLiquidContainer.EnumContainerType type : ItemLiquidContainer.EnumContainerType.values()) {
            ItemLiquidContainer emptyContainer = new ItemLiquidContainer(type, Blocks.air, null);
            switch (type) {
                case CAN: {
                    ForestryItem.canEmpty.registerItem(emptyContainer, "canEmpty");
                    break;
                }
                case CAPSULE: {
                    ForestryItem.waxCapsule.registerItem(emptyContainer, "waxCapsule");
                    break;
                }
                case REFRACTORY: {
                    ForestryItem.refractoryEmpty.registerItem(emptyContainer, "refractoryEmpty");
                }
            }
            for (Fluids fluidType : Fluids.values()) {
                ForestryItem container = fluidType.getContainerForType(type);
                if (container == null) continue;
                ItemLiquidContainer liquidContainer = new ItemLiquidContainer(type, fluidType.getBlock(), fluidType.getColor());
                fluidType.setProperties(liquidContainer);
                container.registerItem(liquidContainer, container.toString());
            }
        }
    }

    @Override
    public void doInit() {
        for (Fluids fluidType : Fluids.values()) {
            if (fluidType.getFluid() == null) continue;
            for (ItemLiquidContainer.EnumContainerType type : ItemLiquidContainer.EnumContainerType.values()) {
                ForestryItem container = fluidType.getContainerForType(type);
                if (container == null) continue;
                LiquidRegistryHelper.registerLiquidContainer(fluidType, container.getItemStack());
            }
            for (ItemStack filledContainer : fluidType.getOtherContainers()) {
                LiquidRegistryHelper.registerLiquidContainer(fluidType, filledContainer);
            }
        }
        FluidStack ethanol = Fluids.ETHANOL.getFluid(1);
        GeneratorFuel ethanolFuel = new GeneratorFuel(ethanol, (int)(32.0f * GameMode.getGameMode().getFloatSetting("fuel.ethanol.generator")), 4);
        FuelManager.generatorFuel.put(ethanol.getFluid(), ethanolFuel);
        FluidStack biomass = Fluids.BIOMASS.getFluid(1);
        GeneratorFuel biomassFuel = new GeneratorFuel(biomass, (int)(8.0f * GameMode.getGameMode().getFloatSetting("fuel.biomass.generator")), 1);
        FuelManager.generatorFuel.put(biomass.getFluid(), biomassFuel);
    }

    @Override
    public void postInit() {
        for (Fluids fluidType : Fluids.forestryFluids) {
            if (fluidType.getFluid() != null || !Config.isFluidEnabled(fluidType)) continue;
            throw new MissingFluidException(fluidType.getTag());
        }
    }

    private static Object getTextureHook() {
        return new TextureHook();
    }

    private static Object getFillBucketHook() {
        return new FillBucketHook();
    }

    public static class FillBucketHook {
        @SubscribeEvent
        public void fillBucket(FillBucketEvent event) {
            ItemLiquidContainer filledBucket;
            MovingObjectPosition movingObjectPosition = event.target;
            int x = movingObjectPosition.blockX;
            int y = movingObjectPosition.blockY;
            int z = movingObjectPosition.blockZ;
            Block targetedBlock = event.world.getBlock(x, y, z);
            if (targetedBlock instanceof BlockForestryFluid && (filledBucket = ItemLiquidContainer.getExistingBucket(targetedBlock)) != null) {
                event.result = new ItemStack((Item)filledBucket);
                event.setResult(Event.Result.ALLOW);
                if (!event.world.isRemote) {
                    event.world.setBlockToAir(x, y, z);
                }
            }
        }
    }

    public static class TextureHook {
        @SubscribeEvent
        @SideOnly(value=Side.CLIENT)
        public void textureHook(TextureStitchEvent.Post event) {
            if (event.map.getTextureType() == 0) {
                for (Fluids fluidType : forestryFluidsWithBlocks) {
                    Fluid fluid = fluidType.getFluid();
                    Block fluidBlock = fluidType.getBlock();
                    if (fluid == null || fluidBlock == null) continue;
                    fluid.setIcons(fluidBlock.getBlockTextureFromSide(1), fluidBlock.getBlockTextureFromSide(2));
                }
            }
        }
    }

    public static class MissingFluidException
    extends RuntimeException {
        public MissingFluidException(String tag) {
            super("Fluid '" + tag + "' was not found. Please check your configs.");
        }
    }
}

