/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.fluids;

import forestry.core.utils.InventoryUtil;
import forestry.core.utils.ItemStackUtil;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;
import net.minecraftforge.fluids.IFluidHandler;

public final class FluidHelper {
    private FluidHelper() {
    }

    public static boolean handleRightClick(IFluidHandler tank, ForgeDirection side, EntityPlayer player, boolean fill, boolean drain) {
        if (player == null) {
            return false;
        }
        ItemStack current = player.inventory.getCurrentItem();
        if (current != null) {
            ItemStack filled;
            FluidStack available;
            FluidStack liquid = FluidHelper.getFluidStackInContainer(current);
            if (fill && liquid != null) {
                int used = tank.fill(side, liquid, true);
                if (used > 0) {
                    if (!player.capabilities.isCreativeMode) {
                        ItemStack drainedContainer = FluidHelper.getDrainedContainer(current, used);
                        if (current.stackSize > 1) {
                            player.inventory.decrStackSize(player.inventory.currentItem, 1);
                            if (drainedContainer != null && !player.inventory.addItemStackToInventory(drainedContainer)) {
                                player.dropPlayerItemWithRandomChoice(drainedContainer, false);
                            }
                        } else {
                            player.inventory.setInventorySlotContents(player.inventory.currentItem, drainedContainer);
                        }
                        player.inventory.markDirty();
                    }
                    return true;
                }
            } else if (drain && (available = tank.drain(side, Integer.MAX_VALUE, false)) != null && (liquid = FluidHelper.getFluidStackInContainer(filled = FluidHelper.getFilledContainer(available, current))) != null) {
                if (current.stackSize > 1) {
                    if (!player.inventory.addItemStackToInventory(filled)) {
                        return false;
                    }
                    player.inventory.setInventorySlotContents(player.inventory.currentItem, InventoryUtil.depleteItem(current));
                    player.inventory.markDirty();
                } else {
                    player.inventory.setInventorySlotContents(player.inventory.currentItem, InventoryUtil.depleteItem(current));
                    player.inventory.setInventorySlotContents(player.inventory.currentItem, filled);
                    player.inventory.markDirty();
                }
                tank.drain(side, liquid.amount, true);
                return true;
            }
        }
        return false;
    }

    public static boolean fillContainers(IFluidHandler fluidHandler, IInventory inv, int inputSlot, int outputSlot, Fluid fluidToFill) {
        return FluidHelper.fillContainers(fluidHandler, inv, inputSlot, outputSlot, fluidToFill, true);
    }

    public static boolean fillContainers(IFluidHandler fluidHandler, IInventory inv, int inputSlot, int outputSlot, Fluid fluidToFill, boolean doFill) {
        FluidStack fluidInContainer;
        FluidStack drain;
        ItemStack input = inv.getStackInSlot(inputSlot);
        ItemStack output = inv.getStackInSlot(outputSlot);
        ItemStack filled = FluidHelper.getFilledContainer(fluidToFill, input);
        if (filled != null && (output == null || output.stackSize < output.getMaxStackSize() && InventoryUtil.isItemEqual(filled, output)) && (drain = fluidHandler.drain(ForgeDirection.UNKNOWN, fluidInContainer = FluidHelper.getFluidStackInContainer(filled), false)) != null && drain.amount == fluidInContainer.amount) {
            if (doFill) {
                fluidHandler.drain(ForgeDirection.UNKNOWN, fluidInContainer, true);
                if (output == null) {
                    inv.setInventorySlotContents(outputSlot, filled);
                } else {
                    ++output.stackSize;
                }
                inv.decrStackSize(inputSlot, 1);
            }
            return true;
        }
        return false;
    }

    public static boolean drainContainers(IFluidHandler fluidHandler, IInventory inv, int slot) {
        return FluidHelper.drainContainers(fluidHandler, inv, slot, slot, 1000);
    }

    public static boolean drainContainers(IFluidHandler fluidHandler, IInventory inv, int inputSlot, int outputSlot, int maxAmount) {
        int used;
        ItemStack drainedItem;
        ItemStack input = inv.getStackInSlot(inputSlot);
        ItemStack output = inv.getStackInSlot(outputSlot);
        if (input == null) {
            return false;
        }
        FluidStack fluidInContainer = FluidHelper.getFluidStackInContainer(input);
        if (fluidInContainer == null) {
            return false;
        }
        if (fluidInContainer.amount > maxAmount) {
            fluidInContainer.amount = maxAmount;
        }
        if (ItemStack.areItemStacksEqual((ItemStack)input, (ItemStack)(drainedItem = FluidHelper.getDrainedContainer(input, used = fluidHandler.fill(ForgeDirection.UNKNOWN, fluidInContainer, false))))) {
            return false;
        }
        if (output != null && drainedItem != null) {
            if (outputSlot == inputSlot) {
                if (input.stackSize > 1) {
                    return false;
                }
            } else {
                if (!ItemStackUtil.isIdenticalItem(output, drainedItem)) {
                    return false;
                }
                if (output.stackSize + drainedItem.stackSize > output.getMaxStackSize()) {
                    return false;
                }
            }
        }
        fluidHandler.fill(ForgeDirection.UNKNOWN, fluidInContainer, true);
        if (drainedItem != null) {
            if (outputSlot == inputSlot) {
                inv.setInventorySlotContents(outputSlot, drainedItem);
                return true;
            }
            if (output == null) {
                inv.setInventorySlotContents(outputSlot, drainedItem);
            } else {
                ++output.stackSize;
            }
        }
        inv.decrStackSize(inputSlot, 1);
        return true;
    }

    public static boolean isFillableContainer(ItemStack stack, FluidStack liquid) {
        ItemStack empty = ItemStackUtil.createSplitStack(stack, 1);
        Item item = empty.getItem();
        if (item instanceof IFluidContainerItem) {
            IFluidContainerItem containerItem = (IFluidContainerItem)item;
            return containerItem.fill(empty, liquid, false) > 0;
        }
        for (FluidContainerRegistry.FluidContainerData cont : FluidContainerRegistry.getRegisteredFluidContainerData()) {
            if (!cont.fluid.isFluidEqual(liquid) || cont.emptyContainer == null || !cont.emptyContainer.isItemEqual(empty)) continue;
            return true;
        }
        return false;
    }

    public static boolean isEmptyContainer(ItemStack empty) {
        if (FluidContainerRegistry.isEmptyContainer((ItemStack)empty)) {
            return true;
        }
        Item item = empty.getItem();
        if (item instanceof IFluidContainerItem) {
            IFluidContainerItem containerItem = (IFluidContainerItem)item;
            FluidStack fluid = containerItem.getFluid(empty);
            return fluid == null || fluid.amount == 0;
        }
        return false;
    }

    public static ItemStack getDrainedContainer(ItemStack container, int drainAmount) {
        if (container == null) {
            return null;
        }
        if (drainAmount == 0) {
            return container;
        }
        Item item = container.getItem();
        if (item == null) {
            return null;
        }
        if (item instanceof IFluidContainerItem) {
            ItemStack drained = container.copy();
            drained.stackSize = 1;
            IFluidContainerItem containerItem = (IFluidContainerItem)item;
            containerItem.drain(drained, drainAmount, true);
            return drained;
        }
        if (drainAmount < 1000) {
            return container;
        }
        return item.getContainerItem(container);
    }

    public static ItemStack getFilledContainer(Fluid fluid, ItemStack empty) {
        if (fluid == null) {
            return null;
        }
        FluidStack fluidToFill = new FluidStack(fluid, Integer.MAX_VALUE);
        return FluidHelper.getFilledContainer(fluidToFill, empty);
    }

    public static ItemStack getFilledContainer(FluidStack liquid, ItemStack empty) {
        if (liquid == null || empty == null) {
            return null;
        }
        Item item = empty.getItem();
        if (item instanceof IFluidContainerItem) {
            ItemStack full = empty.copy();
            full.stackSize = 1;
            IFluidContainerItem containerItem = (IFluidContainerItem)item;
            containerItem.fill(full, liquid, true);
            return full;
        }
        return FluidContainerRegistry.fillFluidContainer((FluidStack)liquid, (ItemStack)empty);
    }

    public static FluidStack getFluidStackInContainer(ItemStack stack) {
        Item item = stack.getItem();
        if (item instanceof IFluidContainerItem) {
            IFluidContainerItem containerItem = (IFluidContainerItem)item;
            return containerItem.getFluid(stack);
        }
        return FluidContainerRegistry.getFluidForFilledItem((ItemStack)stack);
    }

    public static Fluid getFluidInContainer(ItemStack stack) {
        FluidStack fluidStack = FluidHelper.getFluidStackInContainer(stack);
        return fluidStack != null ? fluidStack.getFluid() : null;
    }

    public static boolean containsFluidStack(ItemStack stack, FluidStack fluidStack) {
        Item item = stack.getItem();
        if (item instanceof IFluidContainerItem) {
            IFluidContainerItem containerItem = (IFluidContainerItem)item;
            FluidStack contained = containerItem.getFluid(stack);
            return contained != null && contained.containsFluid(fluidStack);
        }
        return FluidContainerRegistry.containsFluid((ItemStack)stack, (FluidStack)fluidStack);
    }

    public static boolean containsFluid(ItemStack stack, Fluid fluid) {
        return FluidHelper.containsFluidStack(stack, new FluidStack(fluid, 1));
    }
}

