/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.core.Tabs;
import forestry.arboriculture.IWoodTyped;
import forestry.arboriculture.WoodType;
import forestry.arboriculture.blocks.BlockWood;
import forestry.arboriculture.tiles.TileWood;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockArbStairs
extends BlockStairs
implements IWoodTyped,
ITileEntityProvider {
    private final boolean fireproof;

    public BlockArbStairs(Block par2Block, boolean fireproof) {
        super(par2Block, 0);
        this.fireproof = fireproof;
        this.setCreativeTab(Tabs.tabArboriculture);
        this.setHardness(2.0f);
        this.setResistance(5.0f);
        this.setHarvestLevel("axe", 0);
    }

    @SideOnly(value=Side.CLIENT)
    public void getSubBlocks(Item item, CreativeTabs tab, List list) {
        for (WoodType woodType : WoodType.VALUES) {
            list.add(woodType.getStairs(this.fireproof));
        }
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z) {
        return TileWood.blockRemovedByPlayer(this, world, player, x, y, z);
    }

    public void breakBlock(World world, int x, int y, int z, Block block, int meta) {
        world.removeTileEntity(x, y, z);
        super.breakBlock(world, x, y, z, block, meta);
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        return new ArrayList<ItemStack>();
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        ItemStack itemStack = super.getPickBlock(target, world, x, y, z);
        NBTTagCompound stairsNBT = BlockWood.getTagCompound((IBlockAccess)world, x, y, z);
        itemStack.setTagCompound(stairsNBT);
        return itemStack;
    }

    @SideOnly(value=Side.CLIENT)
    public void registerBlockIcons(IIconRegister register) {
        WoodType.registerIcons(register);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(int side, int meta) {
        return WoodType.ACACIA.getPlankIcon();
    }

    public IIcon getIcon(IBlockAccess world, int x, int y, int z, int side) {
        TileWood wood = BlockWood.getWoodTile(world, x, y, z);
        WoodType type = wood.getWoodType();
        return type.getPlankIcon();
    }

    public boolean getUseNeighborBrightness() {
        return true;
    }

    @Override
    public String getBlockKind() {
        return "stairs";
    }

    @Override
    public boolean isFireproof() {
        return this.fireproof;
    }

    public TileEntity createNewTileEntity(World p_149915_1_, int p_149915_2_) {
        return new TileWood();
    }
}

