/*
 * Decompiled with CFR 0.152.
 */
package forestry.plugins;

import com.google.common.collect.ImmutableMap;
import cpw.mods.fml.common.registry.GameRegistry;
import forestry.api.farming.Farmables;
import forestry.api.recipes.RecipeManagers;
import forestry.api.storage.BackpackManager;
import forestry.core.GameMode;
import forestry.core.config.ForestryItem;
import forestry.core.fluids.Fluids;
import forestry.core.proxy.Proxies;
import forestry.core.utils.RecipeUtil;
import forestry.farming.logic.FarmableBasicGrowthCraft;
import forestry.plugins.ForestryPlugin;
import forestry.plugins.Plugin;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;

@Plugin(pluginID="Growthcraft", name="Growthcraft", author="Nirek", url="http://forestry.sengir.net/", unlocalizedDescription="for.plugin.growthcraft.description")
public class PluginGrowthCraft
extends ForestryPlugin {
    private static final String GC = "Growthcraft";

    @Override
    public boolean isAvailable() {
        return Proxies.common.isModLoaded(GC);
    }

    @Override
    public String getFailMessage() {
        return "GrowthCraft not found";
    }

    @Override
    protected void registerRecipes() {
        ItemStack bambooLeaves;
        Block grapeBlock;
        ItemStack grapes;
        Block riceBlock;
        Block hopVine;
        ItemStack hops;
        int saplingYield = GameMode.getGameMode().getIntegerSetting("fermenter.yield.sapling");
        int juiceAmount = GameMode.getGameMode().getIntegerSetting("squeezer.liquid.apple");
        int seedamount = GameMode.getGameMode().getIntegerSetting("squeezer.liquid.seed");
        ItemStack appleSeed = GameRegistry.findItemStack((String)"Growthcraft|Apples", (String)"grc.appleSeeds", (int)1);
        ItemStack grapeSeed = GameRegistry.findItemStack((String)"Growthcraft|Grapes", (String)"grc.grapeSeeds", (int)1);
        ItemStack hopSeed = GameRegistry.findItemStack((String)"Growthcraft|Hops", (String)"grc.hopSeeds", (int)1);
        ItemStack riceSeed = GameRegistry.findItemStack((String)"Growthcraft|Rice", (String)"grc.rice", (int)1);
        if (appleSeed != null) {
            RecipeManagers.squeezerManager.addRecipe(10, new ItemStack[]{appleSeed}, Fluids.SEEDOIL.getFluid(seedamount));
            BackpackManager.backpackItems[2].add(appleSeed);
        }
        if (grapeSeed != null) {
            RecipeManagers.squeezerManager.addRecipe(10, new ItemStack[]{grapeSeed}, Fluids.SEEDOIL.getFluid(seedamount));
            BackpackManager.backpackItems[2].add(grapeSeed);
        }
        if (hopSeed != null) {
            RecipeManagers.squeezerManager.addRecipe(10, new ItemStack[]{hopSeed}, Fluids.SEEDOIL.getFluid(seedamount));
            BackpackManager.backpackItems[2].add(hopSeed);
        }
        if (riceSeed != null) {
            RecipeManagers.squeezerManager.addRecipe(10, new ItemStack[]{riceSeed}, Fluids.SEEDOIL.getFluid(seedamount));
            BackpackManager.backpackItems[2].add(riceSeed);
        }
        if ((hops = GameRegistry.findItemStack((String)"Growthcraft|Hops", (String)"grc.hops", (int)1)) != null) {
            RecipeUtil.injectLeveledRecipe(hops, saplingYield, Fluids.BIOMASS);
            BackpackManager.backpackItems[2].add(hops);
        }
        if ((hopVine = GameRegistry.findBlock((String)"Growthcraft|Hops", (String)"grc.hopVine")) != null) {
            Farmables.farmables.get("farmOrchard").add(new FarmableBasicGrowthCraft(hopVine, 3, false, false));
        }
        if ((riceBlock = GameRegistry.findBlock((String)"Growthcraft|Rice", (String)"grc.riceBlock")) != null) {
            Farmables.farmables.get("farmOrchard").add(new FarmableBasicGrowthCraft(riceBlock, 7, true, false));
        }
        ItemStack emptyComb = new ItemStack(GameRegistry.findItem((String)"Growthcraft|Bees", (String)"grc.honeyComb"), 1, 0);
        ItemStack fullComb = new ItemStack(GameRegistry.findItem((String)"Growthcraft|Bees", (String)"grc.honeyComb"), 1, 1);
        RecipeManagers.centrifugeManager.addRecipe(20, emptyComb, (Map<ItemStack, Float>)ImmutableMap.of((Object)ForestryItem.beeswax.getItemStack(), (Object)Float.valueOf(1.0f)));
        RecipeManagers.centrifugeManager.addRecipe(20, fullComb, (Map<ItemStack, Float>)ImmutableMap.of((Object)ForestryItem.beeswax.getItemStack(), (Object)Float.valueOf(1.0f), (Object)ForestryItem.honeyDrop.getItemStack(), (Object)Float.valueOf(0.9f), (Object)ForestryItem.honeydew.getItemStack(), (Object)Float.valueOf(0.1f)));
        ItemStack bamboo = GameRegistry.findItemStack((String)"Growthcraft|Bamboo", (String)"grc.bamboo", (int)1);
        ItemStack bambooShoot = GameRegistry.findItemStack((String)"Growthcraft|Bamboo", (String)"grc.bambooShoot", (int)1);
        ItemStack bambooShootFood = GameRegistry.findItemStack((String)"Growthcraft|Bamboo", (String)"grc.bambooShootFood", (int)1);
        if (bamboo != null) {
            RecipeUtil.injectLeveledRecipe(bamboo, saplingYield, Fluids.BIOMASS);
            BackpackManager.backpackItems[2].add(bamboo);
        }
        if (bambooShoot != null) {
            RecipeUtil.injectLeveledRecipe(bambooShoot, saplingYield, Fluids.BIOMASS);
            BackpackManager.backpackItems[2].add(bambooShoot);
        }
        if (bambooShootFood != null) {
            RecipeUtil.injectLeveledRecipe(bambooShootFood, saplingYield, Fluids.BIOMASS);
            BackpackManager.backpackItems[2].add(bambooShootFood);
        }
        if ((grapes = GameRegistry.findItemStack((String)"Growthcraft|Grapes", (String)"grc.grapes", (int)1)) != null) {
            RecipeManagers.squeezerManager.addRecipe(10, new ItemStack[]{grapes}, Fluids.JUICE.getFluid(juiceAmount));
        }
        if ((grapeBlock = GameRegistry.findBlock((String)"Growthcraft|Grapes", (String)"grc.grapeBlock")) != null) {
            Farmables.farmables.get("farmOrchard").add(new FarmableBasicGrowthCraft(grapeBlock, 0, false, true));
        }
        if ((bambooLeaves = GameRegistry.findItemStack((String)"Growthcraft|Bamboo", (String)"grc.bambooLeaves", (int)1)) != null) {
            BackpackManager.backpackItems[2].add(bambooLeaves);
        }
    }
}

