/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.network;

import forestry.core.circuits.ISocketable;
import forestry.core.network.DataInputStreamForestry;
import forestry.core.network.DataOutputStreamForestry;
import forestry.core.network.PacketCoordinates;
import forestry.core.network.PacketId;
import java.io.IOException;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;

public class PacketSocketUpdate
extends PacketCoordinates {
    public ItemStack[] itemStacks;

    public PacketSocketUpdate(DataInputStreamForestry data) throws IOException {
        super(data);
    }

    public <T extends TileEntity> PacketSocketUpdate(T tile) {
        super(PacketId.SOCKET_UPDATE, tile);
        this.itemStacks = new ItemStack[((ISocketable)tile).getSocketCount()];
        for (int i = 0; i < ((ISocketable)tile).getSocketCount(); ++i) {
            this.itemStacks[i] = ((ISocketable)tile).getSocket(i);
        }
    }

    @Override
    protected void writeData(DataOutputStreamForestry data) throws IOException {
        super.writeData(data);
        data.writeItemStacks(this.itemStacks);
    }

    @Override
    protected void readData(DataInputStreamForestry data) throws IOException {
        super.readData(data);
        this.itemStacks = data.readItemStacks();
    }
}

