/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.recipes.nei;

import codechicken.nei.api.API;
import codechicken.nei.api.IConfigureNEI;
import codechicken.nei.recipe.ICraftingHandler;
import codechicken.nei.recipe.IUsageHandler;
import forestry.core.proxy.Proxies;
import forestry.factory.recipes.nei.IRecipeHandlerBase;
import forestry.factory.recipes.nei.NEIHandlerBottler;
import forestry.factory.recipes.nei.NEIHandlerCarpenter;
import forestry.factory.recipes.nei.NEIHandlerCentrifuge;
import forestry.factory.recipes.nei.NEIHandlerFabricator;
import forestry.factory.recipes.nei.NEIHandlerFermenter;
import forestry.factory.recipes.nei.NEIHandlerMoistener;
import forestry.factory.recipes.nei.NEIHandlerShapedCustom;
import forestry.factory.recipes.nei.NEIHandlerShapelessCustom;
import forestry.factory.recipes.nei.NEIHandlerSqueezer;
import forestry.factory.recipes.nei.NEIHandlerStill;

public class NEIIntegrationConfig
implements IConfigureNEI {
    public void loadConfig() {
        Proxies.log.info("Loading: " + this.getName());
        NEIIntegrationConfig.registerHandler(new NEIHandlerShapedCustom());
        NEIIntegrationConfig.registerHandler(new NEIHandlerShapelessCustom());
        NEIIntegrationConfig.registerHandler(new NEIHandlerBottler());
        NEIIntegrationConfig.registerHandler(new NEIHandlerCarpenter());
        NEIIntegrationConfig.registerHandler(new NEIHandlerCentrifuge());
        NEIIntegrationConfig.registerHandler(new NEIHandlerFabricator());
        NEIIntegrationConfig.registerHandler(new NEIHandlerFermenter());
        NEIIntegrationConfig.registerHandler(new NEIHandlerMoistener());
        NEIIntegrationConfig.registerHandler(new NEIHandlerSqueezer());
        NEIIntegrationConfig.registerHandler(new NEIHandlerStill());
    }

    protected static void registerHandler(IRecipeHandlerBase handler) {
        handler.prepare();
        API.registerRecipeHandler((ICraftingHandler)handler);
        API.registerUsageHandler((IUsageHandler)handler);
    }

    public String getName() {
        return "Forestry NEI Integration";
    }

    public String getVersion() {
        return "1.0.0";
    }
}

