/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.logic;

import forestry.api.farming.ICrop;
import forestry.api.farming.IFarmable;
import forestry.core.vect.Vect;
import forestry.farming.logic.CropBlock;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class FarmableGenericCrop
implements IFarmable {
    private final ItemStack seed;
    private final Block block;
    private final int mature;
    private final ItemStack[] windfall;

    public FarmableGenericCrop(ItemStack seed, Block block, int mature, ItemStack ... windfall) {
        this.seed = seed;
        this.block = block;
        this.mature = mature;
        this.windfall = windfall;
    }

    @Override
    public boolean isSaplingAt(World world, int x, int y, int z) {
        return world.getBlock(x, y, z) == this.block;
    }

    @Override
    public ICrop getCropAt(World world, int x, int y, int z) {
        if (world.getBlock(x, y, z) != this.block) {
            return null;
        }
        if (world.getBlockMetadata(x, y, z) != this.mature) {
            return null;
        }
        return new CropBlock(world, this.block, this.mature, new Vect(x, y, z));
    }

    @Override
    public boolean isGermling(ItemStack itemstack) {
        if (this.seed.getItem() != itemstack.getItem()) {
            return false;
        }
        if (this.seed.getItemDamage() >= 0) {
            return this.seed.getItemDamage() == itemstack.getItemDamage();
        }
        return true;
    }

    @Override
    public boolean plantSaplingAt(EntityPlayer player, ItemStack germling, World world, int x, int y, int z) {
        return germling.copy().tryPlaceItemIntoWorld(player, world, x, y - 1, z, 1, 0.0f, 0.0f, 0.0f);
    }

    @Override
    public boolean isWindfall(ItemStack itemstack) {
        for (ItemStack drop : this.windfall) {
            if (!drop.isItemEqual(itemstack)) continue;
            return true;
        }
        return false;
    }
}

