/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.utils;

import forestry.core.utils.RecipeUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class ShapelessRecipeCustom
implements IRecipe {
    private final List<ItemStack> ingredients;
    private final ItemStack product;
    private boolean preservesNbt = false;

    public static ShapelessRecipeCustom buildRecipe(ItemStack product, ItemStack ... ingredients) {
        ShapelessRecipeCustom recipe = new ShapelessRecipeCustom(product, ingredients);
        CraftingManager.getInstance().getRecipeList().add(recipe);
        return recipe;
    }

    public static ShapelessRecipeCustom buildPriorityRecipe(ItemStack product, ItemStack ... ingredients) {
        ShapelessRecipeCustom recipe = new ShapelessRecipeCustom(product, ingredients);
        CraftingManager.getInstance().getRecipeList().add(0, recipe);
        return recipe;
    }

    private ShapelessRecipeCustom(ItemStack product, ItemStack ... ingredients) {
        this.ingredients = Arrays.asList(ingredients);
        this.product = product;
    }

    public ShapelessRecipeCustom setPreserveNBT() {
        this.preservesNbt = true;
        return this;
    }

    public boolean preservesNbt() {
        return this.preservesNbt;
    }

    public boolean matches(InventoryCrafting inventoryCrafting, World world) {
        ArrayList<ItemStack> arraylist = new ArrayList<ItemStack>(this.ingredients);
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                ItemStack itemstack = inventoryCrafting.getStackInRowAndColumn(j, i);
                if (itemstack == null) continue;
                boolean flag = false;
                for (ItemStack itemstack1 : arraylist) {
                    if (itemstack.getItem() != itemstack1.getItem() || itemstack1.getItemDamage() != Short.MAX_VALUE && itemstack.getItemDamage() != itemstack1.getItemDamage()) continue;
                    flag = true;
                    arraylist.remove(itemstack1);
                    break;
                }
                if (flag) continue;
                return false;
            }
        }
        return arraylist.isEmpty();
    }

    public ItemStack getCraftingResult(InventoryCrafting inventoryCrafting) {
        ItemStack result = this.product.copy();
        if (this.preservesNbt) {
            NBTTagCompound craftingNbt = RecipeUtil.getCraftingNbt((IInventory)inventoryCrafting);
            if (craftingNbt == null) {
                return null;
            }
            result.setTagCompound(craftingNbt);
        }
        return result;
    }

    public int getRecipeSize() {
        return this.ingredients.size();
    }

    public List<ItemStack> getIngredients() {
        return this.ingredients;
    }

    public ItemStack getRecipeOutput() {
        return this.product.copy();
    }
}

