/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.multiblock;

import forestry.core.multiblock.CoordTriplet;
import forestry.core.multiblock.IMultiblockPart;
import forestry.core.multiblock.MultiblockControllerBase;
import forestry.core.proxy.Proxies;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;

public class MultiblockWorldRegistry {
    private World worldObj;
    private final Set<MultiblockControllerBase> controllers;
    private final Set<MultiblockControllerBase> dirtyControllers;
    private final Set<MultiblockControllerBase> deadControllers;
    private Set<IMultiblockPart> orphanedParts;
    private final Set<IMultiblockPart> detachedParts;
    private final HashMap<Long, Set<IMultiblockPart>> partsAwaitingChunkLoad;
    private final Object partsAwaitingChunkLoadMutex;
    private final Object orphanedPartsMutex;

    public MultiblockWorldRegistry(World world) {
        this.worldObj = world;
        this.controllers = new HashSet<MultiblockControllerBase>();
        this.deadControllers = new HashSet<MultiblockControllerBase>();
        this.dirtyControllers = new HashSet<MultiblockControllerBase>();
        this.detachedParts = new HashSet<IMultiblockPart>();
        this.orphanedParts = new HashSet<IMultiblockPart>();
        this.partsAwaitingChunkLoad = new HashMap();
        this.partsAwaitingChunkLoadMutex = new Object();
        this.orphanedPartsMutex = new Object();
    }

    public void tickStart() {
        if (this.controllers.size() > 0) {
            for (MultiblockControllerBase controller : this.controllers) {
                if (controller.worldObj != this.worldObj || controller.worldObj.isRemote != this.worldObj.isRemote) continue;
                if (controller.isEmpty()) {
                    this.deadControllers.add(controller);
                    continue;
                }
                controller.updateMultiblockEntity();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processMultiblockChanges() {
        IChunkProvider chunkProvider = this.worldObj.getChunkProvider();
        ArrayList<Set<MultiblockControllerBase>> mergePools = null;
        if (this.orphanedParts.size() > 0) {
            Set<IMultiblockPart> orphansToProcess = null;
            Object object = this.orphanedPartsMutex;
            synchronized (object) {
                if (this.orphanedParts.size() > 0) {
                    orphansToProcess = this.orphanedParts;
                    this.orphanedParts = new HashSet<IMultiblockPart>();
                }
            }
            if (orphansToProcess != null && orphansToProcess.size() > 0) {
                for (IMultiblockPart orphan : orphansToProcess) {
                    CoordTriplet coord = orphan.getWorldLocation();
                    if (!chunkProvider.chunkExists(coord.getChunkX(), coord.getChunkZ()) || orphan.isInvalid() || this.worldObj.getTileEntity(coord.x, coord.y, coord.z) != orphan) continue;
                    Set<MultiblockControllerBase> set = orphan.attachToNeighbors();
                    if (set == null) {
                        MultiblockControllerBase newController = orphan.createNewMultiblock();
                        newController.attachBlock(orphan);
                        this.controllers.add(newController);
                        continue;
                    }
                    if (set.size() <= 1) continue;
                    if (mergePools == null) {
                        mergePools = new ArrayList<Set<MultiblockControllerBase>>();
                    }
                    ArrayList<Set> candidatePools = new ArrayList<Set>();
                    for (Set set2 : mergePools) {
                        if (Collections.disjoint(set2, set)) continue;
                        candidatePools.add(set2);
                    }
                    if (candidatePools.size() <= 0) {
                        mergePools.add(set);
                        continue;
                    }
                    if (candidatePools.size() == 1) {
                        ((Set)candidatePools.get(0)).addAll(set);
                        continue;
                    }
                    Set masterPool = (Set)candidatePools.get(0);
                    for (int i = 1; i < candidatePools.size(); ++i) {
                        Set set3 = (Set)candidatePools.get(i);
                        masterPool.addAll(set3);
                        mergePools.remove(set3);
                    }
                    masterPool.addAll(set);
                }
            }
        }
        if (mergePools != null && mergePools.size() > 0) {
            for (Set set : mergePools) {
                MultiblockControllerBase newMaster = null;
                for (MultiblockControllerBase controller : set) {
                    if (newMaster != null && !controller.shouldConsume(newMaster)) continue;
                    newMaster = controller;
                }
                if (newMaster == null) {
                    Proxies.log.severe("Multiblock system checked a merge pool of size %d, found no master candidates. This should never happen.", (Object)set.size());
                    continue;
                }
                this.addDirtyController(newMaster);
                for (MultiblockControllerBase controller : set) {
                    if (controller == newMaster) continue;
                    newMaster.assimilate(controller);
                    this.addDeadController(controller);
                    this.addDirtyController(newMaster);
                }
            }
        }
        if (this.dirtyControllers.size() > 0) {
            for (MultiblockControllerBase multiblockControllerBase : this.dirtyControllers) {
                if (multiblockControllerBase == null) continue;
                Set<IMultiblockPart> newlyDetachedParts = multiblockControllerBase.checkForDisconnections();
                if (!multiblockControllerBase.isEmpty()) {
                    multiblockControllerBase.recalculateMinMaxCoords();
                    multiblockControllerBase.checkIfMachineIsWhole();
                } else {
                    this.addDeadController(multiblockControllerBase);
                }
                if (newlyDetachedParts == null || newlyDetachedParts.size() <= 0) continue;
                this.detachedParts.addAll(newlyDetachedParts);
            }
            this.dirtyControllers.clear();
        }
        if (this.deadControllers.size() > 0) {
            for (MultiblockControllerBase multiblockControllerBase : this.deadControllers) {
                if (!multiblockControllerBase.isEmpty()) {
                    Proxies.log.severe("Found a non-empty controller. Forcing it to shed its blocks and die. This should never happen!");
                    this.detachedParts.addAll(multiblockControllerBase.detachAllBlocks());
                }
                this.controllers.remove(multiblockControllerBase);
            }
            this.deadControllers.clear();
        }
        for (IMultiblockPart iMultiblockPart : this.detachedParts) {
            iMultiblockPart.assertDetached();
        }
        this.addAllOrphanedPartsThreadsafe(this.detachedParts);
        this.detachedParts.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onPartAdded(IMultiblockPart part) {
        CoordTriplet worldLocation = part.getWorldLocation();
        if (!this.worldObj.getChunkProvider().chunkExists(worldLocation.getChunkX(), worldLocation.getChunkZ())) {
            long chunkHash = worldLocation.getChunkXZHash();
            Object object = this.partsAwaitingChunkLoadMutex;
            synchronized (object) {
                Set<Object> partSet;
                if (!this.partsAwaitingChunkLoad.containsKey(chunkHash)) {
                    partSet = new HashSet();
                    this.partsAwaitingChunkLoad.put(chunkHash, partSet);
                } else {
                    partSet = this.partsAwaitingChunkLoad.get(chunkHash);
                }
                partSet.add((Object)part);
            }
        } else {
            this.addOrphanedPartThreadsafe(part);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onPartRemovedFromWorld(IMultiblockPart part) {
        long hash;
        CoordTriplet coord = part.getWorldLocation();
        if (coord != null && this.partsAwaitingChunkLoad.containsKey(hash = coord.getChunkXZHash())) {
            Object object = this.partsAwaitingChunkLoadMutex;
            synchronized (object) {
                if (this.partsAwaitingChunkLoad.containsKey(hash)) {
                    this.partsAwaitingChunkLoad.get(hash).remove((Object)part);
                    if (this.partsAwaitingChunkLoad.get(hash).size() <= 0) {
                        this.partsAwaitingChunkLoad.remove(hash);
                    }
                }
            }
        }
        this.detachedParts.remove((Object)part);
        if (this.orphanedParts.contains((Object)part)) {
            Object object = this.orphanedPartsMutex;
            synchronized (object) {
                this.orphanedParts.remove((Object)part);
            }
        }
        part.assertDetached();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onWorldUnloaded() {
        this.controllers.clear();
        this.deadControllers.clear();
        this.dirtyControllers.clear();
        this.detachedParts.clear();
        Object object = this.partsAwaitingChunkLoadMutex;
        synchronized (object) {
            this.partsAwaitingChunkLoad.clear();
        }
        object = this.orphanedPartsMutex;
        synchronized (object) {
            this.orphanedParts.clear();
        }
        this.worldObj = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onChunkLoaded(int chunkX, int chunkZ) {
        long chunkHash = ChunkCoordIntPair.chunkXZ2Int((int)chunkX, (int)chunkZ);
        if (this.partsAwaitingChunkLoad.containsKey(chunkHash)) {
            Object object = this.partsAwaitingChunkLoadMutex;
            synchronized (object) {
                if (this.partsAwaitingChunkLoad.containsKey(chunkHash)) {
                    this.addAllOrphanedPartsThreadsafe((Collection<? extends IMultiblockPart>)this.partsAwaitingChunkLoad.get(chunkHash));
                    this.partsAwaitingChunkLoad.remove(chunkHash);
                }
            }
        }
    }

    public void addDeadController(MultiblockControllerBase deadController) {
        this.deadControllers.add(deadController);
    }

    public void addDirtyController(MultiblockControllerBase dirtyController) {
        this.dirtyControllers.add(dirtyController);
    }

    public Set<MultiblockControllerBase> getControllers() {
        return Collections.unmodifiableSet(this.controllers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addOrphanedPartThreadsafe(IMultiblockPart part) {
        Object object = this.orphanedPartsMutex;
        synchronized (object) {
            this.orphanedParts.add(part);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addAllOrphanedPartsThreadsafe(Collection<? extends IMultiblockPart> parts) {
        Object object = this.orphanedPartsMutex;
        synchronized (object) {
            this.orphanedParts.addAll(parts);
        }
    }

    private String clientOrServer() {
        return this.worldObj.isRemote ? "CLIENT" : "SERVER";
    }
}

