/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gadgets;

import cofh.api.energy.IEnergyConnection;
import forestry.api.core.IErrorLogic;
import forestry.apiculture.network.PacketActiveUpdate;
import forestry.core.EnumErrorCode;
import forestry.core.TemperatureState;
import forestry.core.gadgets.TileBase;
import forestry.core.interfaces.IActivatable;
import forestry.core.network.DataInputStreamForestry;
import forestry.core.network.DataOutputStreamForestry;
import forestry.core.proxy.Proxies;
import forestry.core.utils.BlockUtil;
import forestry.energy.EnergyManager;
import java.io.IOException;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class Engine
extends TileBase
implements IEnergyConnection,
IActivatable {
    private boolean active = false;
    private int stagePiston = 0;
    private float pistonSpeedServer = 0.0f;
    protected int currentOutput = 0;
    protected int heat;
    protected final int maxHeat;
    protected boolean forceCooldown = false;
    public float progress;
    protected final EnergyManager energyManager;

    protected Engine(int maxHeat, int maxEnergy) {
        this.maxHeat = maxHeat;
        this.energyManager = new EnergyManager(2000, maxEnergy);
        this.energyManager.setReceiveOnly();
    }

    @Override
    public void rotateAfterPlacement(EntityLivingBase entityLiving) {
        this.rotateEngine();
    }

    protected void addHeat(int i) {
        this.heat += i;
        if (this.heat > this.maxHeat) {
            this.heat = this.maxHeat;
        }
    }

    protected abstract int dissipateHeat();

    protected abstract int generateHeat();

    protected boolean mayBurn() {
        return !this.forceCooldown;
    }

    protected abstract void burn();

    @Override
    public void updateClientSide() {
        if (this.stagePiston != 0) {
            this.progress += this.pistonSpeedServer;
            if (this.progress > 1.0f) {
                this.stagePiston = 0;
                this.progress = 0.0f;
            }
        } else if (this.active) {
            this.stagePiston = 1;
        }
    }

    @Override
    protected void updateServerSide() {
        TemperatureState energyState = this.getTemperatureState();
        if (energyState == TemperatureState.MELTING && this.heat > 0) {
            this.forceCooldown = true;
        } else if (this.forceCooldown && this.heat <= 0) {
            this.forceCooldown = false;
        }
        IErrorLogic errorLogic = this.getErrorLogic();
        errorLogic.setCondition(this.forceCooldown, EnumErrorCode.FORCEDCOOLDOWN);
        boolean enabledRedstone = this.isRedstoneActivated();
        errorLogic.setCondition(!enabledRedstone, EnumErrorCode.NOREDSTONE);
        TileEntity tile = this.worldObj.getTileEntity(this.xCoord + this.getOrientation().offsetX, this.yCoord + this.getOrientation().offsetY, this.zCoord + this.getOrientation().offsetZ);
        float newPistonSpeed = this.getPistonSpeed();
        if (newPistonSpeed != this.pistonSpeedServer) {
            this.pistonSpeedServer = newPistonSpeed;
            this.setNeedsNetworkUpdate();
        }
        if (this.stagePiston != 0) {
            this.progress += this.pistonSpeedServer;
            this.energyManager.sendEnergy(this.getOrientation(), tile);
            if ((double)this.progress > 0.25 && this.stagePiston == 1) {
                this.stagePiston = 2;
            } else if ((double)this.progress >= 0.5) {
                this.progress = 0.0f;
                this.stagePiston = 0;
            }
        } else if (enabledRedstone && BlockUtil.isEnergyReceiverOrEngine(this.getOrientation().getOpposite(), tile)) {
            if (this.energyManager.canSendEnergy(this.getOrientation(), tile)) {
                this.stagePiston = 1;
                this.setActive(true);
            } else {
                this.setActive(false);
            }
        } else {
            this.setActive(false);
        }
        this.dissipateHeat();
        this.generateHeat();
        if (this.mayBurn()) {
            this.burn();
        } else {
            this.energyManager.drainEnergy(20);
        }
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public void setActive(boolean active) {
        if (this.active == active) {
            return;
        }
        this.active = active;
        if (!this.worldObj.isRemote) {
            Proxies.net.sendNetworkPacket(new PacketActiveUpdate(this), this.worldObj);
        }
    }

    public void rotateEngine() {
        for (int i = this.getOrientation().ordinal() + 1; i <= this.getOrientation().ordinal() + 6; ++i) {
            ForgeDirection orient = ForgeDirection.values()[i % 6];
            TileEntity tile = this.worldObj.getTileEntity(this.xCoord + orient.offsetX, this.yCoord + orient.offsetY, this.zCoord + orient.offsetZ);
            if (!BlockUtil.isEnergyReceiverOrEngine(this.getOrientation().getOpposite(), tile)) continue;
            this.setOrientation(orient);
            this.worldObj.notifyBlocksOfNeighborChange(this.xCoord, this.yCoord, this.zCoord, this.worldObj.getBlock(this.xCoord, this.yCoord, this.zCoord));
            this.worldObj.func_147479_m(this.xCoord, this.yCoord, this.zCoord);
            break;
        }
    }

    protected double getHeatLevel() {
        return (double)this.heat / (double)this.maxHeat;
    }

    protected abstract boolean isBurning();

    public int getBurnTimeRemainingScaled(int i) {
        return 0;
    }

    public boolean hasFuelMin(float percentage) {
        return false;
    }

    public int getCurrentOutput() {
        if (this.isBurning() && this.isRedstoneActivated()) {
            return this.currentOutput;
        }
        return 0;
    }

    public int getHeat() {
        return this.heat;
    }

    public TemperatureState getTemperatureState() {
        return TemperatureState.getState(this.heat, this.maxHeat);
    }

    protected float getPistonSpeed() {
        switch (this.getTemperatureState()) {
            case COOL: {
                return 0.03f;
            }
            case WARMED_UP: {
                return 0.04f;
            }
            case OPERATING_TEMPERATURE: {
                return 0.05f;
            }
            case RUNNING_HOT: {
                return 0.06f;
            }
            case OVERHEATING: {
                return 0.07f;
            }
            case MELTING: {
                return 0.08f;
            }
        }
        return 0.0f;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        this.energyManager.readFromNBT(nbt);
        this.heat = nbt.getInteger("EngineHeat");
        this.progress = nbt.getFloat("EngineProgress");
        this.forceCooldown = nbt.getBoolean("ForceCooldown");
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        this.energyManager.writeToNBT(nbt);
        nbt.setInteger("EngineHeat", this.heat);
        nbt.setFloat("EngineProgress", this.progress);
        nbt.setBoolean("ForceCooldown", this.forceCooldown);
    }

    @Override
    public void writeData(DataOutputStreamForestry data) throws IOException {
        super.writeData(data);
        data.writeBoolean(this.active);
        data.writeInt(this.heat);
        data.writeFloat(this.pistonSpeedServer);
        this.energyManager.writeData(data);
    }

    @Override
    public void readData(DataInputStreamForestry data) throws IOException {
        super.readData(data);
        this.active = data.readBoolean();
        this.heat = data.readInt();
        this.pistonSpeedServer = data.readFloat();
        this.energyManager.readData(data);
    }

    public abstract void getGUINetworkData(int var1, int var2);

    public abstract void sendGUINetworkData(Container var1, ICrafting var2);

    @Override
    public boolean canConnectEnergy(ForgeDirection from) {
        return this.energyManager.canConnectEnergy(from);
    }

    public EnergyManager getEnergyManager() {
        return this.energyManager;
    }
}

