/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.config;

import forestry.Forestry;
import forestry.core.config.LocalizedConfiguration;
import forestry.core.config.deprecated.Configuration;
import forestry.core.config.deprecated.Property;
import forestry.core.fluids.Fluids;
import forestry.core.proxy.Proxies;
import forestry.core.utils.StringUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import net.minecraft.util.StatCollector;

public class Config {
    public static final String CATEGORY_COMMON = "common";
    public static final String CATEGORY_FLUIDS = "fluids";
    public static final String CATEGORY_DEBUG = "debug";
    public static Configuration configOld;
    public static LocalizedConfiguration configCommon;
    public static LocalizedConfiguration configFluid;
    public static String gameMode;
    private static final Set<String> disabledStructures;
    private static final Set<String> disabledFluids;
    private static final Set<String> disabledBlocks;
    public static boolean isDebug;
    public static boolean enablePermissions;
    public static boolean enableParticleFX;
    public static boolean clearInvalidChromosomes;
    public static boolean pollinateVanillaTrees;
    public static float researchMutationBoostMultiplier;
    public static float maxResearchMutationBoostPercent;
    public static boolean dungeonLootRare;
    public static boolean generateApatiteOre;
    public static boolean generateCopperOre;
    public static boolean generateTinOre;
    private static float generateBeehivesAmount;
    public static boolean generateBeehivesDebug;
    public static boolean enableVillagers;
    public static boolean doRetrogen;
    public static boolean forceRetrogen;
    public static boolean enableBackpackResupply;
    private static boolean craftingBronzeEnabled;
    public static boolean craftingStampsEnabled;
    public static final ArrayList<String> collectorStamps;
    public static int farmSize;
    public static boolean squareFarms;
    private static boolean enableExUtilEnderLily;
    private static boolean enableMagicalCropsSupport;
    public static boolean mailAlertEnabled;
    public static int guiTabSpeed;
    public static boolean enableHints;
    public static final Map<String, String[]> hints;
    public static boolean enableEnergyStat;

    public static boolean isStructureEnabled(String uid) {
        return !disabledStructures.contains(uid);
    }

    public static boolean isFluidEnabled(Fluids fluids) {
        return !disabledFluids.contains(fluids.getTag());
    }

    public static boolean isBlockEnabled(String tag) {
        return !disabledBlocks.contains(tag);
    }

    public static boolean isCraftingBronzeEnabled() {
        return craftingBronzeEnabled;
    }

    public static double getBeehivesAmount() {
        return generateBeehivesAmount;
    }

    public static boolean isExUtilEnderLilyEnabled() {
        return enableExUtilEnderLily;
    }

    public static boolean isMagicalCropsSupportEnabled() {
        return enableMagicalCropsSupport;
    }

    public static void load() {
        configOld = new Configuration();
        String oldConfigCommon = "common.conf";
        String newConfigCommon = "common.cfg";
        File newConfigCommonFile = new File(Forestry.instance.getConfigFolder(), "common.cfg");
        File oldConfigCommonFile = new File(Forestry.instance.getConfigFolder(), "common.conf");
        if (oldConfigCommonFile.exists()) {
            Config.loadOldConfigCommon();
            String oldConfigRenamed = "common.conf.old";
            File oldConfigFileRenamed = new File(Forestry.instance.getConfigFolder(), "common.conf.old");
            if (oldConfigCommonFile.renameTo(oldConfigFileRenamed)) {
                Proxies.log.info("Migrated common settings to the new file 'common.cfg' and renamed 'common.conf' to 'common.conf.old'.");
            }
        }
        Config.loadNewConfigCommon(newConfigCommonFile);
        String oldConfigFluids = "fluids.conf";
        String newConfigFluids = "fluids.cfg";
        File newConfigFluidsFile = new File(Forestry.instance.getConfigFolder(), "fluids.cfg");
        File oldConfigFluidsFile = new File(Forestry.instance.getConfigFolder(), "fluids.conf");
        if (oldConfigFluidsFile.exists()) {
            Config.loadOldConfigFluids();
            String oldConfigRenamed = "fluids.conf.old";
            File oldConfigFileRenamed = new File(Forestry.instance.getConfigFolder(), "fluids.conf.old");
            if (oldConfigFluidsFile.renameTo(oldConfigFileRenamed)) {
                Proxies.log.info("Migrated fluids settings to the new file 'fluids.cfg' and renamed 'fluids.conf' to 'fluids.conf.old'.");
            }
        }
        Config.loadNewConfigFluids(newConfigFluidsFile);
        String oldConfigDebug = "debug.conf";
        File oldConfigDebugFile = new File(Forestry.instance.getConfigFolder(), "debug.conf");
        if (oldConfigDebugFile.exists()) {
            String oldConfigRenamed = "debug.conf.old";
            File oldConfigFileRenamed = new File(Forestry.instance.getConfigFolder(), "debug.conf.old");
            if (oldConfigDebugFile.renameTo(oldConfigFileRenamed)) {
                Proxies.log.info("Renamed 'debug.conf' to 'debug.conf.old'.");
            }
        }
        Config.loadHints();
    }

    private static void loadNewConfigCommon(File configFileCommon) {
        configCommon = new LocalizedConfiguration(configFileCommon, "1.1.0");
        gameMode = configCommon.getStringLocalized("difficulty", "game.mode", "EASY", new String[]{"OP, EASY, NORMAL, HARD"});
        boolean recreate = configCommon.getBooleanLocalized("difficulty", "recreate.definitions", true);
        if (recreate) {
            Proxies.log.info("Recreating all gamemode definitions from the defaults. This may be caused by an upgrade");
            String recreateDefinitionsComment = StringUtil.localize("config.difficulty.recreate.definitions.comment");
            net.minecraftforge.common.config.Property property = configCommon.get("difficulty", "recreate.definitions", true, recreateDefinitionsComment);
            property.set(false);
            File opMode = new File(Forestry.instance.getConfigFolder(), "gamemodes/OP.cfg");
            Config.CopyFileToFS(opMode, "/config/forestry/gamemodes/OP.cfg");
            File normalMode = new File(Forestry.instance.getConfigFolder(), "gamemodes/NORMAL.cfg");
            Config.CopyFileToFS(normalMode, "/config/forestry/gamemodes/NORMAL.cfg");
            File hardMode = new File(Forestry.instance.getConfigFolder(), "gamemodes/HARD.cfg");
            Config.CopyFileToFS(hardMode, "/config/forestry/gamemodes/HARD.cfg");
        }
        enableParticleFX = configCommon.getBooleanLocalized("performance", "particleFX", enableParticleFX);
        doRetrogen = configCommon.getBooleanLocalized("world.generate.retrogen", "normal", doRetrogen);
        if (forceRetrogen = configCommon.getBooleanLocalized("world.generate.retrogen", "forced", forceRetrogen)) {
            net.minecraftforge.common.config.Property property = configCommon.get("world.generate.retrogen", "forced", false);
            property.set(false);
            Proxies.log.info("Enabled force retrogen.");
            doRetrogen = true;
        } else if (doRetrogen) {
            Proxies.log.info("Enabled retrogen.");
        }
        generateBeehivesAmount = configCommon.getFloatLocalized("world.generate.beehives", "amount", generateBeehivesAmount, 0.0f, 10.0f);
        generateBeehivesDebug = configCommon.getBooleanLocalized("world.generate.beehives", CATEGORY_DEBUG, generateBeehivesDebug);
        generateApatiteOre = configCommon.getBooleanLocalized("world.generate.ore", "apatite", generateApatiteOre);
        generateCopperOre = configCommon.getBooleanLocalized("world.generate.ore", "copper", generateCopperOre);
        generateTinOre = configCommon.getBooleanLocalized("world.generate.ore", "tin", generateTinOre);
        enableVillagers = configCommon.getBooleanLocalized("world.generate", "villagers", enableVillagers);
        craftingBronzeEnabled = configCommon.getBooleanLocalized("crafting", "bronze", craftingBronzeEnabled);
        craftingStampsEnabled = configCommon.getBooleanLocalized("crafting.stamps", "enabled", true);
        String[] allStamps = new String[]{"1n", "2n", "5n", "10n", "20n", "50n", "100n"};
        String[] defaultCollectors = new String[]{"20n", "50n", "100n"};
        String[] stamps = configCommon.getStringListLocalized("crafting.stamps", "disabled", defaultCollectors, allStamps);
        try {
            collectorStamps.addAll(Arrays.asList(stamps));
        }
        catch (Exception ex) {
            Proxies.log.warning("Failed to read config for 'crafting.stamps.disabled', setting to default.");
            net.minecraftforge.common.config.Property property = configCommon.get("crafting.stamps", "disabled", defaultCollectors);
            property.setToDefault();
            collectorStamps.addAll(Arrays.asList(defaultCollectors));
        }
        clearInvalidChromosomes = configCommon.getBooleanLocalized("genetics", "clear.invalid.chromosomes", clearInvalidChromosomes);
        pollinateVanillaTrees = configCommon.getBooleanLocalized("genetics", "pollinate.vanilla.trees", pollinateVanillaTrees);
        researchMutationBoostMultiplier = configCommon.getFloatLocalized("genetics.research.boost", "multiplier", researchMutationBoostMultiplier, 1.0f, 1000.0f);
        maxResearchMutationBoostPercent = configCommon.getFloatLocalized("genetics.research.boost", "max.percent", maxResearchMutationBoostPercent, 0.0f, 100.0f);
        dungeonLootRare = configCommon.getBooleanLocalized("difficulty", "loot.rare", dungeonLootRare);
        enableBackpackResupply = configCommon.getBooleanLocalized("performance", "backpacks.resupply", enableBackpackResupply);
        mailAlertEnabled = configCommon.getBooleanLocalized("tweaks.gui", "mail.alert", mailAlertEnabled);
        guiTabSpeed = configCommon.getIntLocalized("tweaks.gui.tabs", "speed", guiTabSpeed, 1, 50);
        enableHints = configCommon.getBooleanLocalized("tweaks.gui.tabs", "hints", enableHints);
        enableEnergyStat = configCommon.getBooleanLocalized("tweaks.gui.tabs", "energy", enableEnergyStat);
        enablePermissions = configCommon.getBooleanLocalized("tweaks", "permissions", enablePermissions);
        farmSize = configCommon.getIntLocalized("tweaks.farms", "size", farmSize, 1, 3);
        squareFarms = configCommon.getBooleanLocalized("tweaks.farms", "square", squareFarms);
        enableExUtilEnderLily = configCommon.getBooleanLocalized("tweaks.farms", "enderlily", enableExUtilEnderLily);
        enableMagicalCropsSupport = configCommon.getBooleanLocalized("tweaks.farms", "magicalcrops", enableMagicalCropsSupport);
        String[] availableStructures = new String[]{"alveary3x3", "farm3x3", "farm3x4", "farm3x5", "farm4x4", "farm5x5"};
        String[] disabledStructureArray = disabledStructures.toArray(new String[disabledStructures.size()]);
        disabledStructureArray = configCommon.getStringListLocalized("structures", "disabled", disabledStructureArray, availableStructures);
        disabledStructures.addAll(Arrays.asList(disabledStructureArray));
        for (String str : disabledStructures) {
            Proxies.log.finer("Disabled structure '%s'.", (Object)str);
        }
        isDebug = configCommon.getBooleanLocalized(CATEGORY_DEBUG, "enabled", isDebug);
        configCommon.save();
    }

    private static void loadOldConfigCommon() {
        Property property = configOld.get("difficulty.gamemode", CATEGORY_COMMON, "EASY");
        property.comment = "set to your preferred game mode. available modes are OP, EASY, NORMAL, HARD. mismatch with the server may cause visual glitches with recipes. setting an unavailable mode will create a new mode definition file.";
        gameMode = property.value;
        property = configOld.get("performance.particleFX.enabled", CATEGORY_COMMON, true);
        property.comment = "set to false to disable particle fx on slower machines";
        enableParticleFX = Boolean.parseBoolean(property.value);
        String retroGenMessage = "Forestry will attempt worldGen in chunks that were created before the mod was added.";
        property = configOld.get("world.retrogen.normal", CATEGORY_COMMON, false);
        property.comment = "Set to true, " + retroGenMessage;
        doRetrogen = Boolean.parseBoolean(property.value);
        String forcedRetroGenMessage = "Forestry will attempt worldGen in all chunks for this game instance. Config option will be set to false after this run.";
        String forcedRetroGenKey = "world.retrogen.forced";
        property = configOld.get(forcedRetroGenKey, CATEGORY_COMMON, false);
        property.comment = "Set to true, " + forcedRetroGenMessage;
        forceRetrogen = Boolean.parseBoolean(property.value);
        if (forceRetrogen) {
            Proxies.log.info(forcedRetroGenMessage);
            configOld.set(forcedRetroGenKey, CATEGORY_COMMON, false);
            doRetrogen = true;
        } else if (doRetrogen) {
            Proxies.log.info(retroGenMessage);
        }
        property = configOld.get("world.generate.apatite", CATEGORY_COMMON, true);
        property.comment = "set to false to force forestry to skip generating own apatite ore blocks in the world";
        generateApatiteOre = Boolean.parseBoolean(property.value);
        property = configOld.get("world.generate.beehives.rate", CATEGORY_COMMON, generateBeehivesAmount);
        property.comment = "set how many beehives spawn. Default is 1.0, double is 2.0, half is 0.5 etc.";
        generateBeehivesAmount = Float.parseFloat(property.value);
        property = configOld.get("world.generate.beehives", CATEGORY_COMMON, true);
        property.comment = "set to false to force forestry to skip generating beehives in the world";
        boolean generateBeehives = Boolean.parseBoolean(property.value);
        if (!generateBeehives) {
            generateBeehivesAmount = 0.0f;
        }
        property = configOld.get("world.generate.beehives.debug", CATEGORY_DEBUG, false);
        property.comment = "Set to true to force Forestry to try to generate a beehive at every possible location.";
        generateBeehivesDebug = Boolean.parseBoolean(property.value);
        property = configOld.get("world.generate.copper", CATEGORY_COMMON, true);
        property.comment = "set to false to force forestry to skip generating own copper ore blocks in the world";
        generateCopperOre = Boolean.parseBoolean(property.value);
        property = configOld.get("world.generate.tin", CATEGORY_COMMON, true);
        property.comment = "set to false to force forestry to skip generating own tin ore blocks in the world";
        generateTinOre = Boolean.parseBoolean(property.value);
        property = configOld.get("world.generate.villager", CATEGORY_COMMON, true);
        property.comment = "set to false to disable the creation of forestry villagers and their houses";
        enableVillagers = Boolean.parseBoolean(property.value);
        property = configOld.get("crafting.bronze.enabled", CATEGORY_COMMON, true);
        property.comment = "set to false to disable crafting recipe for bronze";
        craftingBronzeEnabled = Boolean.parseBoolean(property.value);
        property = configOld.get("crafting.stamps.enabled", CATEGORY_COMMON, true);
        property.comment = "set to false to disable crafting recipes for all types of stamps.";
        craftingStampsEnabled = Boolean.parseBoolean(property.value);
        String defaultCollectors = "20n;50n;100n;200n";
        property = configOld.get("crafting.stamps.collector", CATEGORY_COMMON, defaultCollectors);
        property.comment = "if crafting of stamps is generally allowed, these stamps are still excluded from crafting.";
        try {
            collectorStamps.addAll(Arrays.asList(Config.parseStamps(property.value)));
        }
        catch (Exception ex) {
            configOld.set("crafting.stamps.collector", CATEGORY_COMMON, defaultCollectors);
            collectorStamps.addAll(Arrays.asList(Config.parseStamps(defaultCollectors)));
        }
        property = configOld.get("tweaks.mailalert.enabled", CATEGORY_COMMON, true);
        property.comment = "set to false to disable the mail alert box";
        mailAlertEnabled = Boolean.parseBoolean(property.value);
        property = configOld.get("tweaks.gui.tab.speed", CATEGORY_COMMON, guiTabSpeed);
        property.comment = "set the speed at which the gui side tabs open and close.";
        guiTabSpeed = Integer.parseInt(property.value);
        property = configOld.get("genetics.clear.invalid.chromosomes", CATEGORY_COMMON, clearInvalidChromosomes);
        property.comment = "set to true to clear chromosomes which contain invalid alleles. might rescue your save if it is crashing after the removal of a bee addon.";
        clearInvalidChromosomes = Boolean.parseBoolean(property.value);
        property = configOld.get("difficulty.dungeonloot.rare", CATEGORY_COMMON, false);
        property.comment = "set to true to make dungeon loot generated by forestry rarer";
        dungeonLootRare = Boolean.parseBoolean(property.value);
        property = configOld.get("performance.backpacks.resupply", CATEGORY_COMMON, true);
        property.comment = "leaving this enabled will cycle the list of active players PER INGAME TICK to check for resupply via backpack. you want to set this to false on busy servers.";
        enableBackpackResupply = Boolean.parseBoolean(property.value);
        property = configOld.get("tweaks.hints.disabled", CATEGORY_COMMON, false);
        property.comment = "set to true to disable hints on machine and engine guis.";
        enableHints = !Boolean.parseBoolean(property.value);
        property = configOld.get("tweaks.energystat.disabled", CATEGORY_COMMON, true);
        property.comment = "set to true to disable energy statistics on energy consumers.";
        enableEnergyStat = !Boolean.parseBoolean(property.value);
        property = configOld.get("tweaks.permissions.disabled", CATEGORY_COMMON, false);
        property.comment = "set to true to disable access restrictions on forestry machines.";
        enablePermissions = !Boolean.parseBoolean(property.value);
        property = configOld.get("tweaks.farms.squared", CATEGORY_COMMON, false);
        property.comment = "set to true to have farms use a square layout instead of a diamond one.";
        squareFarms = Boolean.parseBoolean(property.value);
        property = configOld.get("tweaks.farms.exutilenderlily", CATEGORY_COMMON, true);
        property.comment = "set to false to disable multifarm support for ExtraUtilities Ender-lily seeds.";
        enableExUtilEnderLily = Boolean.parseBoolean(property.value);
        property = configOld.get("tweaks.farms.magicalcropssupport", CATEGORY_COMMON, true);
        property.comment = "set to false to disable multifarm support for Magical Crops crops.";
        enableMagicalCropsSupport = Boolean.parseBoolean(property.value);
        property = configOld.get("structures.schemata.disabled", CATEGORY_COMMON, "");
        property.comment = "add schemata keys to disable them. current keys: alveary3x3;farm3x3;farm3x4;farm3x5;farm4x4;farm5x5";
        disabledStructures.addAll(Arrays.asList(Config.parseStructureKeys(property.value)));
        for (String str : disabledStructures) {
            Proxies.log.finer("Disabled structure '%s'.", (Object)str);
        }
    }

    private static void loadNewConfigFluids(File configFile) {
        configFluid = new LocalizedConfiguration(configFile, "1.0.0");
        for (Fluids fluid : Fluids.forestryFluids) {
            String fluidName = StatCollector.translateToLocal((String)("fluid." + fluid.getTag()));
            boolean enabledFluid = !disabledFluids.contains(fluid.getTag());
            String enableFluidComment = StringUtil.localizeAndFormatRaw("for.config.fluids.enable.format", fluidName);
            enabledFluid = configFluid.getBoolean("enableFluid", fluid.getTag(), enabledFluid, enableFluidComment);
            if (!enabledFluid) {
                disabledFluids.add(fluid.getTag());
            }
            boolean enabledFluidBlock = !disabledBlocks.contains(fluid.getTag());
            String enableFluidBlockComment = StringUtil.localizeAndFormatRaw("for.config.fluid.blocks.enable.format", fluidName);
            enabledFluidBlock = configFluid.getBoolean("enableFluidBlock", fluid.getTag(), enabledFluidBlock, enableFluidBlockComment);
            if (enabledFluidBlock) continue;
            disabledBlocks.add(fluid.getTag());
        }
        configFluid.save();
    }

    private static void loadOldConfigFluids() {
        for (Fluids fluid : Fluids.forestryFluids) {
            Property property = configOld.get("disable.fluid." + fluid.getTag(), CATEGORY_FLUIDS, false);
            property.comment = "set to true to disable the fluid for " + fluid.getTag();
            if (Boolean.parseBoolean(property.value)) {
                disabledFluids.add(fluid.getTag());
            }
            property = configOld.get("disable.fluidBlock." + fluid.getTag(), CATEGORY_FLUIDS, false);
            property.comment = "set to true to disable the in-world FluidBlock for " + fluid.getTag();
            if (!Boolean.parseBoolean(property.value)) continue;
            disabledBlocks.add(fluid.getTag());
        }
    }

    private static void CopyFileToFS(File destination, String resourcePath) {
        InputStream stream = Config.class.getResourceAsStream(resourcePath);
        byte[] buffer = new byte[4096];
        try {
            int readBytes;
            if (destination.getParentFile() != null) {
                destination.getParentFile().mkdirs();
            }
            if (!destination.exists() && !destination.createNewFile()) {
                return;
            }
            FileOutputStream outstream = new FileOutputStream(destination);
            while ((readBytes = stream.read(buffer)) > 0) {
                ((OutputStream)outstream).write(buffer, 0, readBytes);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static void loadHints() {
        Properties prop = new Properties();
        try {
            InputStream hintStream = Config.class.getResourceAsStream("/config/forestry/hints.properties");
            prop.load(hintStream);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        for (String key : prop.stringPropertyNames()) {
            hints.put(key, Config.parseHints(prop.getProperty(key)));
        }
    }

    private static String[] parseHints(String list) {
        if (list.isEmpty()) {
            return new String[0];
        }
        return list.split("[;]+");
    }

    private static String[] parseStructureKeys(String list) {
        if (list.isEmpty()) {
            return new String[0];
        }
        return list.split("[;]+");
    }

    private static String[] parseStamps(String list) {
        if (list.isEmpty()) {
            return new String[0];
        }
        return list.split("[;]+");
    }

    static {
        disabledStructures = new HashSet<String>();
        disabledFluids = new HashSet<String>();
        disabledBlocks = new HashSet<String>();
        isDebug = false;
        enablePermissions = true;
        enableParticleFX = true;
        clearInvalidChromosomes = false;
        pollinateVanillaTrees = true;
        researchMutationBoostMultiplier = 1.5f;
        maxResearchMutationBoostPercent = 5.0f;
        dungeonLootRare = false;
        generateApatiteOre = true;
        generateCopperOre = true;
        generateTinOre = true;
        generateBeehivesAmount = 1.0f;
        generateBeehivesDebug = false;
        enableVillagers = true;
        doRetrogen = false;
        forceRetrogen = false;
        enableBackpackResupply = true;
        craftingBronzeEnabled = true;
        craftingStampsEnabled = true;
        collectorStamps = new ArrayList();
        farmSize = 2;
        squareFarms = false;
        enableExUtilEnderLily = true;
        enableMagicalCropsSupport = true;
        mailAlertEnabled = true;
        guiTabSpeed = 8;
        enableHints = true;
        hints = new HashMap<String, String[]>();
        enableEnergyStat = true;
    }
}

