/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.circuits;

import com.google.common.collect.ImmutableSet;
import forestry.api.circuits.ChipsetManager;
import forestry.api.circuits.ICircuit;
import forestry.api.circuits.ICircuitLayout;
import forestry.api.circuits.ISolderManager;
import forestry.api.core.ForestryAPI;
import forestry.api.core.IErrorSource;
import forestry.api.core.IErrorState;
import forestry.core.EnumErrorCode;
import forestry.core.circuits.CircuitRegistry;
import forestry.core.circuits.EnumCircuitBoardType;
import forestry.core.circuits.ISolderingIron;
import forestry.core.circuits.ItemCircuitBoard;
import forestry.core.inventory.ItemInventory;
import forestry.core.items.ItemForestry;
import forestry.core.network.GuiId;
import forestry.core.proxy.Proxies;
import forestry.core.utils.RevolvingList;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class ItemSolderingIron
extends ItemForestry
implements ISolderingIron {
    public ItemSolderingIron() {
        this.setMaxStackSize(1);
        this.setMaxDamage(5);
    }

    public boolean isFull3D() {
        return true;
    }

    public ItemStack onItemRightClick(ItemStack itemstack, World world, EntityPlayer entityplayer) {
        if (Proxies.common.isSimulating(world)) {
            entityplayer.openGui(ForestryAPI.instance, GuiId.SolderingIronGUI.ordinal(), world, (int)entityplayer.posX, (int)entityplayer.posY, (int)entityplayer.posZ);
        }
        return itemstack;
    }

    public static class SolderingInventory
    extends ItemInventory
    implements IErrorSource {
        private final RevolvingList<ICircuitLayout> layouts = new RevolvingList<ICircuitLayout>(ChipsetManager.circuitRegistry.getRegisteredLayouts().values());
        private static final short blankSlot = 0;
        private static final short finishedSlot = 1;
        private static final short ingredientSlot1 = 2;
        private static final short ingredientSlotCount = 4;

        public SolderingInventory(EntityPlayer player, ItemStack itemStack) {
            super(player, 6, itemStack);
            this.layouts.setCurrent(ChipsetManager.circuitRegistry.getDefaultLayout());
        }

        @Override
        public int getInventoryStackLimit() {
            return 1;
        }

        public ICircuitLayout getLayout() {
            return this.layouts.getCurrent();
        }

        public void setLayout(String uid) {
            this.layouts.setCurrent(ChipsetManager.circuitRegistry.getLayout(uid));
        }

        public void advanceLayout() {
            this.layouts.rotateRight();
        }

        public void regressLayout() {
            this.layouts.rotateLeft();
        }

        private Collection<ICircuit> getCircuits(EnumCircuitBoardType type, boolean doConsume) {
            ArrayList<ICircuit> circuits = new ArrayList<ICircuit>();
            for (short i = 0; i < type.sockets; i = (short)(i + 1)) {
                CircuitRecipe recipe;
                ItemStack ingredient = this.getStackInSlot(2 + i);
                if (ingredient == null || (recipe = SolderManager.getMatchingRecipe(this.layouts.getCurrent(), ingredient)) == null || SolderingInventory.getCount(recipe.circuit, circuits) >= recipe.circuit.getLimit()) continue;
                if (doConsume) {
                    this.decrStackSize(2 + i, ((CircuitRecipe)recipe).resource.stackSize);
                }
                circuits.add(recipe.circuit);
            }
            return circuits;
        }

        @Override
        public void onSlotClick(EntityPlayer player) {
            if (this.layouts.getCurrent() == CircuitRegistry.DUMMY_LAYOUT) {
                return;
            }
            ItemStack blank = this.getStackInSlot(0);
            if (blank == null) {
                return;
            }
            if (blank.stackSize > 1) {
                return;
            }
            if (this.getStackInSlot(1) != null) {
                return;
            }
            if (!ChipsetManager.circuitRegistry.isChipset(blank)) {
                return;
            }
            if (blank.getItemDamage() < 0 || blank.getItemDamage() >= EnumCircuitBoardType.values().length) {
                return;
            }
            EnumCircuitBoardType type = EnumCircuitBoardType.values()[blank.getItemDamage()];
            Collection<ICircuit> circuits = this.getCircuits(type, false);
            if (circuits.size() != type.sockets) {
                return;
            }
            circuits = this.getCircuits(type, true);
            ICircuit[] circuitsArray = circuits.toArray(new ICircuit[circuits.size()]);
            ItemStack circuitBoard = ItemCircuitBoard.createCircuitboard(type, this.layouts.getCurrent(), circuitsArray);
            this.setInventorySlotContents(1, circuitBoard);
            this.setInventorySlotContents(0, null);
        }

        public static int getCount(ICircuit circuit, ArrayList<ICircuit> circuits) {
            int count = 0;
            for (ICircuit other : circuits) {
                if (!other.getUID().equals(circuit.getUID())) continue;
                ++count;
            }
            return count;
        }

        @Override
        public ImmutableSet<IErrorState> getErrorStates() {
            ItemStack blankCircuitBoard;
            ImmutableSet.Builder errorStates = ImmutableSet.builder();
            if (this.layouts.getCurrent() == CircuitRegistry.DUMMY_LAYOUT) {
                errorStates.add((Object)EnumErrorCode.NOCIRCUITLAYOUT);
            }
            if ((blankCircuitBoard = this.getStackInSlot(0)) == null) {
                errorStates.add((Object)EnumErrorCode.NOCIRCUITBOARD);
            } else {
                EnumCircuitBoardType type = EnumCircuitBoardType.values()[blankCircuitBoard.getItemDamage()];
                int circuitCount = 0;
                for (short i = 0; i < type.sockets; i = (short)(i + 1)) {
                    if (this.getStackInSlot(2 + i) == null) continue;
                    ++circuitCount;
                }
                if (circuitCount != type.sockets) {
                    errorStates.add((Object)EnumErrorCode.CIRCUITMISMATCH);
                } else {
                    Collection<ICircuit> circuits = this.getCircuits(type, false);
                    if (circuits.size() != type.sockets) {
                        errorStates.add((Object)EnumErrorCode.NOCIRCUITLAYOUT);
                    }
                }
            }
            return errorStates.build();
        }

        @Override
        public boolean canSlotAccept(int slotIndex, ItemStack itemStack) {
            if (itemStack == null) {
                return false;
            }
            Item item = itemStack.getItem();
            if (slotIndex == 0) {
                return item instanceof ItemCircuitBoard;
            }
            if (slotIndex >= 2 && slotIndex < 6) {
                CircuitRecipe recipe = SolderManager.getMatchingRecipe(this.layouts.getCurrent(), itemStack);
                return recipe != null;
            }
            return false;
        }
    }

    public static class SolderManager
    implements ISolderManager {
        public static final ArrayList<CircuitRecipe> recipes = new ArrayList();

        @Override
        public void addRecipe(ICircuitLayout layout, ItemStack resource, ICircuit circuit) {
            if (layout == null) {
                throw new IllegalArgumentException("layout may not be null");
            }
            if (resource == null) {
                throw new IllegalArgumentException("resource may not be null");
            }
            if (circuit == null) {
                throw new IllegalArgumentException("circuit may not be null");
            }
            recipes.add(new CircuitRecipe(layout, resource, circuit));
        }

        public static ICircuit getCircuit(ICircuitLayout layout, ItemStack resource) {
            CircuitRecipe circuitRecipe = SolderManager.getMatchingRecipe(layout, resource);
            if (circuitRecipe == null) {
                return null;
            }
            return circuitRecipe.circuit;
        }

        public static CircuitRecipe getMatchingRecipe(ICircuitLayout layout, ItemStack resource) {
            if (layout == null || resource == null) {
                return null;
            }
            for (CircuitRecipe recipe : recipes) {
                if (!recipe.matches(layout, resource)) continue;
                return recipe;
            }
            return null;
        }
    }

    public static class CircuitRecipe {
        private final ICircuitLayout layout;
        private final ItemStack resource;
        public final ICircuit circuit;

        public CircuitRecipe(ICircuitLayout layout, ItemStack resource, ICircuit circuit) {
            this.resource = resource;
            this.layout = layout;
            this.circuit = circuit;
        }

        public boolean matches(ICircuitLayout layout, ItemStack itemstack) {
            if (!this.layout.getUID().equals(layout.getUID())) {
                return false;
            }
            return itemstack.isItemEqual(this.resource);
        }
    }
}

