/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.genetics;

import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.genetics.IEffectData;
import forestry.apiculture.genetics.AlleleEffectThrottled;
import forestry.apiculture.items.ItemArmorApiarist;
import forestry.core.utils.DamageSourceForestry;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;

public class AlleleEffectMisanthrope
extends AlleleEffectThrottled {
    private static final DamageSource damageSourceBeeEnd = new DamageSourceForestry("bee.end");

    public AlleleEffectMisanthrope() {
        super("misanthrope", true, 20, false, false);
    }

    @Override
    public IEffectData doEffectThrottled(IBeeGenome genome, IEffectData storedData, IBeeHousing housing) {
        AxisAlignedBB beatifyBox = this.getBounding(genome, housing);
        List list = housing.getWorld().getEntitiesWithinAABB(EntityPlayer.class, beatifyBox);
        for (Object obj : list) {
            EntityPlayer player = (EntityPlayer)obj;
            int damage = 4;
            int count = ItemArmorApiarist.wearsItems(player, this.getUID(), true);
            if (count > 3) continue;
            if (count > 2) {
                damage = 1;
            } else if (count > 1) {
                damage = 2;
            } else if (count > 0) {
                damage = 3;
            }
            player.attackEntityFrom(damageSourceBeeEnd, (float)damage);
        }
        return storedData;
    }
}

