/*
 * Decompiled with CFR 0.152.
 */
package forestry.pipes;

import buildcraft.api.core.IIconProvider;
import buildcraft.transport.BlockGenericPipe;
import buildcraft.transport.Pipe;
import buildcraft.transport.PipeTransport;
import buildcraft.transport.PipeTransportItems;
import buildcraft.transport.pipes.events.PipeEventItem;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.IBee;
import forestry.api.core.ForestryAPI;
import forestry.api.genetics.IAllele;
import forestry.core.network.GuiId;
import forestry.core.proxy.Proxies;
import forestry.pipes.EnumFilterType;
import forestry.pipes.PipeIconProvider;
import forestry.pipes.PipeLogicPropolis;
import java.util.ArrayList;
import java.util.LinkedList;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

public class PipeItemsPropolis
extends Pipe<PipeTransportItems> {
    public final PipeLogicPropolis pipeLogic = new PipeLogicPropolis(this);
    IIconProvider provider;

    public PipeItemsPropolis(Item item) {
        super((PipeTransport)new PipeTransportItems(), item);
        ((PipeTransportItems)this.transport).allowBouncing = true;
    }

    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        this.pipeLogic.readFromNBT(nbt);
    }

    public void writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        this.pipeLogic.writeToNBT(nbt);
    }

    @SideOnly(value=Side.CLIENT)
    public IIconProvider getIconProvider() {
        if (this.provider == null) {
            this.provider = new PipeIconProvider();
        }
        return this.provider;
    }

    public int getIconIndex(ForgeDirection direction) {
        if (direction == ForgeDirection.UNKNOWN) {
            return 0;
        }
        return direction.ordinal() + 1;
    }

    public boolean blockActivated(EntityPlayer player) {
        if (!Proxies.common.isSimulating(this.getWorld())) {
            return true;
        }
        if (player.getCurrentEquippedItem() != null && player.getCurrentEquippedItem().getItem() != null && Block.getBlockFromItem((Item)player.getCurrentEquippedItem().getItem()) instanceof BlockGenericPipe) {
            return false;
        }
        player.openGui(ForestryAPI.instance, GuiId.PropolisPipeGUI.ordinal(), player.worldObj, this.container.xCoord, this.container.yCoord, this.container.zCoord);
        return true;
    }

    public void eventHandler(PipeEventItem.FindDest event) {
        LinkedList<ForgeDirection> filteredOrientations = new LinkedList<ForgeDirection>();
        LinkedList<ForgeDirection> typedOrientations = new LinkedList<ForgeDirection>();
        LinkedList<ForgeDirection> defaultOrientations = new LinkedList<ForgeDirection>();
        EnumFilterType type = EnumFilterType.getType(event.item.getItemStack());
        IBee bee = null;
        if (type != EnumFilterType.ITEM) {
            bee = BeeManager.beeRoot.getMember(event.item.getItemStack());
        }
        for (ForgeDirection dir : event.destinations) {
            if (this.pipeLogic.isClosed(dir)) continue;
            if (this.pipeLogic.isIndiscriminate(dir)) {
                defaultOrientations.add(dir);
                continue;
            }
            if (!this.pipeLogic.matchType(dir, type, bee)) continue;
            if (type == EnumFilterType.ITEM) {
                filteredOrientations.add(dir);
                continue;
            }
            ArrayList<IAllele[]> filters = this.pipeLogic.getGenomeFilters(dir);
            if (filters.size() <= 0) {
                typedOrientations.add(dir);
                continue;
            }
            for (IAllele[] pattern : filters) {
                if (!PipeItemsPropolis.matchAllele(pattern[0], bee.getIdent()) || !PipeItemsPropolis.matchAllele(pattern[1], bee.getGenome().getSecondary().getUID())) continue;
                filteredOrientations.add(dir);
            }
        }
        event.destinations.clear();
        if (filteredOrientations.size() > 0) {
            event.destinations.addAll(filteredOrientations);
        } else if (typedOrientations.size() > 0) {
            event.destinations.addAll(typedOrientations);
        } else {
            event.destinations.addAll(defaultOrientations);
        }
    }

    private static boolean matchAllele(IAllele filter, String ident) {
        if (filter == null) {
            return true;
        }
        return filter.getUID().equals(ident);
    }

    public void eventHandler(PipeEventItem.Entered event) {
        try {
            event.item.setSpeed(0.19999999f);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void eventHandler(PipeEventItem.AdjustSpeed event) {
        ((PipeTransportItems)this.transport).defaultReajustSpeed(event.item);
    }
}

