/*
 * Decompiled with CFR 0.152.
 */
package forestry.mail.gadgets;

import forestry.api.core.ForestryAPI;
import forestry.api.mail.IStamps;
import forestry.api.mail.PostManager;
import forestry.core.gadgets.TileBase;
import forestry.core.inventory.IInventoryAdapter;
import forestry.core.inventory.TileInventoryAdapter;
import forestry.core.network.GuiId;
import forestry.core.utils.StackUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;

public class MachinePhilatelist
extends TileBase
implements IInventory {
    public static final short SLOT_FILTER = 0;
    public static final short SLOT_BUFFER_1 = 1;
    public static final short SLOT_BUFFER_COUNT = 27;

    public MachinePhilatelist() {
        this.setInternalInventory(new PhilatelistInventoryAdapter(this));
    }

    @Override
    public void openGui(EntityPlayer player) {
        player.openGui(ForestryAPI.instance, GuiId.PhilatelistGUI.ordinal(), this.worldObj, this.xCoord, this.yCoord, this.zCoord);
    }

    @Override
    public void updateServerSide() {
        if (!this.updateOnInterval(20)) {
            return;
        }
        ItemStack stamp = null;
        IInventoryAdapter inventory = this.getInternalInventory();
        if (inventory.getStackInSlot(0) == null) {
            stamp = PostManager.postRegistry.getPostOffice(this.worldObj).getAnyStamp(1);
        } else {
            ItemStack filter = inventory.getStackInSlot(0);
            if (filter.getItem() instanceof IStamps) {
                stamp = PostManager.postRegistry.getPostOffice(this.worldObj).getAnyStamp(((IStamps)filter.getItem()).getPostage(filter), 1);
            }
        }
        if (stamp == null) {
            return;
        }
        StackUtils.stowInInventory(stamp, (IInventory)inventory, true, 1, 27);
    }

    private static class PhilatelistInventoryAdapter
    extends TileInventoryAdapter<MachinePhilatelist> {
        public PhilatelistInventoryAdapter(MachinePhilatelist tile) {
            super(tile, 28, "INV");
        }

        @Override
        public boolean canSlotAccept(int slotIndex, ItemStack itemStack) {
            return itemStack.getItem() instanceof IStamps;
        }
    }
}

