/*
 * Decompiled with CFR 0.152.
 */
package forestry.plugins;

import com.google.common.collect.ImmutableMap;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.registry.GameData;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.VillagerRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.Forestry;
import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.EnumBeeType;
import forestry.api.apiculture.FlowerManager;
import forestry.api.apiculture.IBeekeepingMode;
import forestry.api.apiculture.hives.HiveManager;
import forestry.api.core.Tabs;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IClassification;
import forestry.api.genetics.IFlower;
import forestry.api.genetics.IFlowerRegistry;
import forestry.api.recipes.RecipeManagers;
import forestry.api.storage.ICrateRegistry;
import forestry.api.storage.StorageManager;
import forestry.apiculture.GuiHandlerApiculture;
import forestry.apiculture.SaveEventHandlerApiculture;
import forestry.apiculture.VillageHandlerApiculture;
import forestry.apiculture.commands.CommandBee;
import forestry.apiculture.flowers.FlowerRegistry;
import forestry.apiculture.gadgets.BlockAlveary;
import forestry.apiculture.gadgets.BlockBeehives;
import forestry.apiculture.gadgets.BlockCandle;
import forestry.apiculture.gadgets.BlockStump;
import forestry.apiculture.gadgets.TileApiaristChest;
import forestry.apiculture.gadgets.TileApiary;
import forestry.apiculture.gadgets.TileBeehouse;
import forestry.apiculture.gadgets.TileCandle;
import forestry.apiculture.gadgets.TileSwarm;
import forestry.apiculture.genetics.AlleleEffectAggressive;
import forestry.apiculture.genetics.AlleleEffectCreeper;
import forestry.apiculture.genetics.AlleleEffectExploration;
import forestry.apiculture.genetics.AlleleEffectFertile;
import forestry.apiculture.genetics.AlleleEffectFungification;
import forestry.apiculture.genetics.AlleleEffectGlacial;
import forestry.apiculture.genetics.AlleleEffectHeroic;
import forestry.apiculture.genetics.AlleleEffectIgnition;
import forestry.apiculture.genetics.AlleleEffectMisanthrope;
import forestry.apiculture.genetics.AlleleEffectNone;
import forestry.apiculture.genetics.AlleleEffectPotion;
import forestry.apiculture.genetics.AlleleEffectRadioactive;
import forestry.apiculture.genetics.AlleleEffectRepulsion;
import forestry.apiculture.genetics.AlleleEffectResurrection;
import forestry.apiculture.genetics.AlleleEffectSnowing;
import forestry.apiculture.genetics.BeeBranchDefinition;
import forestry.apiculture.genetics.BeeDefinition;
import forestry.apiculture.genetics.BeeFactory;
import forestry.apiculture.genetics.BeeHelper;
import forestry.apiculture.genetics.BeeMutationFactory;
import forestry.apiculture.genetics.BeekeepingMode;
import forestry.apiculture.genetics.HiveDrop;
import forestry.apiculture.genetics.JubilanceFactory;
import forestry.apiculture.items.ItemAlvearyBlock;
import forestry.apiculture.items.ItemArmorApiarist;
import forestry.apiculture.items.ItemBeeGE;
import forestry.apiculture.items.ItemBeealyzer;
import forestry.apiculture.items.ItemCandleBlock;
import forestry.apiculture.items.ItemHabitatLocator;
import forestry.apiculture.items.ItemHiveFrame;
import forestry.apiculture.items.ItemHoneycomb;
import forestry.apiculture.items.ItemImprinter;
import forestry.apiculture.items.ItemWaxCast;
import forestry.apiculture.multiblock.TileAlvearyFan;
import forestry.apiculture.multiblock.TileAlvearyHeater;
import forestry.apiculture.multiblock.TileAlvearyHygroregulator;
import forestry.apiculture.multiblock.TileAlvearyPlain;
import forestry.apiculture.multiblock.TileAlvearySieve;
import forestry.apiculture.multiblock.TileAlvearyStabiliser;
import forestry.apiculture.multiblock.TileAlvearySwarmer;
import forestry.apiculture.network.PacketHandlerApiculture;
import forestry.apiculture.proxy.ProxyApiculture;
import forestry.apiculture.trigger.ApicultureTriggers;
import forestry.apiculture.worldgen.HiveDecorator;
import forestry.apiculture.worldgen.HiveDescription;
import forestry.apiculture.worldgen.HiveGenHelper;
import forestry.apiculture.worldgen.HiveRegistry;
import forestry.core.GameMode;
import forestry.core.config.Config;
import forestry.core.config.ForestryBlock;
import forestry.core.config.ForestryItem;
import forestry.core.config.LocalizedConfiguration;
import forestry.core.config.deprecated.Configuration;
import forestry.core.fluids.Fluids;
import forestry.core.gadgets.BlockBase;
import forestry.core.gadgets.MachineDefinition;
import forestry.core.gadgets.TileAnalyzer;
import forestry.core.genetics.alleles.Allele;
import forestry.core.interfaces.ISaveEventHandler;
import forestry.core.items.ItemForestry;
import forestry.core.items.ItemForestryBlock;
import forestry.core.items.ItemOverlay;
import forestry.core.items.ItemScoop;
import forestry.core.network.IPacketHandler;
import forestry.core.proxy.Proxies;
import forestry.core.render.EntitySnowFX;
import forestry.core.render.RenderNaturalistChest;
import forestry.core.utils.ShapedRecipeCustom;
import forestry.core.utils.StackUtils;
import forestry.core.utils.StringUtil;
import forestry.plugins.ForestryPlugin;
import forestry.plugins.Plugin;
import forestry.plugins.PluginCore;
import forestry.plugins.PluginManager;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.util.IIcon;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.ChestGenHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.oredict.OreDictionary;

@Plugin(pluginID="Apiculture", name="Apiculture", author="SirSengir", url="http://forestry.sengir.net/", unlocalizedDescription="for.plugin.apiculture.description")
public class PluginApiculture
extends ForestryPlugin {
    @SidedProxy(clientSide="forestry.apiculture.proxy.ClientProxyApiculture", serverSide="forestry.apiculture.proxy.ProxyApiculture")
    public static ProxyApiculture proxy;
    private static final String CONFIG_CATEGORY = "apiculture";
    private static final String[] EMPTY_STRINGS;
    public static String beekeepingMode;
    private static float secondPrincessChance;
    public static final int ticksPerBeeWorkCycle = 550;
    public static boolean fancyRenderedBees;
    public static HiveRegistry hiveRegistry;
    private static MachineDefinition definitionApiary;
    private static MachineDefinition definitionChest;
    private static MachineDefinition definitionBeehouse;
    private static MachineDefinition definitionAnalyzer;
    private final Map<String, String[]> defaultAcceptedFlowers = new HashMap<String, String[]>();
    private final Map<String, String[]> defaultPlantableFlowers = new HashMap<String, String[]>();

    @Override
    protected void setupAPI() {
        super.setupAPI();
        hiveRegistry = new HiveRegistry();
        HiveManager.hiveRegistry = hiveRegistry;
        HiveManager.genHelper = new HiveGenHelper();
        FlowerManager.flowerRegistry = new FlowerRegistry();
        BeeManager.villageBees = new ArrayList[]{new ArrayList(), new ArrayList()};
        BeeManager.beeFactory = new BeeFactory();
        BeeManager.beeMutationFactory = new BeeMutationFactory();
        BeeManager.jubilanceFactory = new JubilanceFactory();
        BeeManager.beeRoot = new BeeHelper();
        AlleleManager.alleleRegistry.registerSpeciesRoot(BeeManager.beeRoot);
        BeeManager.beeRoot.registerBeekeepingMode(BeekeepingMode.easy);
        BeeManager.beeRoot.registerBeekeepingMode(BeekeepingMode.normal);
        BeeManager.beeRoot.registerBeekeepingMode(BeekeepingMode.hard);
        BeeManager.beeRoot.registerBeekeepingMode(BeekeepingMode.hardcore);
        BeeManager.beeRoot.registerBeekeepingMode(BeekeepingMode.insane);
    }

    @Override
    public void preInit() {
        super.preInit();
        MinecraftForge.EVENT_BUS.register((Object)this);
        ForestryBlock.apiculture.registerBlock((Block)new BlockBase(Material.iron, true), ItemForestryBlock.class, CONFIG_CATEGORY);
        ForestryBlock.apiculture.block().setCreativeTab(Tabs.tabApiculture);
        ForestryBlock.apiculture.block().setHarvestLevel("axe", 0);
        definitionApiary = ((BlockBase)ForestryBlock.apiculture.block()).addDefinition(new MachineDefinition(0, "forestry.Apiary", TileApiary.class, ShapedRecipeCustom.createShapedRecipe(ForestryBlock.apiculture.getItemStack(1, 0), new Object[]{"XXX", "#C#", "###", Character.valueOf('X'), "slabWood", Character.valueOf('#'), "plankWood", Character.valueOf('C'), ForestryItem.impregnatedCasing})).setFaces(0, 1, 2, 2, 4, 4, 0, 7));
        definitionChest = ((BlockBase)ForestryBlock.apiculture.block()).addDefinition(new MachineDefinition(1, "forestry.ApiaristChest", TileApiaristChest.class, new RenderNaturalistChest("apiaristchest"), ShapedRecipeCustom.createShapedRecipe(ForestryBlock.apiculture.getItemStack(1, 1), " # ", "XYX", "XXX", Character.valueOf('#'), "blockGlass", Character.valueOf('X'), "beeComb", Character.valueOf('Y'), "chestWood")).setBoundingBox(0.0625f, 0.0f, 0.0625f, 0.9375f, 0.875f, 0.9375f));
        definitionBeehouse = ((BlockBase)ForestryBlock.apiculture.block()).addDefinition(new MachineDefinition(2, "forestry.Beehouse", TileBeehouse.class, ShapedRecipeCustom.createShapedRecipe(ForestryBlock.apiculture.getItemStack(1, 2), "XXX", "#C#", "###", Character.valueOf('X'), "slabWood", Character.valueOf('#'), "plankWood", Character.valueOf('C'), "beeComb")).setFaces(0, 1, 2, 2, 4, 4, 0, 7));
        definitionAnalyzer = ((BlockBase)ForestryBlock.core.block()).addDefinition(new MachineDefinition(0, "forestry.Analyzer", TileAnalyzer.class, proxy.getRendererAnalyzer("textures/blocks/analyzer_"), new IRecipe[0]));
        ForestryBlock.beehives.registerBlock((Block)new BlockBeehives(), ItemForestryBlock.class, "beehives");
        ForestryBlock.candle.registerBlock((Block)new BlockCandle(), ItemCandleBlock.class, "candle");
        ForestryBlock.stump.registerBlock((Block)new BlockStump(), ItemForestryBlock.class, "stump");
        ForestryBlock.alveary.registerBlock((Block)new BlockAlveary(), ItemAlvearyBlock.class, "alveary");
        ForestryBlock.alveary.block().setHarvestLevel("axe", 0);
        if (PluginManager.Module.BUILDCRAFT_STATEMENTS.isEnabled()) {
            ApicultureTriggers.initialize();
        }
        if (Config.enableVillagers) {
            VillageHandlerApiculture.registerVillageComponents();
        }
        PluginCore.rootCommand.addChildCommand(new CommandBee());
    }

    @Override
    public void doInit() {
        boolean deleted;
        LocalizedConfiguration config;
        File oldConfigFile;
        String oldConfig = "apiculture.conf";
        String newConfig = "apiculture.cfg";
        File configFile = new File(Forestry.instance.getConfigFolder(), "apiculture.cfg");
        if (!configFile.exists()) {
            this.setDefaultsForConfig();
        }
        if ((oldConfigFile = new File(Forestry.instance.getConfigFolder(), "apiculture.conf")).exists()) {
            PluginApiculture.loadOldConfig();
            String oldConfigRenamed = "apiculture.conf.old";
            File oldConfigFileRenamed = new File(Forestry.instance.getConfigFolder(), "apiculture.conf.old");
            if (oldConfigFile.renameTo(oldConfigFileRenamed)) {
                Proxies.log.info("Migrated apiculture settings to the new file 'apiculture.cfg' and renamed 'apiculture.conf' to 'apiculture.conf.old'.");
            }
        }
        if (!(config = new LocalizedConfiguration(configFile, "2.0.0")).getLoadedConfigVersion().equals(config.getDefinedConfigVersion()) && (deleted = configFile.delete())) {
            config = new LocalizedConfiguration(configFile, "2.0.0");
            this.setDefaultsForConfig();
        }
        ArrayList<IBeekeepingMode> beekeepingModes = BeeManager.beeRoot.getBeekeepingModes();
        String[] validBeekeepingModeNames = new String[beekeepingModes.size()];
        for (int i = 0; i < beekeepingModes.size(); ++i) {
            validBeekeepingModeNames[i] = ((IBeekeepingMode)beekeepingModes.get(i)).getName();
        }
        beekeepingMode = config.getStringLocalized("beekeeping", "mode", "NORMAL", validBeekeepingModeNames);
        Proxies.log.finer("Beekeeping mode read from config: " + beekeepingMode);
        secondPrincessChance = config.getFloatLocalized("beekeeping", "second.princess", secondPrincessChance, 0.0f, 100.0f);
        String acceptedFlowerMessage = StringUtil.localize("config.beekeeping.flowers.accepted.comment");
        String plantableFlowerMessage = StringUtil.localize("config.beekeeping.flowers.plantable.comment");
        for (String flowerType : FlowerManager.flowerRegistry.getFlowerTypes()) {
            String[] defaultAccepted = this.defaultAcceptedFlowers.get(flowerType);
            if (defaultAccepted == null) {
                defaultAccepted = EMPTY_STRINGS;
            }
            Property property = config.get("beekeeping.flowers." + flowerType, "accepted", defaultAccepted);
            property.comment = acceptedFlowerMessage;
            PluginApiculture.parseAcceptedFlowers(property.getStringList(), flowerType);
            String[] defaultPlantable = this.defaultPlantableFlowers.get(flowerType);
            if (defaultPlantable == null) {
                defaultPlantable = EMPTY_STRINGS;
            }
            property = config.get("beekeeping.flowers." + flowerType, "plantable", defaultPlantable);
            property.comment = plantableFlowerMessage;
            PluginApiculture.parsePlantableFlowers(property, flowerType);
            Set<IFlower> acceptableFlowers = FlowerManager.flowerRegistry.getAcceptableFlowers(flowerType);
            if (acceptableFlowers != null && acceptableFlowers.size() != 0) continue;
            Proxies.log.severe("Flower type '" + flowerType + "' has no valid flowers set in apiculture.cfg. Add valid flowers or delete the config to set it to default.");
        }
        String[] blacklist = config.getStringListLocalized("species", "blacklist", EMPTY_STRINGS);
        PluginApiculture.parseBeeBlacklist(blacklist);
        config.save();
        PluginApiculture.createAlleles();
        BeeDefinition.initBees();
        AlleleManager.alleleRegistry.registerDeprecatedAlleleReplacement("forestry.speciesArgrarian", BeeDefinition.AGRARIAN.getGenome().getPrimary());
        PluginApiculture.createHives();
        PluginApiculture.registerBeehiveDrops();
        BeeManager.inducers.put(ForestryItem.royalJelly.getItemStack(), 10);
        GameRegistry.registerTileEntity(TileAlvearyPlain.class, (String)"forestry.Alveary");
        GameRegistry.registerTileEntity(TileSwarm.class, (String)"forestry.Swarm");
        GameRegistry.registerTileEntity(TileAlvearySwarmer.class, (String)"forestry.AlvearySwarmer");
        GameRegistry.registerTileEntity(TileAlvearyHeater.class, (String)"forestry.AlvearyHeater");
        GameRegistry.registerTileEntity(TileAlvearyFan.class, (String)"forestry.AlvearyFan");
        GameRegistry.registerTileEntity(TileAlvearyHygroregulator.class, (String)"forestry.AlvearyHygro");
        GameRegistry.registerTileEntity(TileAlvearyStabiliser.class, (String)"forestry.AlvearyStabiliser");
        GameRegistry.registerTileEntity(TileAlvearySieve.class, (String)"forestry.AlvearySieve");
        GameRegistry.registerTileEntity(TileCandle.class, (String)"forestry.Candle");
        BeeManager.villageBees[0].add(BeeDefinition.FOREST.getGenome());
        BeeManager.villageBees[0].add(BeeDefinition.MEADOWS.getGenome());
        BeeManager.villageBees[0].add(BeeDefinition.MODEST.getGenome());
        BeeManager.villageBees[0].add(BeeDefinition.MARSHY.getGenome());
        BeeManager.villageBees[0].add(BeeDefinition.WINTRY.getGenome());
        BeeManager.villageBees[0].add(BeeDefinition.TROPICAL.getGenome());
        BeeManager.villageBees[1].add(BeeDefinition.FOREST.getRainResist().getGenome());
        BeeManager.villageBees[1].add(BeeDefinition.COMMON.getGenome());
        BeeManager.villageBees[1].add(BeeDefinition.VALIANT.getGenome());
        if (Config.enableVillagers) {
            VillageHandlerApiculture villageHandler = new VillageHandlerApiculture();
            VillagerRegistry.instance().registerVillageCreationHandler((VillagerRegistry.IVillageCreationHandler)villageHandler);
            VillagerRegistry.instance().registerVillagerId(80);
            Proxies.render.registerVillagerSkin(80, "textures/entity/beekeeper.png");
            VillagerRegistry.instance().registerVillageTradeHandler(80, (VillagerRegistry.IVillageTradeHandler)villageHandler);
        }
        proxy.initializeRendering();
    }

    @Override
    public void postInit() {
        super.postInit();
        PluginApiculture.registerDungeonLoot();
    }

    private void setDefaultsForConfig() {
        IFlowerRegistry flowerRegistry = FlowerManager.flowerRegistry;
        flowerRegistry.registerAcceptableFlower(Blocks.dragon_egg, "flowersEnd");
        flowerRegistry.registerAcceptableFlower(Blocks.vine, "flowersJungle");
        flowerRegistry.registerAcceptableFlower((Block)Blocks.tallgrass, "flowersJungle");
        flowerRegistry.registerAcceptableFlower(Blocks.wheat, "flowersWheat");
        flowerRegistry.registerAcceptableFlower(Blocks.pumpkin_stem, "flowersGourd");
        flowerRegistry.registerAcceptableFlower(Blocks.melon_stem, "flowersGourd");
        flowerRegistry.registerAcceptableFlower(Blocks.nether_wart, "flowersNether");
        flowerRegistry.registerAcceptableFlower(Blocks.cactus, "flowersCacti");
        flowerRegistry.registerAcceptableFlower((Block)Blocks.double_plant, 0, "flowersVanilla", "flowersSnow");
        flowerRegistry.registerAcceptableFlower((Block)Blocks.double_plant, 1, "flowersVanilla", "flowersSnow");
        flowerRegistry.registerAcceptableFlower((Block)Blocks.double_plant, 4, "flowersVanilla", "flowersSnow");
        flowerRegistry.registerAcceptableFlower((Block)Blocks.double_plant, 5, "flowersVanilla", "flowersSnow");
        for (int meta = 0; meta <= 8; ++meta) {
            flowerRegistry.registerPlantableFlower((Block)Blocks.red_flower, meta, 1.0, "flowersVanilla", "flowersSnow");
        }
        flowerRegistry.registerPlantableFlower((Block)Blocks.yellow_flower, 0, 1.0, "flowersVanilla", "flowersSnow");
        flowerRegistry.registerPlantableFlower((Block)Blocks.brown_mushroom, 0, 1.0, "flowersMushrooms");
        flowerRegistry.registerPlantableFlower((Block)Blocks.red_mushroom, 0, 1.0, "flowersMushrooms");
        flowerRegistry.registerPlantableFlower(Blocks.cactus, 0, 1.0, "flowersCacti");
        for (String flowerType : FlowerManager.flowerRegistry.getFlowerTypes()) {
            Set<IFlower> flowers = FlowerManager.flowerRegistry.getAcceptableFlowers(flowerType);
            ArrayList<String> acceptedFlowerNames = new ArrayList<String>();
            ArrayList<String> plantableFlowerNames = new ArrayList<String>();
            if (flowers != null) {
                for (IFlower flower : flowers) {
                    String name = GameData.getBlockRegistry().getNameForObject((Object)flower.getBlock());
                    if (name == null) {
                        Proxies.log.severe("Could not find name for flower: " + flower + " with type: " + flowerType);
                        continue;
                    }
                    int meta = flower.getMeta();
                    if (flower.getMeta() != Short.MAX_VALUE) {
                        name = name + ':' + meta;
                    }
                    if (flower.isPlantable()) {
                        plantableFlowerNames.add(name);
                        continue;
                    }
                    acceptedFlowerNames.add(name);
                }
            }
            String[] acceptedFlowerNamesArray = acceptedFlowerNames.toArray(new String[acceptedFlowerNames.size()]);
            this.defaultAcceptedFlowers.put(flowerType, acceptedFlowerNamesArray);
            String[] plantableFlowerNamesArray = plantableFlowerNames.toArray(new String[plantableFlowerNames.size()]);
            this.defaultPlantableFlowers.put(flowerType, plantableFlowerNamesArray);
        }
    }

    private static void loadOldConfig() {
        Configuration apicultureConfig = new Configuration();
        forestry.core.config.deprecated.Property property = apicultureConfig.get("render.bees.fancy", CONFIG_CATEGORY, fancyRenderedBees);
        property.comment = "set to true to enable a fancy butterfly-like renderer for bees. (experimental!)";
        fancyRenderedBees = Boolean.parseBoolean(property.value);
        property = apicultureConfig.get("beekeeping.mode", CONFIG_CATEGORY, "NORMAL");
        property.comment = "change beekeeping modes here. possible values EASY, NORMAL, HARD, HARDCORE, INSANE. mods may add additional modes.";
        beekeepingMode = property.value.trim();
        Proxies.log.finer("Beekeeping mode read from config: " + beekeepingMode);
        property = apicultureConfig.get("beekeeping.secondprincess", CONFIG_CATEGORY, secondPrincessChance);
        property.comment = "percent chance of second princess drop, for limited/skyblock maps. Acceptable values up to 2 decimals.";
        secondPrincessChance = Float.parseFloat(property.value);
        property = apicultureConfig.get("species.blacklist", CONFIG_CATEGORY, "");
        property.comment = "add species to blacklist identified by their uid and seperated with ';'.";
        PluginApiculture.parseBeeBlacklist(property.value);
    }

    @Override
    public IGuiHandler getGuiHandler() {
        return new GuiHandlerApiculture();
    }

    @Override
    public IPacketHandler getPacketHandler() {
        return new PacketHandlerApiculture();
    }

    @Override
    protected void registerItems() {
        ForestryItem.beeQueenGE.registerItem(new ItemBeeGE(EnumBeeType.QUEEN), "beeQueenGE");
        ForestryItem.beeDroneGE.registerItem(new ItemBeeGE(EnumBeeType.DRONE), "beeDroneGE");
        ForestryItem.beePrincessGE.registerItem(new ItemBeeGE(EnumBeeType.PRINCESS), "beePrincessGE");
        ForestryItem.beeLarvaeGE.registerItem(new ItemBeeGE(EnumBeeType.LARVAE), "beeLarvaeGE");
        ForestryItem.beealyzer.registerItem(new ItemBeealyzer(), "beealyzer");
        ForestryItem.habitatLocator.registerItem(new ItemHabitatLocator(), "habitatLocator");
        ForestryItem.imprinter.registerItem(new ItemImprinter(), "imprinter");
        ForestryItem.frameUntreated.registerItem(new ItemHiveFrame(80, 0.9f), "frameUntreated");
        ForestryItem.frameImpregnated.registerItem(new ItemHiveFrame(240, 0.4f), "frameImpregnated");
        ForestryItem.frameProven.registerItem(new ItemHiveFrame(720, 0.3f), "frameProven");
        ForestryItem.honeyDrop.registerItem(new ItemOverlay(Tabs.tabApiculture, new ItemOverlay.OverlayInfo("honey", 15512621, 15255572), new ItemOverlay.OverlayInfo("charged", 0x800505, 10225415).setIsSecret(), new ItemOverlay.OverlayInfo("omega", 0x191919, 4885671).setIsSecret()), "honeyDrop");
        OreDictionary.registerOre((String)"dropHoney", (ItemStack)ForestryItem.honeyDrop.getItemStack());
        ForestryItem.pollenCluster.registerItem(new ItemOverlay(Tabs.tabApiculture, new ItemOverlay.OverlayInfo("normal", 10652197, 10652197), new ItemOverlay.OverlayInfo("crystalline", 0xFFFFFF, 12975871)), "pollen");
        OreDictionary.registerOre((String)"itemPollen", (ItemStack)ForestryItem.pollenCluster.getItemStack());
        ForestryItem.propolis.registerItem(new ItemOverlay(Tabs.tabApiculture, new ItemOverlay.OverlayInfo("normal", 12956238), new ItemOverlay.OverlayInfo("sticky", 13012567), new ItemOverlay.OverlayInfo("pulsating", 2936241).setIsSecret(), new ItemOverlay.OverlayInfo("silky", 0xDDFF00)), "propolis");
        ForestryItem.honeydew.registerItem(new ItemForestry().setCreativeTab(Tabs.tabApiculture), "honeydew");
        OreDictionary.registerOre((String)"dropHoneydew", (ItemStack)ForestryItem.honeydew.getItemStack());
        ForestryItem.royalJelly.registerItem(new ItemForestry().setCreativeTab(Tabs.tabApiculture), "royalJelly");
        OreDictionary.registerOre((String)"dropRoyalJelly", (ItemStack)ForestryItem.royalJelly.getItemStack());
        ForestryItem.waxCast.registerItem(new ItemWaxCast().setCreativeTab(Tabs.tabApiculture), "waxCast");
        ForestryItem.beeComb.registerItem(new ItemHoneycomb(), "beeCombs");
        OreDictionary.registerOre((String)"beeComb", (ItemStack)ForestryItem.beeComb.getWildcard());
        ForestryItem.apiaristHat.registerItem((Item)new ItemArmorApiarist(0), "apiaristHelmet");
        ForestryItem.apiaristChest.registerItem((Item)new ItemArmorApiarist(1), "apiaristChest");
        ForestryItem.apiaristLegs.registerItem((Item)new ItemArmorApiarist(2), "apiaristLegs");
        ForestryItem.apiaristBoots.registerItem((Item)new ItemArmorApiarist(3), "apiaristBoots");
        ForestryItem.scoop.registerItem(new ItemScoop(), "scoop");
        ForestryItem.scoop.item().setHarvestLevel("scoop", 3);
    }

    @Override
    protected void registerCrates() {
        ICrateRegistry crateRegistry = StorageManager.crateRegistry;
        crateRegistry.registerCrate(ForestryItem.beeswax.getItemStack(), "cratedBeeswax");
        crateRegistry.registerCrate(ForestryItem.pollenCluster.getItemStack(), "cratedPollen");
        crateRegistry.registerCrate(ForestryItem.propolis.getItemStack(), "cratedPropolis");
        crateRegistry.registerCrate(ForestryItem.honeydew.getItemStack(), "cratedHoneydew");
        crateRegistry.registerCrate(ForestryItem.royalJelly.getItemStack(), "cratedRoyalJelly");
        crateRegistry.registerCrate(ForestryItem.beeComb.getItemStack(1, 0), "cratedHoneycombs");
        crateRegistry.registerCrate(ForestryItem.beeComb.getItemStack(1, 1), "cratedCocoaComb");
        crateRegistry.registerCrate(ForestryItem.beeComb.getItemStack(1, 2), "cratedSimmeringCombs");
        crateRegistry.registerCrate(ForestryItem.beeComb.getItemStack(1, 3), "cratedStringyCombs");
        crateRegistry.registerCrate(ForestryItem.beeComb.getItemStack(1, 4), "cratedFrozenCombs");
        crateRegistry.registerCrate(ForestryItem.beeComb.getItemStack(1, 5), "cratedDrippingCombs");
        crateRegistry.registerCrate(ForestryItem.beeComb.getItemStack(1, 6), "cratedSilkyCombs");
        crateRegistry.registerCrate(ForestryItem.beeComb.getItemStack(1, 7), "cratedParchedCombs");
        crateRegistry.registerCrate(ForestryItem.beeComb.getItemStack(1, 8), "cratedMysteriousCombs");
        crateRegistry.registerCrate(ForestryItem.beeComb.getItemStack(1, 10), "cratedPowderyCombs");
        crateRegistry.registerCrate(ForestryItem.beeComb.getItemStack(1, 14), "cratedWheatenCombs");
        crateRegistry.registerCrate(ForestryItem.beeComb.getItemStack(1, 15), "cratedMossyCombs");
        crateRegistry.registerCrate(ForestryItem.beeComb.getItemStack(1, 16), "cratedMellowCombs");
        crateRegistry.registerCrate(ForestryItem.refractoryWax.getItemStack(), "cratedRefractoryWax");
    }

    @Override
    protected void registerRecipes() {
        Proxies.common.addRecipe(ForestryItem.apiaristHat.getItemStack(), "###", "# #", Character.valueOf('#'), ForestryItem.craftingMaterial.getItemStack(1, 3));
        Proxies.common.addRecipe(ForestryItem.apiaristChest.getItemStack(), "# #", "###", "###", Character.valueOf('#'), ForestryItem.craftingMaterial.getItemStack(1, 3));
        Proxies.common.addRecipe(ForestryItem.apiaristLegs.getItemStack(), "###", "# #", "# #", Character.valueOf('#'), ForestryItem.craftingMaterial.getItemStack(1, 3));
        Proxies.common.addRecipe(ForestryItem.apiaristBoots.getItemStack(), "# #", "# #", Character.valueOf('#'), ForestryItem.craftingMaterial.getItemStack(1, 3));
        Proxies.common.addRecipe(ForestryItem.habitatLocator.getItemStack(), " X ", "X#X", " X ", Character.valueOf('#'), "dustRedstone", Character.valueOf('X'), "ingotBronze");
        Proxies.common.addRecipe(ForestryItem.scoop.getItemStack(1), "#X#", "###", " # ", Character.valueOf('#'), "stickWood", Character.valueOf('X'), Blocks.wool);
        Proxies.common.addRecipe(new ItemStack(Items.slime_ball), new Object[]{"#X#", "#X#", "#X#", Character.valueOf('#'), ForestryItem.propolis, Character.valueOf('X'), ForestryItem.pollenCluster});
        Proxies.common.addRecipe(new ItemStack(Items.speckled_melon), new Object[]{"#X#", "#Y#", "#X#", Character.valueOf('#'), ForestryItem.honeyDrop, Character.valueOf('X'), ForestryItem.honeydew, Character.valueOf('Y'), Items.melon});
        Proxies.common.addRecipe(ForestryItem.frameUntreated.getItemStack(), "###", "#S#", "###", Character.valueOf('#'), "stickWood", Character.valueOf('S'), Items.string);
        Proxies.common.addRecipe(ForestryItem.frameImpregnated.getItemStack(), new Object[]{"###", "#S#", "###", Character.valueOf('#'), ForestryItem.stickImpregnated, Character.valueOf('S'), Items.string});
        if (ForestryItem.honeyedSlice.item() != null) {
            Proxies.common.addRecipe(ForestryItem.honeyedSlice.getItemStack(4), new Object[]{"###", "#X#", "###", Character.valueOf('#'), ForestryItem.honeyDrop, Character.valueOf('X'), Items.bread});
        }
        if (ForestryItem.honeyPot.item() != null) {
            Proxies.common.addRecipe(ForestryItem.honeyPot.getItemStack(1), new Object[]{"# #", " X ", "# #", Character.valueOf('#'), ForestryItem.honeyDrop, Character.valueOf('X'), ForestryItem.waxCapsule});
        }
        if (ForestryItem.ambrosia.item() != null) {
            Proxies.common.addRecipe(ForestryItem.ambrosia.getItemStack(), new Object[]{"#Y#", "XXX", "###", Character.valueOf('#'), ForestryItem.honeydew, Character.valueOf('X'), ForestryItem.royalJelly, Character.valueOf('Y'), ForestryItem.waxCapsule});
        }
        Proxies.common.addRecipe(GameMode.getGameMode().getStackSetting("recipe.output.capsule"), new Object[]{"###", Character.valueOf('#'), ForestryItem.beeswax});
        Proxies.common.addRecipe(GameMode.getGameMode().getStackSetting("recipe.output.refractory"), new Object[]{"###", Character.valueOf('#'), ForestryItem.refractoryWax});
        Proxies.common.addRecipe(ForestryItem.bituminousPeat.getItemStack(), new Object[]{" # ", "XYX", " # ", Character.valueOf('#'), "dustAsh", Character.valueOf('X'), ForestryItem.peat, Character.valueOf('Y'), ForestryItem.propolis});
        Proxies.common.addRecipe(new ItemStack(Blocks.torch, 3), new Object[]{" # ", " # ", " Y ", Character.valueOf('#'), ForestryItem.beeswax, Character.valueOf('Y'), "stickWood"});
        Proxies.common.addRecipe(ForestryItem.craftingMaterial.getItemStack(1, 1), "# #", " # ", "# #", Character.valueOf('#'), ForestryItem.propolis.getItemStack(1, 2));
        Proxies.common.addRecipe(ForestryItem.waxCast.getItemStack(), new Object[]{"###", "# #", "###", Character.valueOf('#'), ForestryItem.beeswax});
        Proxies.common.addRecipe(ForestryBlock.alveary.getItemStack(1, 0), new Object[]{"###", "#X#", "###", Character.valueOf('X'), ForestryItem.impregnatedCasing, Character.valueOf('#'), ForestryItem.craftingMaterial.getItemStack(1, 6)});
        Proxies.common.addRecipe(ForestryBlock.alveary.getItemStack(1, 2), new Object[]{"#G#", " X ", "#G#", Character.valueOf('#'), ForestryItem.tubes.getItemStack(1, 5), Character.valueOf('X'), ForestryBlock.alveary, Character.valueOf('G'), "ingotGold"});
        Proxies.common.addRecipe(ForestryBlock.alveary.getItemStack(1, 3), new Object[]{"I I", " X ", "I#I", Character.valueOf('#'), ForestryItem.tubes.getItemStack(1, 4), Character.valueOf('X'), ForestryBlock.alveary, Character.valueOf('I'), "ingotIron"});
        Proxies.common.addRecipe(ForestryBlock.alveary.getItemStack(1, 4), new Object[]{"#I#", " X ", "YYY", Character.valueOf('#'), ForestryItem.tubes.getItemStack(1, 4), Character.valueOf('X'), ForestryBlock.alveary, Character.valueOf('I'), "ingotIron", Character.valueOf('Y'), "stone"});
        Proxies.common.addRecipe(ForestryBlock.alveary.getItemStack(1, 5), new Object[]{"GIG", "GXG", "GIG", Character.valueOf('X'), ForestryBlock.alveary, Character.valueOf('I'), "ingotIron", Character.valueOf('G'), "blockGlass"});
        Proxies.common.addRecipe(ForestryBlock.alveary.getItemStack(1, 6), new Object[]{"G G", "GXG", "G G", Character.valueOf('X'), ForestryBlock.alveary, Character.valueOf('G'), "gemQuartz"});
        Proxies.common.addRecipe(ForestryBlock.alveary.getItemStack(1, 7), new Object[]{"III", " X ", "WWW", Character.valueOf('X'), ForestryBlock.alveary, Character.valueOf('I'), "ingotIron", Character.valueOf('W'), ForestryItem.craftingMaterial.getItemStack(1, 3)});
        if (PluginManager.Module.FACTORY.isEnabled()) {
            RecipeManagers.squeezerManager.addRecipe(10, new ItemStack[]{ForestryItem.honeyDrop.getItemStack()}, Fluids.HONEY.getFluid(100), ForestryItem.propolis.getItemStack(), 5);
            RecipeManagers.squeezerManager.addRecipe(10, new ItemStack[]{ForestryItem.honeydew.getItemStack()}, Fluids.HONEY.getFluid(100));
            RecipeManagers.squeezerManager.addRecipe(10, new ItemStack[]{ForestryItem.phosphor.getItemStack(2), new ItemStack((Block)Blocks.sand)}, Fluids.LAVA.getFluid(2000));
            RecipeManagers.squeezerManager.addRecipe(10, new ItemStack[]{ForestryItem.phosphor.getItemStack(2), new ItemStack((Block)Blocks.sand, 1, 1)}, Fluids.LAVA.getFluid(2000));
            RecipeManagers.squeezerManager.addRecipe(10, new ItemStack[]{ForestryItem.phosphor.getItemStack(2), new ItemStack(Blocks.dirt)}, Fluids.LAVA.getFluid(1600));
            RecipeManagers.carpenterManager.addRecipe(100, Fluids.WATER.getFluid(2000), null, ForestryItem.beealyzer.getItemStack(), "X#X", "X#X", "RDR", Character.valueOf('#'), "paneGlass", Character.valueOf('X'), "ingotTin", Character.valueOf('R'), "dustRedstone", Character.valueOf('D'), "gemDiamond");
            RecipeManagers.carpenterManager.addRecipe(50, Fluids.HONEY.getFluid(500), null, ForestryItem.craftingMaterial.getItemStack(1, 6), new Object[]{" J ", "###", "WPW", Character.valueOf('#'), "plankWood", Character.valueOf('J'), ForestryItem.royalJelly, Character.valueOf('W'), ForestryItem.beeswax, Character.valueOf('P'), ForestryItem.pollenCluster});
            RecipeManagers.carpenterManager.addRecipe(30, Fluids.WATER.getFluid(600), null, ForestryBlock.candle.getItemStack(24), new Object[]{" X ", "###", "###", Character.valueOf('#'), ForestryItem.beeswax, Character.valueOf('X'), Items.string});
            RecipeManagers.carpenterManager.addRecipe(10, Fluids.WATER.getFluid(200), null, ForestryBlock.candle.getItemStack(6), new Object[]{"#X#", Character.valueOf('#'), ForestryItem.beeswax, Character.valueOf('X'), ForestryItem.craftingMaterial.getItemStack(1, 2)});
            Proxies.common.addShapelessRecipe(ForestryBlock.candle.getItemStack(), ForestryBlock.candle.getItemStack());
            Proxies.common.addShapelessRecipe(ForestryBlock.candle.getItemStack(1, 1), ForestryBlock.candle.getItemStack(1, 1));
            RecipeManagers.centrifugeManager.addRecipe(20, ForestryItem.beeComb.getItemStack(1, 0), (Map<ItemStack, Float>)ImmutableMap.of((Object)ForestryItem.beeswax.getItemStack(), (Object)Float.valueOf(1.0f), (Object)ForestryItem.honeyDrop.getItemStack(), (Object)Float.valueOf(0.9f)));
            RecipeManagers.centrifugeManager.addRecipe(20, ForestryItem.beeComb.getItemStack(1, 1), (Map<ItemStack, Float>)ImmutableMap.of((Object)ForestryItem.beeswax.getItemStack(), (Object)Float.valueOf(1.0f), (Object)new ItemStack(Items.dye, 1, 3), (Object)Float.valueOf(0.5f)));
            RecipeManagers.centrifugeManager.addRecipe(20, ForestryItem.beeComb.getItemStack(1, 2), (Map<ItemStack, Float>)ImmutableMap.of((Object)ForestryItem.refractoryWax.getItemStack(), (Object)Float.valueOf(1.0f), (Object)ForestryItem.phosphor.getItemStack(2), (Object)Float.valueOf(0.7f)));
            RecipeManagers.centrifugeManager.addRecipe(20, ForestryItem.beeComb.getItemStack(1, 3), (Map<ItemStack, Float>)ImmutableMap.of((Object)ForestryItem.propolis.getItemStack(), (Object)Float.valueOf(1.0f), (Object)ForestryItem.honeyDrop.getItemStack(), (Object)Float.valueOf(0.4f)));
            RecipeManagers.centrifugeManager.addRecipe(20, ForestryItem.beeComb.getItemStack(1, 5), (Map<ItemStack, Float>)ImmutableMap.of((Object)ForestryItem.honeydew.getItemStack(), (Object)Float.valueOf(1.0f), (Object)ForestryItem.honeyDrop.getItemStack(), (Object)Float.valueOf(0.4f)));
            RecipeManagers.centrifugeManager.addRecipe(20, ForestryItem.beeComb.getItemStack(1, 4), (Map<ItemStack, Float>)ImmutableMap.of((Object)ForestryItem.beeswax.getItemStack(), (Object)Float.valueOf(0.8f), (Object)ForestryItem.honeyDrop.getItemStack(), (Object)Float.valueOf(0.7f), (Object)new ItemStack(Items.snowball), (Object)Float.valueOf(0.4f), (Object)ForestryItem.pollenCluster.getItemStack(1, 1), (Object)Float.valueOf(0.2f)));
            RecipeManagers.centrifugeManager.addRecipe(20, ForestryItem.beeComb.getItemStack(1, 6), (Map<ItemStack, Float>)ImmutableMap.of((Object)ForestryItem.honeyDrop.getItemStack(), (Object)Float.valueOf(1.0f), (Object)ForestryItem.propolis.getItemStack(1, 3), (Object)Float.valueOf(0.8f)));
            RecipeManagers.centrifugeManager.addRecipe(20, ForestryItem.beeComb.getItemStack(1, 7), (Map<ItemStack, Float>)ImmutableMap.of((Object)ForestryItem.beeswax.getItemStack(), (Object)Float.valueOf(1.0f), (Object)ForestryItem.honeyDrop.getItemStack(), (Object)Float.valueOf(0.9f)));
            RecipeManagers.centrifugeManager.addRecipe(20, ForestryItem.beeComb.getItemStack(1, 8), (Map<ItemStack, Float>)ImmutableMap.of((Object)ForestryItem.propolis.getItemStack(1, 2), (Object)Float.valueOf(1.0f), (Object)ForestryItem.honeyDrop.getItemStack(), (Object)Float.valueOf(0.4f)));
            RecipeManagers.centrifugeManager.addRecipe(20, ForestryItem.beeComb.getItemStack(1, 9), (Map<ItemStack, Float>)ImmutableMap.of());
            RecipeManagers.centrifugeManager.addRecipe(20, ForestryItem.beeComb.getItemStack(1, 10), (Map<ItemStack, Float>)ImmutableMap.of((Object)ForestryItem.honeyDrop.getItemStack(), (Object)Float.valueOf(0.2f), (Object)ForestryItem.beeswax.getItemStack(), (Object)Float.valueOf(0.2f), (Object)new ItemStack(Items.gunpowder), (Object)Float.valueOf(0.9f)));
            RecipeManagers.centrifugeManager.addRecipe(20, ForestryItem.beeComb.getItemStack(1, 14), (Map<ItemStack, Float>)ImmutableMap.of((Object)ForestryItem.honeyDrop.getItemStack(), (Object)Float.valueOf(0.2f), (Object)ForestryItem.beeswax.getItemStack(), (Object)Float.valueOf(0.2f), (Object)new ItemStack(Items.wheat), (Object)Float.valueOf(0.8f)));
            RecipeManagers.centrifugeManager.addRecipe(20, ForestryItem.beeComb.getItemStack(1, 15), (Map<ItemStack, Float>)ImmutableMap.of((Object)ForestryItem.beeswax.getItemStack(), (Object)Float.valueOf(1.0f), (Object)ForestryItem.honeyDrop.getItemStack(), (Object)Float.valueOf(0.9f)));
            RecipeManagers.centrifugeManager.addRecipe(20, ForestryItem.beeComb.getItemStack(1, 16), (Map<ItemStack, Float>)ImmutableMap.of((Object)ForestryItem.honeydew.getItemStack(), (Object)Float.valueOf(0.6f), (Object)ForestryItem.beeswax.getItemStack(), (Object)Float.valueOf(0.2f), (Object)new ItemStack(Items.quartz), (Object)Float.valueOf(0.3f)));
            RecipeManagers.centrifugeManager.addRecipe(5, ForestryItem.propolis.getItemStack(1, 3), (Map<ItemStack, Float>)ImmutableMap.of((Object)ForestryItem.craftingMaterial.getItemStack(1, 2), (Object)Float.valueOf(0.6f), (Object)ForestryItem.propolis.getItemStack(), (Object)Float.valueOf(0.1f)));
            RecipeManagers.fermenterManager.addRecipe(ForestryItem.honeydew.getItemStack(), 500, 1.0f, Fluids.SHORT_MEAD.getFluid(1), Fluids.HONEY.getFluid(1));
        }
        PluginApiculture.definitionAnalyzer.recipes = PluginApiculture.createAlyzerRecipes(ForestryBlock.core.block(), 0);
        definitionAnalyzer.register();
        definitionApiary.register();
        definitionBeehouse.register();
        definitionChest.register();
    }

    private static IRecipe[] createAlyzerRecipes(Block block, int meta) {
        ArrayList<ShapedRecipeCustom> recipes = new ArrayList<ShapedRecipeCustom>();
        recipes.add(ShapedRecipeCustom.createShapedRecipe(new ItemStack(block, 1, meta), new Object[]{"XTX", " Y ", "X X", Character.valueOf('Y'), ForestryItem.sturdyCasing, Character.valueOf('T'), ForestryItem.beealyzer, Character.valueOf('X'), "ingotBronze"}));
        recipes.add(ShapedRecipeCustom.createShapedRecipe(new ItemStack(block, 1, meta), new Object[]{"XTX", " Y ", "X X", Character.valueOf('Y'), ForestryItem.sturdyCasing, Character.valueOf('T'), ForestryItem.treealyzer, Character.valueOf('X'), "ingotBronze"}));
        return recipes.toArray(new IRecipe[recipes.size()]);
    }

    private static void registerBeehiveDrops() {
        ItemStack honeyComb = ForestryItem.beeComb.getItemStack(1, 0);
        hiveRegistry.addDrops("Forestry:forest", new HiveDrop(80, BeeDefinition.FOREST, honeyComb).setIgnobleShare(0.7f), new HiveDrop(8, BeeDefinition.FOREST.getRainResist(), honeyComb), new HiveDrop(3, BeeDefinition.VALIANT, honeyComb));
        hiveRegistry.addDrops("Forestry:meadows", new HiveDrop(80, BeeDefinition.MEADOWS, honeyComb).setIgnobleShare(0.7f), new HiveDrop(3, BeeDefinition.VALIANT, honeyComb));
        ItemStack parchedComb = ForestryItem.beeComb.getItemStack(1, 7);
        hiveRegistry.addDrops("Forestry:desert", new HiveDrop(80, BeeDefinition.MODEST, parchedComb).setIgnobleShare(0.7f), new HiveDrop(3, BeeDefinition.VALIANT, parchedComb));
        ItemStack silkyComb = ForestryItem.beeComb.getItemStack(1, 6);
        hiveRegistry.addDrops("Forestry:jungle", new HiveDrop(80, BeeDefinition.TROPICAL, silkyComb).setIgnobleShare(0.7f), new HiveDrop(3, BeeDefinition.VALIANT, silkyComb));
        ItemStack mysteriousComb = ForestryItem.beeComb.getItemStack(1, 8);
        hiveRegistry.addDrops("Forestry:end", new HiveDrop(90, BeeDefinition.ENDED, mysteriousComb));
        ItemStack frozenComb = ForestryItem.beeComb.getItemStack(1, 4);
        hiveRegistry.addDrops("Forestry:snow", new HiveDrop(80, BeeDefinition.WINTRY, frozenComb).setIgnobleShare(0.5f), new HiveDrop(3, BeeDefinition.VALIANT, frozenComb));
        ItemStack mossyComb = ForestryItem.beeComb.getItemStack(1, 15);
        hiveRegistry.addDrops("Forestry:swamp", new HiveDrop(80, BeeDefinition.MARSHY, mossyComb).setIgnobleShare(0.4f), new HiveDrop(3, BeeDefinition.VALIANT, mossyComb));
    }

    private static void registerDungeonLoot() {
        int rarity = Config.dungeonLootRare ? 5 : 10;
        ChestGenHooks.addItem((String)"dungeonChest", (WeightedRandomChestContent)new WeightedRandomChestContent(BeeDefinition.STEADFAST.getMemberStack(EnumBeeType.DRONE), 1, 1, rarity));
        ItemStack stack = ForestryBlock.candle.getItemStack();
        NBTTagCompound tag = new NBTTagCompound();
        tag.setInteger("colour", 0xFFFFFF);
        stack.setTagCompound(tag);
        ChestGenHooks.addItem((String)"naturalistChest", (WeightedRandomChestContent)new WeightedRandomChestContent(stack, 7, 12, 12));
        ChestGenHooks.addItem((String)"naturalistChest", (WeightedRandomChestContent)new WeightedRandomChestContent(ForestryItem.scoop.getItemStack(), 1, 1, 8));
        ChestGenHooks.addItem((String)"naturalistChest", (WeightedRandomChestContent)new WeightedRandomChestContent(ForestryItem.propolis.getItemStack(), 2, 4, 6));
        ChestGenHooks.addItem((String)"naturalistChest", (WeightedRandomChestContent)new WeightedRandomChestContent(ForestryItem.beeComb.getItemStack(), 4, 12, 7));
        ChestGenHooks.addItem((String)"naturalistChest", (WeightedRandomChestContent)new WeightedRandomChestContent(ForestryItem.beeComb.getItemStack(1, 4), 2, 10, 7));
        ChestGenHooks.addItem((String)"naturalistChest", (WeightedRandomChestContent)new WeightedRandomChestContent(ForestryItem.beeComb.getItemStack(1, 6), 1, 6, 7));
        ChestGenHooks.addItem((String)"naturalistChest", (WeightedRandomChestContent)new WeightedRandomChestContent(BeeDefinition.FOREST.getRainResist().getMemberStack(EnumBeeType.PRINCESS), 1, 1, 5));
        ChestGenHooks.addItem((String)"naturalistChest", (WeightedRandomChestContent)new WeightedRandomChestContent(BeeDefinition.COMMON.getMemberStack(EnumBeeType.DRONE), 1, 2, 8));
        ChestGenHooks.addItem((String)"naturalistChest", (WeightedRandomChestContent)new WeightedRandomChestContent(BeeDefinition.MEADOWS.getMemberStack(EnumBeeType.PRINCESS), 1, 1, 5));
    }

    private static void createHives() {
        hiveRegistry.registerHive("Forestry:forest", HiveDescription.FOREST);
        hiveRegistry.registerHive("Forestry:meadows", HiveDescription.MEADOWS);
        hiveRegistry.registerHive("Forestry:desert", HiveDescription.DESERT);
        hiveRegistry.registerHive("Forestry:jungle", HiveDescription.JUNGLE);
        hiveRegistry.registerHive("Forestry:end", HiveDescription.END);
        hiveRegistry.registerHive("Forestry:snow", HiveDescription.SNOW);
        hiveRegistry.registerHive("Forestry:swamp", HiveDescription.SWAMP);
    }

    private static void createAlleles() {
        IClassification hymnoptera = AlleleManager.alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.ORDER, "hymnoptera", "Hymnoptera");
        AlleleManager.alleleRegistry.getClassification("class.insecta").addMemberGroup(hymnoptera);
        IClassification apidae = AlleleManager.alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.FAMILY, "apidae", "Apidae");
        hymnoptera.addMemberGroup(apidae);
        for (BeeBranchDefinition beeBranch : BeeBranchDefinition.values()) {
            apidae.addMemberGroup(beeBranch.getBranch());
        }
        Allele.effectNone = new AlleleEffectNone("none", true);
        Allele.effectAggressive = new AlleleEffectAggressive();
        Allele.effectHeroic = new AlleleEffectHeroic();
        Allele.effectBeatific = new AlleleEffectPotion("beatific", false, Potion.regeneration, 100);
        Allele.effectMiasmic = new AlleleEffectPotion("miasmic", false, Potion.poison, 600, 100, 0.1f);
        Allele.effectMisanthrope = new AlleleEffectMisanthrope();
        Allele.effectGlacial = new AlleleEffectGlacial();
        Allele.effectRadioactive = new AlleleEffectRadioactive();
        Allele.effectCreeper = new AlleleEffectCreeper();
        Allele.effectIgnition = new AlleleEffectIgnition();
        Allele.effectExploration = new AlleleEffectExploration();
        Allele.effectFestiveEaster = new AlleleEffectNone("festiveEaster", true);
        Allele.effectSnowing = new AlleleEffectSnowing();
        Allele.effectDrunkard = new AlleleEffectPotion("drunkard", false, Potion.confusion, 100);
        Allele.effectReanimation = new AlleleEffectResurrection("reanimation", AlleleEffectResurrection.getReanimationList());
        Allele.effectResurrection = new AlleleEffectResurrection("resurrection", AlleleEffectResurrection.getResurrectionList());
        Allele.effectRepulsion = new AlleleEffectRepulsion();
        Allele.effectFertile = new AlleleEffectFertile();
        Allele.effectMycophilic = new AlleleEffectFungification();
    }

    public static double getSecondPrincessChance() {
        return secondPrincessChance;
    }

    private static void parseAdditionalFlowers(String list, ArrayList<ItemStack> target) {
        List<ItemStack> flowers = StackUtils.parseItemStackStrings(list, 0);
        target.addAll(flowers);
    }

    private static void parseBeeBlacklist(String list) {
        String[] items = list.split("[;]+");
        PluginApiculture.parseBeeBlacklist(items);
    }

    private static void parseBeeBlacklist(String[] items) {
        for (String item : items) {
            if (item.isEmpty()) continue;
            FMLCommonHandler.instance().getFMLLogger().debug("Blacklisting bee species identified by " + item);
            AlleleManager.alleleRegistry.blacklistAllele(item);
        }
    }

    private static void parseAcceptedFlowers(String[] acceptedFlowers, String flowerType) {
        List<StackUtils.Stack> acceptedFlowerItemStacks = StackUtils.parseStackStrings(acceptedFlowers, Short.MAX_VALUE);
        for (StackUtils.Stack acceptedFlower : acceptedFlowerItemStacks) {
            Block acceptedFlowerBlock = acceptedFlower.getBlock();
            int meta = acceptedFlower.getMeta();
            if (acceptedFlowerBlock != null) {
                FlowerManager.flowerRegistry.registerAcceptableFlower(acceptedFlowerBlock, meta, flowerType);
                continue;
            }
            Proxies.log.warning("No block found for '" + acceptedFlower + "' in apiculture config for '" + flowerType + "'.");
        }
    }

    private static void parsePlantableFlowers(Property property, String flowerType) {
        for (String string : property.getStringList()) {
            StackUtils.Stack plantableFlower = StackUtils.parseStackString(string, Short.MAX_VALUE);
            if (plantableFlower == null) continue;
            Block plantableFlowerBlock = plantableFlower.getBlock();
            int meta = plantableFlower.getMeta();
            if (plantableFlowerBlock != null) {
                FlowerManager.flowerRegistry.registerPlantableFlower(plantableFlowerBlock, meta, 1.0, flowerType);
                continue;
            }
            Proxies.log.warning("No block found for '" + plantableFlower + "' in config '" + property.getName() + "'.");
        }
    }

    @Override
    public ISaveEventHandler getSaveEventHandler() {
        return new SaveEventHandlerApiculture();
    }

    @Override
    public void populateChunk(IChunkProvider chunkProvider, World world, Random rand, int chunkX, int chunkZ, boolean hasVillageGenerated) {
        if (Config.getBeehivesAmount() > 0.0) {
            HiveDecorator.decorateHives(chunkProvider, world, rand, chunkX, chunkZ, hasVillageGenerated);
        }
    }

    @Override
    public void populateChunkRetroGen(World world, Random rand, int chunkX, int chunkZ) {
        if (Config.getBeehivesAmount() > 0.0) {
            HiveDecorator.decorateHives(world, rand, chunkX, chunkZ);
        }
    }

    @Override
    public boolean processIMCMessage(FMLInterModComms.IMCMessage message) {
        if (message.key.equals("add-candle-lighting-id")) {
            ItemStack value = message.getItemStackValue();
            if (value != null) {
                BlockCandle.addItemToLightingList(value.getItem());
            } else {
                PluginApiculture.logInvalidIMCMessage(message);
            }
            return true;
        }
        if (message.key.equals("add-alveary-slab") && message.isStringMessage()) {
            String messageString = String.format("Received a '%s' request from mod '%s'. This IMC message has been replaced with the oreDictionary for 'slabWood'. Please contact the author and report this issue.", message.key, message.getSender());
            Proxies.log.warning(messageString);
            return true;
        }
        return super.processIMCMessage(message);
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void textureHook(TextureStitchEvent.Pre event) {
        if (event.map.getTextureType() == 1) {
            EntitySnowFX.icons = new IIcon[3];
            for (int i = 0; i < EntitySnowFX.icons.length; ++i) {
                EntitySnowFX.icons[i] = event.map.registerIcon("forestry:particles/snow." + (i + 1));
            }
        }
    }

    static {
        EMPTY_STRINGS = new String[0];
        beekeepingMode = "NORMAL";
        secondPrincessChance = 0.0f;
        fancyRenderedBees = false;
    }
}

