/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture;

import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.EnumBeeType;
import forestry.api.apiculture.IBeeHousingInventory;
import forestry.core.interfaces.IAccessHandler;
import forestry.core.inventory.InvTools;
import forestry.core.inventory.InventoryAdapterRestricted;
import forestry.core.utils.Utils;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;

public class BeeHousingInventory
extends InventoryAdapterRestricted
implements IBeeHousingInventory {
    public static final int SLOT_QUEEN = 0;
    public static final int SLOT_DRONE = 1;
    public static final int SLOT_PRODUCT_1 = 2;
    public static final int SLOT_PRODUCT_COUNT = 7;

    public BeeHousingInventory(int size, String name, IAccessHandler accessHandler) {
        super(size, name, accessHandler);
    }

    @Override
    public boolean canSlotAccept(int slotIndex, ItemStack itemStack) {
        EnumBeeType beeType = BeeManager.beeRoot.getType(itemStack);
        if (slotIndex == 0) {
            return beeType == EnumBeeType.QUEEN || beeType == EnumBeeType.PRINCESS;
        }
        if (slotIndex == 1) {
            return beeType == EnumBeeType.DRONE;
        }
        return false;
    }

    @Override
    public boolean canExtractItem(int slotIndex, ItemStack itemstack, int side) {
        if (!super.canExtractItem(slotIndex, itemstack, side)) {
            return false;
        }
        return Utils.isIndexInRange(slotIndex, 2, 7);
    }

    @Override
    public final ItemStack getQueen() {
        return this.getStackInSlot(0);
    }

    @Override
    public final ItemStack getDrone() {
        return this.getStackInSlot(1);
    }

    @Override
    public final void setQueen(ItemStack itemstack) {
        this.setInventorySlotContents(0, itemstack);
    }

    @Override
    public final void setDrone(ItemStack itemstack) {
        this.setInventorySlotContents(1, itemstack);
    }

    @Override
    public final boolean addProduct(ItemStack product, boolean all) {
        return InvTools.tryAddStack((IInventory)this, product, 2, 7, all, true);
    }
}

