/*
 * Decompiled with CFR 0.152.
 */
package forestry.mail.network;

import forestry.api.mail.EnumAddressee;
import forestry.core.network.DataInputStreamForestry;
import forestry.core.network.DataOutputStreamForestry;
import forestry.core.network.ForestryPacket;
import forestry.core.network.PacketId;
import java.io.IOException;

public class PacketRequestLetterInfo
extends ForestryPacket {
    private String recipientName;
    private short addressType;

    public PacketRequestLetterInfo(DataInputStreamForestry data) throws IOException {
        super(data);
    }

    public PacketRequestLetterInfo(String recipientName, EnumAddressee addressType) {
        super(PacketId.LETTER_REQUEST_INFO);
        this.recipientName = recipientName;
        this.addressType = (short)addressType.ordinal();
    }

    @Override
    protected void writeData(DataOutputStreamForestry data) throws IOException {
        super.writeData(data);
        data.writeUTF(this.recipientName);
        data.writeShort(this.addressType);
    }

    @Override
    protected void readData(DataInputStreamForestry data) throws IOException {
        super.readData(data);
        this.recipientName = data.readUTF();
        this.addressType = data.readShort();
    }

    public String getRecipientName() {
        return this.recipientName;
    }

    public EnumAddressee getAddressType() {
        return EnumAddressee.values()[this.addressType];
    }
}

