/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.recipes.nei;

import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import forestry.core.utils.ShapedRecipeCustom;
import forestry.factory.recipes.nei.INBTMatchingCachedRecipe;
import forestry.factory.recipes.nei.NEIUtils;
import forestry.factory.recipes.nei.RecipeHandlerBase;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;

public class NEIHandlerShapedCustom
extends RecipeHandlerBase {
    @Override
    public void loadCraftingRecipes(ItemStack result) {
        for (Object recipe : CraftingManager.getInstance().getRecipeList()) {
            if (!(recipe instanceof ShapedRecipeCustom) || !NEIServerUtils.areStacksSameTypeCrafting((ItemStack)((ShapedRecipeCustom)recipe).getRecipeOutput(), (ItemStack)result)) continue;
            CachedShapedCustomRecipe crecipe = new CachedShapedCustomRecipe((ShapedRecipeCustom)recipe);
            NEIUtils.setResultPermutationNBT(crecipe, result);
            this.arecipes.add(crecipe);
        }
    }

    @Override
    public void loadUsageRecipes(ItemStack ingredient) {
        for (Object recipe : CraftingManager.getInstance().getRecipeList()) {
            if (!(recipe instanceof ShapedRecipeCustom)) continue;
            CachedShapedCustomRecipe crecipe = new CachedShapedCustomRecipe((ShapedRecipeCustom)recipe);
            if (crecipe.inputs == null || !crecipe.contains(crecipe.inputs, ingredient)) continue;
            NEIUtils.setIngredientPermutationNBT(crecipe, ingredient);
            this.arecipes.add(crecipe);
        }
    }

    @Override
    public String getRecipeID() {
        return "crafting";
    }

    public String getRecipeName() {
        return NEIUtils.translate("handler.forestry.shaped");
    }

    public String getGuiTexture() {
        return "minecraft:textures/gui/container/crafting_table.png";
    }

    public class CachedShapedCustomRecipe
    extends RecipeHandlerBase.CachedBaseRecipe
    implements INBTMatchingCachedRecipe {
        private final boolean preservesNbt;
        public List<PositionedStack> inputs = new ArrayList<PositionedStack>();
        public PositionedStack output;

        public CachedShapedCustomRecipe(ShapedRecipeCustom recipe) {
            if (recipe.getIngredients() != null && recipe.getIngredients().length > 0) {
                this.setIngredients(recipe.getWidth(), recipe.getHeight(), recipe.getIngredients());
            }
            if (recipe.getRecipeOutput() != null) {
                ItemStack output = recipe.getRecipeOutput();
                this.output = new PositionedStack((Object)output, 119, 24);
            }
            this.preservesNbt = recipe.preservesNbt();
        }

        public void setIngredients(int width, int height, Object[] items) {
            for (int x = 0; x < width; ++x) {
                for (int y = 0; y < height; ++y) {
                    Object item;
                    if (items.length <= y * width + x || (item = items[y * width + x]) == null || item instanceof ItemStack[] && ((ItemStack[])item).length == 0 || item instanceof List && ((List)item).size() == 0) continue;
                    PositionedStack stack = new PositionedStack(item, 25 + x * 18, 6 + y * 18);
                    stack.setMaxSize(1);
                    this.inputs.add(stack);
                }
            }
        }

        public List<PositionedStack> getIngredients() {
            return this.getCycledIngredients(NEIHandlerShapedCustom.this.cycleticks / 20, this.inputs);
        }

        @Override
        public boolean preservesNBT() {
            return this.preservesNbt;
        }

        @Override
        public PositionedStack getResult() {
            return this.output;
        }
    }
}

