/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.multiblock;

import forestry.apiculture.multiblock.AlvearyController;
import forestry.apiculture.multiblock.FakeAlvearyController;
import forestry.apiculture.multiblock.IAlvearyController;
import forestry.apiculture.multiblock.TileAlvearyPlain;
import forestry.core.multiblock.MultiblockControllerBase;
import forestry.core.multiblock.MultiblockValidationException;
import forestry.core.multiblock.rectangular.RectangularMultiblockTileEntityBase;
import net.minecraft.util.StatCollector;

public abstract class TileAlveary
extends RectangularMultiblockTileEntityBase {
    public static final int PLAIN_META = 0;
    public static final int ENTRANCE_META = 1;
    public static final int SWARMER_META = 2;
    public static final int FAN_META = 3;
    public static final int HEATER_META = 4;
    public static final int HYGRO_META = 5;
    public static final int STABILIZER_META = 6;
    public static final int SIEVE_META = 7;

    public int getIcon(int side) {
        return 0;
    }

    @Override
    public void isGoodForExteriorLevel(int level) throws MultiblockValidationException {
        if (level == 2 && !(this instanceof TileAlvearyPlain)) {
            throw new MultiblockValidationException(StatCollector.translateToLocal((String)"for.multiblock.alveary.error.needPlainOnTop"));
        }
    }

    @Override
    public void isGoodForInterior() throws MultiblockValidationException {
        if (!(this instanceof TileAlvearyPlain)) {
            throw new MultiblockValidationException(StatCollector.translateToLocal((String)"for.multiblock.alveary.error.needPlainInterior"));
        }
    }

    @Override
    public void onMachineActivated() {
    }

    @Override
    public void onMachineDeactivated() {
    }

    @Override
    public MultiblockControllerBase createNewMultiblock() {
        return new AlvearyController(this.worldObj);
    }

    @Override
    public Class<? extends MultiblockControllerBase> getMultiblockControllerType() {
        return AlvearyController.class;
    }

    public IAlvearyController getAlvearyController() {
        if (this.isConnected()) {
            return (IAlvearyController)((Object)this.getMultiblockController());
        }
        return FakeAlvearyController.instance;
    }

    @Override
    public void onMachineAssembled(MultiblockControllerBase controller) {
        super.onMachineAssembled(controller);
        if (this.worldObj.isRemote) {
            this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
        }
    }

    @Override
    public void onMachineBroken() {
        super.onMachineBroken();
        if (this.worldObj.isRemote) {
            this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
        }
    }
}

