/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gadgets;

import com.mojang.authlib.GameProfile;
import forestry.core.CreativeTabForestry;
import forestry.core.gadgets.TileForestry;
import forestry.core.interfaces.IOwnable;
import forestry.core.interfaces.IRestrictedAccessTile;
import forestry.core.proxy.Proxies;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import org.apache.logging.log4j.Level;

public abstract class BlockForestry
extends BlockContainer {
    protected BlockForestry(Material material) {
        super(material);
        this.setHardness(1.5f);
        this.setCreativeTab(CreativeTabForestry.tabForestry);
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z) {
        IRestrictedAccessTile restrictedAccessTile;
        TileEntity tile = world.getTileEntity(x, y, z);
        if (tile instanceof IRestrictedAccessTile && !(restrictedAccessTile = (IRestrictedAccessTile)tile).getAccessHandler().allowsRemoval(player)) {
            return false;
        }
        return super.removedByPlayer(world, player, x, y, z);
    }

    public void onBlockPlacedBy(World world, int i, int j, int k, EntityLivingBase entityLiving, ItemStack itemstack) {
        if (!Proxies.common.isSimulating(world)) {
            return;
        }
        if (entityLiving instanceof EntityPlayer) {
            IOwnable ownable;
            TileEntity tile = world.getTileEntity(i, j, k);
            if (tile instanceof IRestrictedAccessTile) {
                ownable = ((IRestrictedAccessTile)tile).getAccessHandler();
            } else if (tile instanceof IOwnable) {
                ownable = (IOwnable)tile;
            } else {
                return;
            }
            EntityPlayer player = (EntityPlayer)entityLiving;
            GameProfile gameProfile = player.getGameProfile();
            ownable.setOwner(gameProfile);
        }
    }

    public void onNeighborBlockChange(World world, int x, int y, int z, Block block) {
        try {
            TileEntity tile = world.getTileEntity(x, y, z);
            if (tile instanceof TileForestry) {
                ((TileForestry)tile).onNeighborBlockChange(block);
            }
        }
        catch (StackOverflowError error) {
            Proxies.log.logThrowable(Level.ERROR, "Stack Overflow Error in BlockMachine.onNeighborBlockChange()", 10, error, new Object[0]);
            throw error;
        }
    }
}

