/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.flowers;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import cpw.mods.fml.common.registry.GameRegistry;
import forestry.api.apiculture.IBee;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.IBeeModifier;
import forestry.api.genetics.IFlower;
import forestry.api.genetics.IFlowerGrowthRule;
import forestry.api.genetics.IFlowerRegistry;
import forestry.api.genetics.IIndividual;
import forestry.apiculture.BeeHousingModifier;
import forestry.apiculture.flowers.Flower;
import forestry.apiculture.flowers.VanillaDefaultGrowthRule;
import forestry.apiculture.flowers.VanillaDirtGrassGrowthRule;
import forestry.apiculture.flowers.VanillaFertilizeGrowthRule;
import forestry.apiculture.flowers.VanillaFlowerPotGrowthRule;
import forestry.apiculture.flowers.VanillaMyceliumGrowthRule;
import forestry.apiculture.flowers.VanillaSnowGrowthRule;
import forestry.core.vect.MutableVect;
import forestry.core.vect.Vect;
import forestry.plugins.PluginManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFlowerPot;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFlowerPot;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;

public final class FlowerRegistry
implements IFlowerRegistry {
    private final Set<String> defaultFlowerTypes = ImmutableSet.of((Object)"flowersVanilla", (Object)"flowersNether", (Object)"flowersCacti", (Object)"flowersMushrooms", (Object)"flowersEnd", (Object)"flowersJungle", (Object[])new String[]{"flowersSnow", "flowersWheat", "flowersGourd"});
    private final HashMultimap<String, Block> registeredBlocks = HashMultimap.create();
    private final HashMultimap<String, IFlower> registeredFlowers = HashMultimap.create();
    private final ArrayListMultimap<String, IFlowerGrowthRule> growthRules = ArrayListMultimap.create();
    private final Map<String, TreeMap<Double, IFlower>> chances = new HashMap<String, TreeMap<Double, IFlower>>();

    public FlowerRegistry() {
        this.registerVanillaGrowthRules();
    }

    @Override
    public void registerAcceptableFlower(Block block, String ... flowerTypes) {
        this.registerFlower(block, Short.MAX_VALUE, 0.0, flowerTypes);
    }

    @Override
    public void registerAcceptableFlower(Block block, int meta, String ... flowerTypes) {
        this.registerFlower(block, meta, 0.0, flowerTypes);
    }

    @Override
    public void registerPlantableFlower(Block block, int meta, double weight, String ... flowerTypes) {
        this.registerFlower(block, meta, weight, flowerTypes);
    }

    private void registerFlower(Block block, int meta, double weight, String ... flowerTypes) {
        if (block == null) {
            return;
        }
        if (weight <= 0.0) {
            weight = 0.0;
        }
        if (weight >= 1.0) {
            weight = 1.0;
        }
        Flower newFlower = new Flower(block, meta, weight);
        for (String flowerType : flowerTypes) {
            if (flowerType == null) {
                throw new NullPointerException("Tried to register flower with null type. " + block);
            }
            Set flowers = this.registeredFlowers.get((Object)flowerType);
            flowers.add(newFlower);
            Set blocks = this.registeredBlocks.get((Object)flowerType);
            blocks.add(block);
            if (!this.chances.containsKey(flowerType)) continue;
            this.chances.remove(flowerType);
        }
    }

    private static Vect getArea(IBeeGenome genome, IBeeModifier beeModifier) {
        int[] genomeTerritory = genome.getTerritory();
        float housingModifier = beeModifier.getTerritoryModifier(genome, 1.0f);
        return new Vect(genomeTerritory).multiply(housingModifier * 3.0f);
    }

    @Override
    public ChunkCoordinates getAcceptedFlowerCoordinates(IBeeHousing beeHousing, IBee bee, String flowerType) {
        if (!this.registeredFlowers.containsKey((Object)flowerType)) {
            return null;
        }
        Set acceptedBlocks = this.registeredBlocks.get((Object)flowerType);
        Set acceptedFlowers = this.registeredFlowers.get((Object)flowerType);
        World world = beeHousing.getWorld();
        BeeHousingModifier beeModifier = new BeeHousingModifier(beeHousing);
        Vect area = FlowerRegistry.getArea(bee.getGenome(), beeModifier);
        Vect housingPos = new Vect(beeHousing.getCoordinates()).add(-area.x / 2, -area.y / 2, -area.z / 2);
        MutableVect posCurrent = new MutableVect(0, 0, 0);
        while (posCurrent.advancePositionInArea(area)) {
            Vect posBlock = Vect.add(housingPos, posCurrent);
            if (!FlowerRegistry.isAcceptedFlower(flowerType, acceptedBlocks, acceptedFlowers, world, posBlock.x, posBlock.y, posBlock.z)) continue;
            return new ChunkCoordinates(posBlock.x, posBlock.y, posBlock.z);
        }
        return null;
    }

    @Override
    public boolean isAcceptedFlower(String flowerType, World world, int x, int y, int z) {
        if (!this.registeredFlowers.containsKey((Object)flowerType)) {
            return false;
        }
        Set acceptedBlocks = this.registeredBlocks.get((Object)flowerType);
        Set acceptedFlowers = this.registeredFlowers.get((Object)flowerType);
        return FlowerRegistry.isAcceptedFlower(flowerType, acceptedBlocks, acceptedFlowers, world, x, y, z);
    }

    private static boolean isAcceptedFlower(String flowerType, Set<Block> acceptedBlocks, Set<IFlower> acceptedFlowers, World world, int x, int y, int z) {
        Block cropBlock;
        int meta;
        Block block = world.getBlock(x, y, z);
        if (block instanceof BlockFlowerPot) {
            TileEntity tile = world.getTileEntity(x, y, z);
            TileEntityFlowerPot tileFlowerPot = (TileEntityFlowerPot)tile;
            Item item = tileFlowerPot.getFlowerPotItem();
            block = Block.getBlockFromItem((Item)item);
            meta = tileFlowerPot.getFlowerPotData();
        } else {
            if (!acceptedBlocks.contains(block)) {
                return false;
            }
            meta = world.getBlockMetadata(x, y, z);
        }
        if (PluginManager.Module.AGRICRAFT.isEnabled() && (flowerType.equals("flowersWheat") || flowerType.equals("flowersNether")) && block == (cropBlock = GameRegistry.findBlock((String)"AgriCraft", (String)"crops"))) {
            ArrayList drops = block.getDrops(world, x, y, z, 7, 0);
            if (((ItemStack)drops.get(1)).getItem() == Items.wheat_seeds && flowerType.equals("flowersWheat")) {
                return true;
            }
            if (((ItemStack)drops.get(1)).getItem() == Items.nether_wart && flowerType.equals("flowersNether")) {
                return true;
            }
        }
        Flower flower = new Flower(block, meta, 0.0);
        return acceptedFlowers.contains(flower);
    }

    @Override
    public boolean growFlower(String flowerType, World world, IIndividual individual, int x, int y, int z) {
        if (!this.growthRules.containsKey((Object)flowerType)) {
            return false;
        }
        for (IFlowerGrowthRule rule : this.growthRules.get((Object)flowerType)) {
            if (!rule.growFlower(this, flowerType, world, individual, x, y, z)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<IFlower> getAcceptableFlowers(String flowerType) {
        return this.registeredFlowers.get((Object)flowerType);
    }

    @Override
    public void registerGrowthRule(IFlowerGrowthRule rule, String ... flowerTypes) {
        if (rule == null) {
            return;
        }
        for (String flowerType : flowerTypes) {
            this.growthRules.get((Object)flowerType).add(rule);
        }
    }

    @Override
    public IFlower getRandomPlantableFlower(String flowerType, Random rand) {
        TreeMap<Double, IFlower> chancesMap = this.getChancesMap(flowerType);
        double maxKey = chancesMap.lastKey() + 1.0;
        return chancesMap.get(chancesMap.lowerKey(rand.nextDouble() * maxKey));
    }

    @Override
    public Collection<String> getFlowerTypes() {
        return new ArrayList<String>((Collection<String>)Sets.union(this.defaultFlowerTypes, (Set)this.registeredFlowers.keySet()));
    }

    private TreeMap<Double, IFlower> getChancesMap(String flowerType) {
        if (!this.chances.containsKey(flowerType)) {
            TreeMap<Double, IFlower> flowerChances = new TreeMap<Double, IFlower>();
            double count = 0.0;
            for (IFlower flower : this.registeredFlowers.get((Object)flowerType)) {
                if (!flower.isPlantable()) continue;
                flowerChances.put(count, flower);
                count += flower.getWeight();
            }
            this.chances.put(flowerType, flowerChances);
        }
        return this.chances.get(flowerType);
    }

    private void registerVanillaGrowthRules() {
        this.registerGrowthRule(new VanillaDirtGrassGrowthRule(), "flowersVanilla", "flowersSnow");
        this.registerGrowthRule(new VanillaSnowGrowthRule(), "flowersSnow");
        this.registerGrowthRule(new VanillaFlowerPotGrowthRule(), "flowersVanilla", "flowersSnow", "flowersMushrooms", "flowersCacti", "flowersJungle");
        this.registerGrowthRule(new VanillaMyceliumGrowthRule(), "flowersMushrooms");
        this.registerGrowthRule(new VanillaDefaultGrowthRule(), "flowersEnd");
        this.registerGrowthRule(new VanillaFertilizeGrowthRule(Blocks.melon_stem, Blocks.pumpkin_stem), "flowersGourd");
        this.registerGrowthRule(new VanillaFertilizeGrowthRule(Blocks.wheat), "flowersWheat");
    }
}

