/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.genetics;

import forestry.api.genetics.IGenome;
import forestry.api.genetics.IIndividualLiving;
import forestry.core.genetics.Individual;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public abstract class IndividualLiving
extends Individual
implements IIndividualLiving {
    private int health;
    private int maxHealth;

    protected IndividualLiving() {
    }

    protected IndividualLiving(int newHealth) {
        this.health = this.maxHealth = newHealth;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.health = nbttagcompound.getInteger("Health");
        this.maxHealth = nbttagcompound.getInteger("MaxH");
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        NBTTagCompound NBTmachine;
        super.writeToNBT(nbttagcompound);
        nbttagcompound.setInteger("Health", this.health);
        nbttagcompound.setInteger("MaxH", this.maxHealth);
        if (this.getGenome() != null) {
            NBTmachine = new NBTTagCompound();
            this.getGenome().writeToNBT(NBTmachine);
            nbttagcompound.setTag("Genome", (NBTBase)NBTmachine);
        }
        if (this.getMate() != null) {
            NBTmachine = new NBTTagCompound();
            this.getMate().writeToNBT(NBTmachine);
            nbttagcompound.setTag("Mate", (NBTBase)NBTmachine);
        }
    }

    @Override
    public abstract IGenome getMate();

    @Override
    public boolean isAlive() {
        return this.health > 0;
    }

    @Override
    public int getHealth() {
        return this.health;
    }

    @Override
    public int getMaxHealth() {
        return this.maxHealth;
    }

    @Override
    public void age(World world, float lifespanModifier) {
        float ageModifier;
        if (lifespanModifier < 0.001f) {
            this.health = 0;
            return;
        }
        for (ageModifier = 1.0f / lifespanModifier; ageModifier > 1.0f; ageModifier -= 1.0f) {
            this.decreaseHealth();
        }
        if (world.rand.nextFloat() < ageModifier) {
            this.decreaseHealth();
        }
    }

    private void decreaseHealth() {
        if (this.health > 0) {
            --this.health;
        }
    }
}

