/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.utils;

import cofh.api.energy.IEnergyConnection;
import cofh.api.energy.IEnergyReceiver;
import forestry.core.gadgets.Engine;
import forestry.core.vect.Vect;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCocoa;
import net.minecraft.block.BlockLog;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockUtil {
    public static ArrayList<ItemStack> getBlockDrops(World world, Vect posBlock) {
        Block block = world.getBlock(posBlock.x, posBlock.y, posBlock.z);
        int meta = world.getBlockMetadata(posBlock.x, posBlock.y, posBlock.z);
        return block.getDrops(world, posBlock.x, posBlock.y, posBlock.z, meta, 0);
    }

    public static boolean isEnergyReceiverOrEngine(ForgeDirection side, TileEntity tile) {
        if (!(tile instanceof IEnergyReceiver) && !(tile instanceof Engine)) {
            return false;
        }
        IEnergyConnection receptor = (IEnergyConnection)tile;
        return receptor.canConnectEnergy(side);
    }

    public static boolean tryPlantPot(World world, int x, int y, int z, Block block) {
        int direction = BlockUtil.getDirectionalMetadata(world, x, y, z);
        if (direction < 0) {
            return false;
        }
        world.setBlock(x, y, z, block, direction, 3);
        return true;
    }

    public static int getDirectionalMetadata(World world, int x, int y, int z) {
        for (int i = 0; i < 4; ++i) {
            if (!BlockUtil.isValidPot(world, x, y, z, i)) continue;
            return i;
        }
        return -1;
    }

    public static boolean isValidPot(World world, int x, int y, int z, int notchDirection) {
        Block block = world.getBlock(x += Direction.offsetX[notchDirection], y, z += Direction.offsetZ[notchDirection]);
        if (block == Blocks.log) {
            return BlockLog.func_150165_c((int)world.getBlockMetadata(x, y, z)) == 3;
        }
        return block.isWood((IBlockAccess)world, x, y, z);
    }

    public static int getMaturityPod(int metadata) {
        return BlockCocoa.func_149987_c((int)metadata);
    }
}

