/*
 * Decompiled with CFR 0.152.
 */
package forestry.plugins;

import cpw.mods.fml.common.IFuelHandler;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.registry.GameData;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.VillagerRegistry;
import forestry.api.arboriculture.EnumFruitFamily;
import forestry.api.arboriculture.EnumGermlingType;
import forestry.api.arboriculture.TreeManager;
import forestry.api.core.Tabs;
import forestry.api.genetics.AlleleManager;
import forestry.api.recipes.RecipeManagers;
import forestry.api.storage.ICrateRegistry;
import forestry.api.storage.StorageManager;
import forestry.arboriculture.FruitProviderNone;
import forestry.arboriculture.FruitProviderPod;
import forestry.arboriculture.FruitProviderRandom;
import forestry.arboriculture.FruitProviderRipening;
import forestry.arboriculture.GuiHandlerArboriculture;
import forestry.arboriculture.VillageHandlerArboriculture;
import forestry.arboriculture.WoodType;
import forestry.arboriculture.commands.CommandTree;
import forestry.arboriculture.gadgets.BlockArbFence;
import forestry.arboriculture.gadgets.BlockArbStairs;
import forestry.arboriculture.gadgets.BlockFruitPod;
import forestry.arboriculture.gadgets.BlockLog;
import forestry.arboriculture.gadgets.BlockPlanks;
import forestry.arboriculture.gadgets.BlockSapling;
import forestry.arboriculture.gadgets.BlockSlab;
import forestry.arboriculture.gadgets.ForestryBlockLeaves;
import forestry.arboriculture.gadgets.TileArboristChest;
import forestry.arboriculture.gadgets.TileFruitPod;
import forestry.arboriculture.gadgets.TileLeaves;
import forestry.arboriculture.gadgets.TileSapling;
import forestry.arboriculture.gadgets.TileWood;
import forestry.arboriculture.genetics.AlleleFruit;
import forestry.arboriculture.genetics.AlleleGrowth;
import forestry.arboriculture.genetics.AlleleLeafEffectNone;
import forestry.arboriculture.genetics.GrowthProvider;
import forestry.arboriculture.genetics.GrowthProviderTropical;
import forestry.arboriculture.genetics.TreeBranchDefinition;
import forestry.arboriculture.genetics.TreeDefinition;
import forestry.arboriculture.genetics.TreeFactory;
import forestry.arboriculture.genetics.TreeHelper;
import forestry.arboriculture.genetics.TreeMutationFactory;
import forestry.arboriculture.genetics.TreekeepingMode;
import forestry.arboriculture.items.ItemGermlingGE;
import forestry.arboriculture.items.ItemGrafter;
import forestry.arboriculture.items.ItemLeavesBlock;
import forestry.arboriculture.items.ItemTreealyzer;
import forestry.arboriculture.items.ItemWoodBlock;
import forestry.arboriculture.network.PacketHandlerArboriculture;
import forestry.arboriculture.proxy.ProxyArboriculture;
import forestry.core.GameMode;
import forestry.core.config.Config;
import forestry.core.config.ForestryBlock;
import forestry.core.config.ForestryItem;
import forestry.core.fluids.Fluids;
import forestry.core.gadgets.BlockBase;
import forestry.core.gadgets.MachineDefinition;
import forestry.core.genetics.alleles.Allele;
import forestry.core.items.ItemForestryBlock;
import forestry.core.items.ItemFruit;
import forestry.core.network.IPacketHandler;
import forestry.core.proxy.Proxies;
import forestry.core.utils.RecipeUtil;
import forestry.core.utils.ShapedRecipeCustom;
import forestry.core.utils.ShapelessRecipeCustom;
import forestry.factory.recipes.FabricatorRecipe;
import forestry.plugins.ForestryPlugin;
import forestry.plugins.Plugin;
import forestry.plugins.PluginCore;
import forestry.plugins.PluginManager;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraftforge.common.ChestGenHooks;
import net.minecraftforge.oredict.OreDictionary;

@Plugin(pluginID="Arboriculture", name="Arboriculture", author="Binnie & SirSengir", url="http://forestry.sengir.net/", unlocalizedDescription="for.plugin.arboriculture.description")
public class PluginArboriculture
extends ForestryPlugin {
    @SidedProxy(clientSide="forestry.arboriculture.proxy.ClientProxyArboriculture", serverSide="forestry.arboriculture.proxy.ProxyArboriculture")
    public static ProxyArboriculture proxy;
    public static String treekeepingMode;
    public static int modelIdSaplings;
    public static int modelIdLeaves;
    public static int modelIdFences;
    public static int modelIdPods;
    private static MachineDefinition definitionChest;
    public static final List<Block> validFences;

    @Override
    protected void setupAPI() {
        super.setupAPI();
        TreeManager.treeFactory = new TreeFactory();
        TreeManager.treeMutationFactory = new TreeMutationFactory();
        TreeManager.treeRoot = new TreeHelper();
        AlleleManager.alleleRegistry.registerSpeciesRoot(TreeManager.treeRoot);
        TreeManager.treeRoot.registerTreekeepingMode(TreekeepingMode.easy);
        TreeManager.treeRoot.registerTreekeepingMode(TreekeepingMode.normal);
        TreeManager.treeRoot.registerTreekeepingMode(TreekeepingMode.hard);
        TreeManager.treeRoot.registerTreekeepingMode(TreekeepingMode.hardcore);
        TreeManager.treeRoot.registerTreekeepingMode(TreekeepingMode.insane);
    }

    @Override
    public void preInit() {
        super.preInit();
        ForestryBlock.logs.registerBlock(new BlockLog(false), ItemWoodBlock.class, "logs");
        OreDictionary.registerOre((String)"logWood", (ItemStack)ForestryBlock.logs.getWildcard());
        ForestryBlock.planks.registerBlock(new BlockPlanks(false), ItemWoodBlock.class, "planks");
        OreDictionary.registerOre((String)"plankWood", (ItemStack)ForestryBlock.planks.getWildcard());
        ForestryBlock.slabs.registerBlock((Block)new BlockSlab(false), ItemWoodBlock.class, "slabs");
        OreDictionary.registerOre((String)"slabWood", (ItemStack)ForestryBlock.slabs.getWildcard());
        ForestryBlock.fences.registerBlock((Block)new BlockArbFence(false), ItemWoodBlock.class, "fences");
        OreDictionary.registerOre((String)"fenceWood", (ItemStack)ForestryBlock.fences.getWildcard());
        ForestryBlock.stairs.registerBlock((Block)new BlockArbStairs(ForestryBlock.planks.block(), false), ItemWoodBlock.class, "stairs");
        OreDictionary.registerOre((String)"stairWood", (ItemStack)ForestryBlock.stairs.getWildcard());
        ForestryBlock.logsFireproof.registerBlock(new BlockLog(true), ItemWoodBlock.class, "logsFireproof");
        ForestryBlock.planksFireproof.registerBlock(new BlockPlanks(true), ItemWoodBlock.class, "planksFireproof");
        ForestryBlock.slabsFireproof.registerBlock((Block)new BlockSlab(true), ItemWoodBlock.class, "slabsFireproof");
        ForestryBlock.fencesFireproof.registerBlock((Block)new BlockArbFence(true), ItemWoodBlock.class, "fencesFireproof");
        ForestryBlock.stairsFireproof.registerBlock((Block)new BlockArbStairs(ForestryBlock.planksFireproof.block(), true), ItemWoodBlock.class, "stairsFireproof");
        for (WoodType woodType : WoodType.VALUES) {
            woodType.registerLog(ForestryBlock.logs.block(), false);
            woodType.registerPlanks(ForestryBlock.planks.block(), false);
            woodType.registerSlab(ForestryBlock.slabs.block(), false);
            woodType.registerFence(ForestryBlock.fences.block(), false);
            woodType.registerStairs(ForestryBlock.stairs.block(), false);
            woodType.registerLog(ForestryBlock.logsFireproof.block(), true);
            woodType.registerPlanks(ForestryBlock.planksFireproof.block(), true);
            woodType.registerSlab(ForestryBlock.slabsFireproof.block(), true);
            woodType.registerFence(ForestryBlock.fencesFireproof.block(), true);
            woodType.registerStairs(ForestryBlock.stairsFireproof.block(), true);
        }
        ForestryBlock.saplingGE.registerBlock((Block)new BlockSapling(), ItemForestryBlock.class, "saplingGE");
        OreDictionary.registerOre((String)"treeSapling", (ItemStack)ForestryBlock.saplingGE.getWildcard());
        ForestryBlock.leaves.registerBlock((Block)new ForestryBlockLeaves(), ItemLeavesBlock.class, "leaves");
        OreDictionary.registerOre((String)"treeLeaves", (ItemStack)ForestryBlock.leaves.getWildcard());
        ForestryBlock.pods.registerBlock((Block)new BlockFruitPod(), ItemForestryBlock.class, "pods");
        ForestryBlock.arboriculture.registerBlock((Block)new BlockBase(Material.iron), ItemForestryBlock.class, "arboriculture");
        ForestryBlock.arboriculture.block().setCreativeTab(Tabs.tabArboriculture);
        definitionChest = ((BlockBase)ForestryBlock.arboriculture.block()).addDefinition(new MachineDefinition(0, "forestry.ArbChest", TileArboristChest.class, ShapedRecipeCustom.createShapedRecipe(ForestryBlock.arboriculture.getItemStack(1, 0), " # ", "XYX", "XXX", Character.valueOf('#'), "blockGlass", Character.valueOf('X'), "treeSapling", Character.valueOf('Y'), "chestWood")).setFaces(0, 1, 2, 3, 4, 4, 0, 7));
        proxy.initializeRendering();
        validFences.add(ForestryBlock.fences.block());
        validFences.add(ForestryBlock.fencesFireproof.block());
        validFences.add(Blocks.fence);
        validFences.add(Blocks.fence_gate);
        validFences.add(Blocks.nether_brick_fence);
        PluginCore.rootCommand.addChildCommand(new CommandTree());
    }

    @Override
    public void doInit() {
        super.doInit();
        PluginArboriculture.createAlleles();
        TreeDefinition.initTrees();
        PluginArboriculture.registerErsatzGenomes();
        GameRegistry.registerTileEntity(TileSapling.class, (String)"forestry.Sapling");
        GameRegistry.registerTileEntity(TileLeaves.class, (String)"forestry.Leaves");
        GameRegistry.registerTileEntity(TileWood.class, (String)"forestry.Wood");
        GameRegistry.registerTileEntity(TileFruitPod.class, (String)"forestry.Pods");
        definitionChest.register();
        if (Config.enableVillagers) {
            VillagerRegistry.instance().registerVillagerId(81);
            Proxies.render.registerVillagerSkin(81, "textures/entity/lumberjack.png");
            VillagerRegistry.instance().registerVillageTradeHandler(81, (VillagerRegistry.IVillageTradeHandler)new VillageHandlerArboriculture());
        }
    }

    @Override
    public void postInit() {
        super.postInit();
        PluginArboriculture.registerDungeonLoot();
    }

    @Override
    protected void registerItems() {
        ForestryItem.sapling.registerItem(new ItemGermlingGE(EnumGermlingType.SAPLING), "sapling");
        OreDictionary.registerOre((String)"treeSapling", (ItemStack)ForestryItem.sapling.getWildcard());
        if (PluginManager.Module.APICULTURE.isEnabled()) {
            ForestryItem.pollenFertile.registerItem(new ItemGermlingGE(EnumGermlingType.POLLEN), "pollenFertile");
            ForestryItem.treealyzer.registerItem(new ItemTreealyzer(), "treealyzer");
        }
        ForestryItem.grafter.registerItem(new ItemGrafter(4), "grafter");
        ForestryItem.grafterProven.registerItem(new ItemGrafter(149), "grafterProven");
    }

    @Override
    protected void registerCrates() {
        ICrateRegistry crateRegistry = StorageManager.crateRegistry;
        crateRegistry.registerCrate(ItemFruit.EnumFruit.CHERRY.getStack(), "cratedCherry");
        crateRegistry.registerCrate(ItemFruit.EnumFruit.WALNUT.getStack(), "cratedWalnut");
        crateRegistry.registerCrate(ItemFruit.EnumFruit.CHESTNUT.getStack(), "cratedChestnut");
        crateRegistry.registerCrate(ItemFruit.EnumFruit.LEMON.getStack(), "cratedLemon");
        crateRegistry.registerCrate(ItemFruit.EnumFruit.PLUM.getStack(), "cratedPlum");
        crateRegistry.registerCrate(ItemFruit.EnumFruit.PAPAYA.getStack(), "cratedPapaya");
        crateRegistry.registerCrate(ItemFruit.EnumFruit.DATES.getStack(), "cratedDates");
    }

    @Override
    protected void registerRecipes() {
        Proxies.common.addSmelting(ForestryBlock.logs.getWildcard(), new ItemStack(Items.coal, 1, 1), 0.15f);
        ShapelessRecipeCustom.buildRecipe(ForestryBlock.planks.getItemStack(4), ForestryBlock.logs.getWildcard()).setPreserveNBT();
        ShapelessRecipeCustom.buildRecipe(ForestryBlock.planksFireproof.getItemStack(4), ForestryBlock.logsFireproof.getWildcard()).setPreserveNBT();
        if (PluginManager.Module.FACTORY.isEnabled() && PluginManager.Module.APICULTURE.isEnabled()) {
            RecipeManagers.fabricatorManager.addRecipe(new FabricatorRecipe(null, Fluids.GLASS.getFluid(500), ForestryBlock.logsFireproof.getItemStack(), new Object[]{" # ", "#X#", " # ", Character.valueOf('#'), ForestryItem.refractoryWax, Character.valueOf('X'), ForestryBlock.logs.getWildcard()}).setPreserveNBT());
            RecipeManagers.fabricatorManager.addRecipe(new FabricatorRecipe(null, Fluids.GLASS.getFluid(500), ForestryBlock.planksFireproof.getItemStack(5), new Object[]{"X#X", "#X#", "X#X", Character.valueOf('#'), ForestryItem.refractoryWax, Character.valueOf('X'), ForestryBlock.planks.getWildcard()}).setPreserveNBT());
        }
        ShapedRecipeCustom.buildPriorityRecipe(ForestryBlock.slabs.getItemStack(6), "###", Character.valueOf('#'), ForestryBlock.planks.getWildcard()).setPreserveNBT();
        ShapedRecipeCustom.buildPriorityRecipe(ForestryBlock.slabsFireproof.getItemStack(6), "###", Character.valueOf('#'), ForestryBlock.planksFireproof.getWildcard()).setPreserveNBT();
        ShapedRecipeCustom.buildRecipe(ForestryBlock.fences.getItemStack(3), "#X#", "#X#", Character.valueOf('#'), ForestryBlock.planks.getWildcard(), Character.valueOf('X'), "stickWood").setPreserveNBT();
        ShapedRecipeCustom.buildRecipe(ForestryBlock.fencesFireproof.getItemStack(3), "#X#", "#X#", Character.valueOf('#'), ForestryBlock.planksFireproof.getWildcard(), Character.valueOf('X'), "stickWood").setPreserveNBT();
        if (PluginManager.Module.FACTORY.isEnabled()) {
            RecipeManagers.carpenterManager.addRecipe(100, Fluids.WATER.getFluid(2000), null, ForestryItem.treealyzer.getItemStack(), "X#X", "X#X", "RDR", Character.valueOf('#'), "paneGlass", Character.valueOf('X'), "ingotCopper", Character.valueOf('R'), "dustRedstone", Character.valueOf('D'), "gemDiamond");
            int seedOilMultiplier = GameMode.getGameMode().getIntegerSetting("squeezer.liquid.seed");
            int juiceMultiplier = GameMode.getGameMode().getIntegerSetting("squeezer.liquid.apple");
            int mulchMultiplier = GameMode.getGameMode().getIntegerSetting("squeezer.mulch.apple");
            RecipeManagers.squeezerManager.addRecipe(20, new ItemStack[]{ItemFruit.EnumFruit.CHERRY.getStack()}, Fluids.SEEDOIL.getFluid(5 * seedOilMultiplier), ForestryItem.mulch.getItemStack(), 5);
            RecipeManagers.squeezerManager.addRecipe(60, new ItemStack[]{ItemFruit.EnumFruit.WALNUT.getStack()}, Fluids.SEEDOIL.getFluid(18 * seedOilMultiplier), ForestryItem.mulch.getItemStack(), 5);
            RecipeManagers.squeezerManager.addRecipe(70, new ItemStack[]{ItemFruit.EnumFruit.CHESTNUT.getStack()}, Fluids.SEEDOIL.getFluid(22 * seedOilMultiplier), ForestryItem.mulch.getItemStack(), 2);
            RecipeManagers.squeezerManager.addRecipe(10, new ItemStack[]{ItemFruit.EnumFruit.LEMON.getStack()}, Fluids.JUICE.getFluid(juiceMultiplier * 2), ForestryItem.mulch.getItemStack(), (int)Math.floor((float)mulchMultiplier * 0.5f));
            RecipeManagers.squeezerManager.addRecipe(10, new ItemStack[]{ItemFruit.EnumFruit.PLUM.getStack()}, Fluids.JUICE.getFluid((int)Math.floor((float)juiceMultiplier * 0.5f)), ForestryItem.mulch.getItemStack(), mulchMultiplier * 3);
            RecipeManagers.squeezerManager.addRecipe(10, new ItemStack[]{ItemFruit.EnumFruit.PAPAYA.getStack()}, Fluids.JUICE.getFluid(juiceMultiplier * 3), ForestryItem.mulch.getItemStack(), (int)Math.floor((float)mulchMultiplier * 0.5f));
            RecipeManagers.squeezerManager.addRecipe(10, new ItemStack[]{ItemFruit.EnumFruit.DATES.getStack()}, Fluids.JUICE.getFluid((int)Math.floor((double)juiceMultiplier * 0.25)), ForestryItem.mulch.getItemStack(), mulchMultiplier);
            RecipeUtil.injectLeveledRecipe(ForestryItem.sapling.getItemStack(), GameMode.getGameMode().getIntegerSetting("fermenter.yield.sapling"), Fluids.BIOMASS);
        }
        ShapedRecipeCustom.buildPriorityRecipe(ForestryBlock.stairs.getItemStack(4), "#  ", "## ", "###", Character.valueOf('#'), ForestryBlock.planks.getWildcard()).setPreserveNBT();
        ShapedRecipeCustom.buildPriorityRecipe(ForestryBlock.stairsFireproof.getItemStack(4), "#  ", "## ", "###", Character.valueOf('#'), ForestryBlock.planksFireproof.getWildcard()).setPreserveNBT();
        Proxies.common.addRecipe(ForestryItem.grafter.getItemStack(), "  B", " # ", "#  ", Character.valueOf('B'), "ingotBronze", Character.valueOf('#'), "stickWood");
    }

    private static void createAlleles() {
        TreeBranchDefinition.createAlleles();
        Allele.fruitNone = new AlleleFruit("none", new FruitProviderNone("none", null));
        Allele.fruitApple = new AlleleFruit("apple", new FruitProviderRandom("apple", EnumFruitFamily.POMES, new ItemStack(Items.apple), 1.0f).setColour(0xFF2E2E).setOverlay("pomes"));
        Allele.fruitCocoa = new AlleleFruit("cocoa", new FruitProviderPod("cocoa", EnumFruitFamily.JUNGLE, FruitProviderPod.EnumPodType.COCOA, new ItemStack[0]));
        Allele.fruitChestnut = new AlleleFruit("chestnut", new FruitProviderRipening("chestnut", EnumFruitFamily.NUX, ItemFruit.EnumFruit.CHESTNUT.getStack(), 1.0f).setRipeningPeriod(6).setColours(8336189, 12898890).setOverlay("nuts"), true);
        Allele.fruitWalnut = new AlleleFruit("walnut", new FruitProviderRipening("walnut", EnumFruitFamily.NUX, ItemFruit.EnumFruit.WALNUT.getStack(), 1.0f).setRipeningPeriod(8).setColours(16491080, 12898890).setOverlay("nuts"), true);
        Allele.fruitCherry = new AlleleFruit("cherry", new FruitProviderRipening("cherry", EnumFruitFamily.PRUNES, ItemFruit.EnumFruit.CHERRY.getStack(), 1.0f).setColours(0xFF2E2E, 12898890).setOverlay("berries"), true);
        Allele.fruitDates = new AlleleFruit("dates", new FruitProviderPod("dates", EnumFruitFamily.JUNGLE, FruitProviderPod.EnumPodType.DATES, ItemFruit.EnumFruit.DATES.getStack(4)));
        Allele.fruitPapaya = new AlleleFruit("papaya", new FruitProviderPod("papaya", EnumFruitFamily.JUNGLE, FruitProviderPod.EnumPodType.PAPAYA, ItemFruit.EnumFruit.PAPAYA.getStack()));
        Allele.fruitLemon = new AlleleFruit("lemon", new FruitProviderRipening("lemon", EnumFruitFamily.PRUNES, ItemFruit.EnumFruit.LEMON.getStack(), 1.0f).setColours(0xEEEE00, 0x99FF00).setOverlay("citrus"), true);
        Allele.fruitPlum = new AlleleFruit("plum", new FruitProviderRipening("plum", EnumFruitFamily.PRUNES, ItemFruit.EnumFruit.PLUM.getStack(), 1.0f).setColours(0x663446, 15662874).setOverlay("plums"), true);
        Allele.growthLightlevel = new AlleleGrowth("lightlevel", new GrowthProvider());
        Allele.growthAcacia = new AlleleGrowth("acacia", new GrowthProvider());
        Allele.growthTropical = new AlleleGrowth("tropical", new GrowthProviderTropical());
        Allele.leavesNone = new AlleleLeafEffectNone();
    }

    private static void registerErsatzGenomes() {
        AlleleManager.ersatzSpecimen.put(new ItemStack((Block)Blocks.leaves, 1, 0), TreeDefinition.Oak.getIndividual());
        AlleleManager.ersatzSpecimen.put(new ItemStack((Block)Blocks.leaves, 1, 1), TreeDefinition.Spruce.getIndividual());
        AlleleManager.ersatzSpecimen.put(new ItemStack((Block)Blocks.leaves, 1, 2), TreeDefinition.Birch.getIndividual());
        AlleleManager.ersatzSpecimen.put(new ItemStack((Block)Blocks.leaves, 1, 3), TreeDefinition.Jungle.getIndividual());
        AlleleManager.ersatzSpecimen.put(new ItemStack((Block)Blocks.leaves2, 1, 0), TreeDefinition.Acacia.getIndividual());
        AlleleManager.ersatzSpecimen.put(new ItemStack((Block)Blocks.leaves2, 1, 1), TreeDefinition.DarkOak.getIndividual());
        AlleleManager.ersatzSaplings.put(new ItemStack(Blocks.sapling, 1, 0), TreeDefinition.Oak.getIndividual());
        AlleleManager.ersatzSaplings.put(new ItemStack(Blocks.sapling, 1, 1), TreeDefinition.Spruce.getIndividual());
        AlleleManager.ersatzSaplings.put(new ItemStack(Blocks.sapling, 1, 2), TreeDefinition.Birch.getIndividual());
        AlleleManager.ersatzSaplings.put(new ItemStack(Blocks.sapling, 1, 3), TreeDefinition.Jungle.getIndividual());
        AlleleManager.ersatzSaplings.put(new ItemStack(Blocks.sapling, 1, 4), TreeDefinition.Acacia.getIndividual());
        AlleleManager.ersatzSaplings.put(new ItemStack(Blocks.sapling, 1, 5), TreeDefinition.DarkOak.getIndividual());
    }

    @Override
    public IGuiHandler getGuiHandler() {
        return new GuiHandlerArboriculture();
    }

    @Override
    public IFuelHandler getFuelHandler() {
        return new FuelHandler();
    }

    @Override
    public IPacketHandler getPacketHandler() {
        return new PacketHandlerArboriculture();
    }

    @Override
    public boolean processIMCMessage(FMLInterModComms.IMCMessage message) {
        if (message.key.equals("add-fence-block") && message.isStringMessage()) {
            Block block = (Block)GameData.getBlockRegistry().getRaw(message.getStringValue());
            if (block != null && block != Blocks.air) {
                validFences.add(block);
            } else {
                PluginArboriculture.logInvalidIMCMessage(message);
            }
            return true;
        }
        return super.processIMCMessage(message);
    }

    private static void registerDungeonLoot() {
        ChestGenHooks.addItem((String)"naturalistChest", (WeightedRandomChestContent)new WeightedRandomChestContent(ForestryItem.grafter.getItemStack(), 1, 1, 8));
        ChestGenHooks.addItem((String)"naturalistChest", (WeightedRandomChestContent)new WeightedRandomChestContent(TreeDefinition.Oak.getMemberStack(EnumGermlingType.SAPLING), 2, 3, 6));
        ChestGenHooks.addItem((String)"naturalistChest", (WeightedRandomChestContent)new WeightedRandomChestContent(TreeDefinition.Spruce.getMemberStack(EnumGermlingType.SAPLING), 2, 3, 6));
        ChestGenHooks.addItem((String)"naturalistChest", (WeightedRandomChestContent)new WeightedRandomChestContent(TreeDefinition.Birch.getMemberStack(EnumGermlingType.SAPLING), 2, 3, 6));
        ChestGenHooks.addItem((String)"naturalistChest", (WeightedRandomChestContent)new WeightedRandomChestContent(TreeDefinition.Larch.getMemberStack(EnumGermlingType.SAPLING), 1, 2, 4));
        ChestGenHooks.addItem((String)"naturalistChest", (WeightedRandomChestContent)new WeightedRandomChestContent(TreeDefinition.Lime.getMemberStack(EnumGermlingType.SAPLING), 1, 2, 4));
        if (PluginManager.Module.APICULTURE.isEnabled()) {
            ChestGenHooks.addItem((String)"naturalistChest", (WeightedRandomChestContent)new WeightedRandomChestContent(TreeDefinition.Oak.getMemberStack(EnumGermlingType.POLLEN), 2, 3, 4));
            ChestGenHooks.addItem((String)"naturalistChest", (WeightedRandomChestContent)new WeightedRandomChestContent(TreeDefinition.Spruce.getMemberStack(EnumGermlingType.POLLEN), 2, 3, 4));
            ChestGenHooks.addItem((String)"naturalistChest", (WeightedRandomChestContent)new WeightedRandomChestContent(TreeDefinition.Birch.getMemberStack(EnumGermlingType.POLLEN), 2, 3, 4));
            ChestGenHooks.addItem((String)"naturalistChest", (WeightedRandomChestContent)new WeightedRandomChestContent(TreeDefinition.Larch.getMemberStack(EnumGermlingType.POLLEN), 1, 2, 3));
            ChestGenHooks.addItem((String)"naturalistChest", (WeightedRandomChestContent)new WeightedRandomChestContent(TreeDefinition.Lime.getMemberStack(EnumGermlingType.POLLEN), 1, 2, 3));
        }
    }

    static {
        treekeepingMode = "NORMAL";
        validFences = new ArrayList<Block>();
    }

    private static class FuelHandler
    implements IFuelHandler {
        private FuelHandler() {
        }

        public int getBurnTime(ItemStack fuel) {
            if (ForestryItem.sapling.isItemEqual(fuel)) {
                return 100;
            }
            if (ForestryBlock.slabs.isItemEqual(fuel)) {
                return 150;
            }
            return 0;
        }
    }
}

