/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.recipes.nei;

import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import forestry.factory.gadgets.MachineSqueezer;
import forestry.factory.gui.GuiSqueezer;
import forestry.factory.recipes.ISqueezerRecipe;
import forestry.factory.recipes.nei.NEIUtils;
import forestry.factory.recipes.nei.PositionedFluidTank;
import forestry.factory.recipes.nei.PositionedStackAdv;
import forestry.factory.recipes.nei.RecipeHandlerBase;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;
import net.minecraftforge.fluids.FluidStack;

public class NEIHandlerSqueezer
extends RecipeHandlerBase {
    private static final int[][] INPUTS = new int[][]{{0, 0}, {1, 0}, {2, 0}, {0, 1}, {1, 1}, {2, 1}, {0, 2}, {1, 2}, {2, 2}};

    @Override
    public String getRecipeID() {
        return "forestry.squeezer";
    }

    public String getRecipeName() {
        return StatCollector.translateToLocal((String)"tile.for.factory.5.name");
    }

    public String getGuiTexture() {
        return "forestry:textures/gui/squeezersocket.png";
    }

    public void loadTransferRects() {
        this.addTransferRect(72, 29, 41, 18);
    }

    public void drawExtras(int recipeIndex) {
        TemplateRecipeHandler.CachedRecipe recipe = (TemplateRecipeHandler.CachedRecipe)this.arecipes.get(recipeIndex);
        if (recipe instanceof CachedSqueezerRecipe) {
            int processingTime = ((CachedSqueezerRecipe)recipe).processingTime;
            this.drawProgressBar(70, 30, 176, 60, 43, 18, processingTime * 5, 0);
        }
    }

    public Class<? extends GuiContainer> getGuiClass() {
        return GuiSqueezer.class;
    }

    @Override
    public void loadAllRecipes() {
        for (ISqueezerRecipe recipe : MachineSqueezer.RecipeManager.recipes) {
            this.arecipes.add(new CachedSqueezerRecipe(recipe, true));
        }
    }

    @Override
    public void loadCraftingRecipes(ItemStack result) {
        super.loadCraftingRecipes(result);
        for (ISqueezerRecipe recipe : MachineSqueezer.RecipeManager.recipes) {
            if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)recipe.getRemnants(), (ItemStack)result)) continue;
            this.arecipes.add(new CachedSqueezerRecipe(recipe, true));
        }
    }

    @Override
    public void loadCraftingRecipes(FluidStack result) {
        for (ISqueezerRecipe recipe : MachineSqueezer.RecipeManager.recipes) {
            if (!NEIUtils.areFluidsSameType(recipe.getFluidOutput(), result)) continue;
            this.arecipes.add(new CachedSqueezerRecipe(recipe, true));
        }
    }

    @Override
    public void loadUsageRecipes(ItemStack ingred) {
        for (ISqueezerRecipe recipe : MachineSqueezer.RecipeManager.recipes) {
            CachedSqueezerRecipe crecipe = new CachedSqueezerRecipe(recipe);
            if (crecipe.inputs == null || !crecipe.contains(crecipe.inputs, ingred)) continue;
            crecipe.generatePermutations();
            crecipe.setIngredientPermutation(crecipe.inputs, ingred);
            this.arecipes.add(crecipe);
        }
    }

    public class CachedSqueezerRecipe
    extends RecipeHandlerBase.CachedBaseRecipe {
        public List<PositionedStack> inputs = new ArrayList<PositionedStack>();
        public PositionedFluidTank tank;
        public PositionedStackAdv remnants = null;
        public int processingTime;

        public CachedSqueezerRecipe(ISqueezerRecipe recipe, boolean genPerms) {
            if (recipe.getResources() != null) {
                this.setIngredients(recipe.getResources());
            }
            if (recipe.getFluidOutput() != null) {
                this.tank = new PositionedFluidTank(recipe.getFluidOutput(), 10000, new Rectangle(117, 7, 16, 58), NEIHandlerSqueezer.this.getGuiTexture(), new Point(176, 0));
            }
            if (recipe.getRemnants() != null) {
                this.remnants = new PositionedStackAdv(recipe.getRemnants(), 92, 49).setChance(recipe.getRemnantsChance());
            }
            this.processingTime = recipe.getProcessingTime();
            if (genPerms) {
                this.generatePermutations();
            }
        }

        public CachedSqueezerRecipe(ISqueezerRecipe recipe) {
            this(recipe, false);
        }

        public void setIngredients(Object[] inputs) {
            int i = 0;
            for (Object stack : inputs) {
                if (i >= INPUTS.length) {
                    return;
                }
                this.inputs.add(new PositionedStack(stack, 12 + INPUTS[i][0] * 18, 10 + INPUTS[i][1] * 18, false));
                ++i;
            }
        }

        public List<PositionedStack> getIngredients() {
            return this.getCycledIngredients(NEIHandlerSqueezer.this.cycleticks / 20, this.inputs);
        }

        @Override
        public PositionedFluidTank getFluidTank() {
            return this.tank;
        }

        public PositionedStack getResult() {
            return this.remnants;
        }

        public void generatePermutations() {
            for (PositionedStack p : this.inputs) {
                p.generatePermutations();
            }
        }
    }
}

