/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.inventory;

import forestry.core.config.Defaults;
import forestry.core.interfaces.IAccessHandler;
import forestry.core.inventory.InventoryAdapter;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;

public class InventoryAdapterRestricted
extends InventoryAdapter {
    private final IAccessHandler accessHandler;

    public InventoryAdapterRestricted(int size, String name, IAccessHandler accessHandler) {
        super(size, name);
        this.accessHandler = accessHandler;
    }

    public InventoryAdapterRestricted(int size, String name, int stackLimit, IAccessHandler accessHandler) {
        super(size, name, stackLimit);
        this.accessHandler = accessHandler;
    }

    @Override
    public final boolean isUseableByPlayer(EntityPlayer player) {
        return this.accessHandler.allowsViewing(player);
    }

    @Override
    public boolean isItemValidForSlot(int slotIndex, ItemStack itemStack) {
        if (itemStack == null || !this.accessHandler.allowsPipeConnections()) {
            return false;
        }
        return this.canSlotAccept(slotIndex, itemStack);
    }

    @Override
    public int[] getAccessibleSlotsFromSide(int side) {
        if (!this.accessHandler.allowsPipeConnections()) {
            return Defaults.SLOTS_NONE;
        }
        return super.getAccessibleSlotsFromSide(side);
    }

    @Override
    public final boolean canInsertItem(int slotIndex, ItemStack itemStack, int side) {
        if (itemStack == null || !this.accessHandler.allowsPipeConnections()) {
            return false;
        }
        return this.isItemValidForSlot(slotIndex, itemStack);
    }

    @Override
    public boolean canExtractItem(int slotIndex, ItemStack itemStack, int side) {
        return itemStack != null && this.accessHandler.allowsPipeConnections();
    }
}

