/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.items;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.core.proxy.Proxies;
import forestry.core.render.TextureManager;
import forestry.core.utils.StringUtil;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class ItemCrated
extends Item {
    private final ItemStack contained;
    private final boolean usesOreDict;

    public ItemCrated(ItemStack contained, boolean usesOreDict) {
        this.contained = contained;
        this.usesOreDict = usesOreDict;
    }

    public boolean usesOreDict() {
        return this.usesOreDict;
    }

    public ItemStack getContained() {
        return this.contained;
    }

    public ItemStack onItemRightClick(ItemStack itemstack, World world, EntityPlayer entityplayer) {
        if (Proxies.common.isSimulating(world)) {
            if (this.contained == null || itemstack.stackSize == 0) {
                return itemstack;
            }
            --itemstack.stackSize;
            EntityItem entity = new EntityItem(world, entityplayer.posX, entityplayer.posY, entityplayer.posZ, new ItemStack(this.contained.getItem(), 9, this.contained.getItemDamage()));
            entity.delayBeforeCanPickup = 40;
            float f1 = 0.3f;
            entity.motionX = -MathHelper.sin((float)(entityplayer.rotationYaw / 180.0f * 3.141593f)) * MathHelper.cos((float)(entityplayer.rotationPitch / 180.0f * 3.141593f)) * f1;
            entity.motionZ = MathHelper.cos((float)(entityplayer.rotationYaw / 180.0f * 3.141593f)) * MathHelper.cos((float)(entityplayer.rotationPitch / 180.0f * 3.141593f)) * f1;
            entity.motionY = -MathHelper.sin((float)(entityplayer.rotationPitch / 180.0f * 3.141593f)) * f1 + 0.1f;
            f1 = 0.02f;
            float f3 = world.rand.nextFloat() * 3.141593f * 2.0f;
            entity.motionX += Math.cos(f3) * (double)(f1 *= world.rand.nextFloat());
            entity.motionY += (double)((world.rand.nextFloat() - world.rand.nextFloat()) * 0.1f);
            entity.motionZ += Math.sin(f3) * (double)f1;
            world.spawnEntityInWorld((Entity)entity);
        }
        return itemstack;
    }

    public String getItemStackDisplayName(ItemStack itemstack) {
        if (this.contained == null) {
            return StatCollector.translateToLocal((String)"item.for.crate.name");
        }
        String containedName = Proxies.common.getDisplayName(this.contained);
        return StringUtil.localizeAndFormat("item.crated.grammar", containedName);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister register) {
        String textureName = this.contained == null ? "crate" : "crate-filled";
        this.itemIcon = TextureManager.getInstance().registerTex(register, textureName);
    }
}

